/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.svn.SvnEntriesListener;
import org.jetbrains.idea.svn.SvnUtil;

public class SvnEntriesFileListener
extends VirtualFileAdapter {
    private final Project myProject;
    private final Collection<SvnEntriesListener> myListeners = new ArrayList<SvnEntriesListener>();

    public SvnEntriesFileListener(Project project) {
        this.myProject = project;
    }

    public void fileCreated(VirtualFileEvent event) {
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (file != null && SvnUtil.SVN_ADMIN_DIR_NAME.equals(file.getName()) && event.getParent() != null) {
            VirtualFile parent = event.getParent();
            this.fireFileStatusesChanged(parent);
            this.fileEntriesChanged(parent);
        }
    }

    public void contentsChanged(VirtualFileEvent event) {
        VirtualFile grandParent;
        VirtualFile parent;
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (file != null && SvnEntriesFileListener.isEntriesFile(file) && file.getParent() != null && (parent = file.getParent()) != null && (grandParent = parent.getParent()) != null) {
            this.fireFileStatusesChanged(grandParent);
            this.fileEntriesChanged(grandParent);
        }
    }

    public void fileDeleted(VirtualFileEvent event) {
        if (!event.isFromRefresh()) {
            return;
        }
        VirtualFile file = event.getFile();
        if (file != null && SvnUtil.SVN_ADMIN_DIR_NAME.equals(file.getName()) && event.getParent() != null) {
            VirtualFile parent = event.getParent();
            this.fireFileStatusesChanged(parent);
            this.fileEntriesChanged(parent);
        }
    }

    private void fileEntriesChanged(final VirtualFile parent) {
        final SvnEntriesListener[] listeners = this.myListeners.toArray(new SvnEntriesListener[this.myListeners.size()]);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < listeners.length; ++i) {
                    SvnEntriesListener listener = listeners[i];
                    listener.onEntriesChanged(parent);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    public void addListener(SvnEntriesListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(SvnEntriesListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireFileStatusesChanged(VirtualFile parent) {
        VirtualFile[] children = parent.getChildren();
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(children.length + 1);
        files.add(parent);
        Collections.addAll(files, children);
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(files, null);
    }

    private static boolean isEntriesFile(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return !file.isDirectory() && "entries".equals(file.getName()) && parent != null && SvnUtil.SVN_ADMIN_DIR_NAME.equals(parent.getName());
    }
}

