/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.Collection;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnStatusWorker {
    private final SvnVcs myVcs;
    private final Collection<File> myTouchedFiles;
    private final File myRoot;
    private final boolean myIsTotalUpdate;
    private final UpdatedFiles myPostUpdateFiles;
    private final Collection<VcsException> myExceptions;

    public SvnStatusWorker(SvnVcs vcs, Collection<File> touchedFiles, File root, UpdatedFiles postUpdateFiles, boolean isTotalUpdate, Collection<VcsException> exceptions) {
        this.myVcs = vcs;
        this.myTouchedFiles = touchedFiles;
        this.myRoot = root;
        this.myPostUpdateFiles = postUpdateFiles;
        this.myIsTotalUpdate = isTotalUpdate;
        this.myExceptions = exceptions;
    }

    public void doStatus() {
        try {
            SVNStatusClient statusClient = this.myVcs.createStatusClient();
            statusClient.setIgnoreExternals(false);
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.update.computing.post.update.status", this.myRoot.getAbsolutePath()));
            }
            final VcsKey vcsKey = SvnVcs.getKey();
            statusClient.doStatus(this.myRoot, true, false, false, false, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) {
                    if (status.getFile() == null) {
                        return;
                    }
                    if (SvnStatusWorker.this.myIsTotalUpdate && status.getContentsStatus() == SVNStatusType.STATUS_UNVERSIONED && status.getFile().isDirectory()) {
                        SvnStatusWorker.this.myTouchedFiles.add(status.getFile());
                    }
                    if (status.getContentsStatus() != SVNStatusType.STATUS_EXTERNAL && status.getContentsStatus() != SVNStatusType.STATUS_IGNORED && status.getContentsStatus() != SVNStatusType.STATUS_MISSING && status.getContentsStatus() != SVNStatusType.STATUS_INCOMPLETE && (status.getContentsStatus() != SVNStatusType.STATUS_NONE || status.getPropertiesStatus() == SVNStatusType.STATUS_NONE)) {
                        String path = status.getFile().getAbsolutePath();
                        if (status.getContentsStatus() == SVNStatusType.STATUS_ADDED) {
                            SvnStatusWorker.this.myPostUpdateFiles.getGroupById("LOCALLY_ADDED").add(path, vcsKey, null);
                        } else if (status.getContentsStatus() == SVNStatusType.STATUS_CONFLICTED) {
                            FileGroup group = SvnStatusWorker.this.myPostUpdateFiles.getGroupById("MERGED_WITH_CONFLICTS");
                            if (!(group == null || group.getFiles() != null && group.getFiles().contains(path))) {
                                group.add(path, vcsKey, null);
                            }
                        } else if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
                            SvnStatusWorker.this.myPostUpdateFiles.getGroupById("LOCALLY_REMOVED").add(path, vcsKey, null);
                        } else if (status.getContentsStatus() == SVNStatusType.STATUS_REPLACED) {
                            SvnStatusWorker.this.myPostUpdateFiles.getGroupById("LOCALLY_ADDED").add(path, vcsKey, null);
                        } else if (status.getContentsStatus() == SVNStatusType.STATUS_MODIFIED || status.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED) {
                            SvnStatusWorker.this.myPostUpdateFiles.getGroupById("MODIFIED").add(path, vcsKey, null);
                        } else if (!(status.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED && status.getContentsStatus() != SVNStatusType.STATUS_OBSTRUCTED || !status.getFile().isFile() && SVNWCUtil.isVersionedDirectory((File)status.getFile()))) {
                            SvnStatusWorker.this.myPostUpdateFiles.getGroupById("UNKNOWN").add(path, vcsKey, null);
                        }
                    }
                }
            });
        }
        catch (SVNException e) {
            this.myExceptions.add(new VcsException((Throwable)e));
        }
    }
}

