/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementFactory;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenUrlConverter;
import org.jetbrains.idea.maven.dom.converters.repositories.MavenRepositoriesProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositoryBase;
import org.jetbrains.idea.maven.dom.references.MavenUrlPsiReference;
import org.jetbrains.idea.maven.utils.MavenIcons;

public abstract class MavenRepositoryConverter
extends ResolvingConverter<String> {
    @Nullable
    private static String getRepositoryId(ConvertContext context) {
        MavenDomRepositoryBase repository = (MavenDomRepositoryBase)context.getInvocationElement().getParentOfType(MavenDomRepositoryBase.class, false);
        if (repository != null) {
            return repository.getId().getStringValue();
        }
        return null;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext convertContext) {
        return s;
    }

    public static class Url
    extends MavenUrlConverter {
        @Override
        @NotNull
        public PsiReference[] createReferences(GenericDomValue value, PsiElement element, final ConvertContext context) {
            String text = value.getStringValue();
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
            PsiReference[] psiReferenceArray = new PsiReference[]{new MavenUrlPsiReference(element, text, range){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray;
                    String name;
                    Module module = context.getModule();
                    if (module != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryUrl(MavenRepositoryConverter.getRepositoryId(context))))) {
                        objectArray = new Object[]{name};
                        if (objectArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Url$1.getVariants must not return null");
                        return objectArray;
                    }
                    objectArray = super.getVariants();
                    if (objectArray != null) return objectArray;
                    throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Url$1.getVariants must not return null");
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Url.createReferences must not return null");
            }
            return psiReferenceArray;
        }
    }

    public static class Name
    extends MavenRepositoryConverter {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Collection<String> getVariants(ConvertContext context) {
            Set<String> set;
            String name;
            Module module = context.getModule();
            if (module != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryName(MavenRepositoryConverter.getRepositoryId(context))))) {
                set = Collections.singleton(name);
                if (set == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Name.getVariants must not return null");
                return set;
            }
            set = Collections.emptySet();
            if (set != null) return set;
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Name.getVariants must not return null");
        }
    }

    public static class Id
    extends MavenRepositoryConverter {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Collection<String> getVariants(ConvertContext context) {
            Set<Object> set;
            Module module = context.getModule();
            if (module != null) {
                set = MavenRepositoriesProvider.getInstance().getRepositoryIds();
                if (set == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Id.getVariants must not return null");
                return set;
            }
            set = Collections.emptySet();
            if (set != null) return set;
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Id.getVariants must not return null");
        }

        public LookupElement createLookupElement(String s) {
            MutableLookupElement element = LookupElementFactory.getInstance().createLookupElement((Object)s, s).setIcon(MavenIcons.REPOSITORY_ICON).setTailText(" (" + MavenRepositoriesProvider.getInstance().getRepositoryUrl(s) + ")", true);
            return element;
        }
    }
}

