/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.DomFileElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModulePsiReference
extends MavenPsiReference
implements LocalQuickFixProvider {
    public MavenModulePsiReference(PsiElement element, String text, TextRange range) {
        super(element, text, range);
    }

    public PsiElement resolve() {
        String relPath;
        VirtualFile baseDir = this.myPsiFile.getVirtualFile().getParent();
        VirtualFile file = baseDir.findFileByRelativePath(relPath = FileUtil.toSystemIndependentName((String)(this.myText + "/" + "pom.xml")));
        if (file == null) {
            return null;
        }
        return this.getPsiFile(file);
    }

    @NotNull
    public Object[] getVariants() {
        List<DomFileElement<MavenDomProjectModel>> files = MavenDomUtil.collectProjectModels(this.getProject());
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (DomFileElement<MavenDomProjectModel> eachDomFile : files) {
            VirtualFile eachVFile = eachDomFile.getOriginalFile().getVirtualFile();
            if (eachVFile == this.myVirtualFile) continue;
            XmlFile psiFile = eachDomFile.getFile();
            String modulePath = MavenModulePsiReference.calcRelativeModulePath(this.myVirtualFile, eachVFile);
            result.add(LookupElementBuilder.create((Object)psiFile, (String)modulePath).setPresentableText(modulePath));
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenModulePsiReference.getVariants must not return null");
        }
        return objectArray;
    }

    public static String calcRelativeModulePath(VirtualFile parentPom, VirtualFile modulePom) {
        String result = MavenDomUtil.calcRelativePath(parentPom.getParent(), modulePom);
        int to = result.length() - "/pom.xml".length();
        if (to < 0) {
            throw new RuntimeException("Filed to calculate relative path for:\nparentPom: " + parentPom + "(valid: " + parentPom.isValid() + ")" + "\nmodulePom: " + modulePom + "(valid: " + modulePom.isValid() + ")" + "\nequals:" + parentPom.equals(modulePom));
        }
        return result.substring(0, to);
    }

    private PsiFile getPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.getProject()).findFile(file);
    }

    private Project getProject() {
        return this.myPsiFile.getProject();
    }

    public LocalQuickFix[] getQuickFixes() {
        if (this.myText.length() == 0 || this.resolve() != null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new CreateModuleFix(true), new CreateModuleFix(false)};
    }

    private class CreateModuleFix
    implements LocalQuickFix {
        private final boolean myWithParent;

        private CreateModuleFix(boolean withParent) {
            this.myWithParent = withParent;
        }

        @NotNull
        public String getName() {
            String string = this.myWithParent ? MavenDomBundle.message("fix.create.module.with.parent", new Object[0]) : MavenDomBundle.message("fix.create.module", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor d) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix.applyFix must not be null");
            }
            if (d == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/dom/references/MavenModulePsiReference$CreateModuleFix.applyFix must not be null");
            }
            try {
                VirtualFile modulePom = this.createModulePom();
                MavenId id = MavenDomUtil.describe(MavenModulePsiReference.this.myPsiFile);
                String groupId = id.getGroupId() == null ? "groupId" : id.getGroupId();
                String artifactId = modulePom.getParent().getName();
                String version = id.getVersion() == null ? "version" : id.getVersion();
                MavenUtil.runOrApplyMavenProjectFileTemplate(project, modulePom, new MavenId(groupId, artifactId, version), this.myWithParent ? id : null, true);
            }
            catch (IOException e) {
                MavenUtil.showError(project, "Cannot create a module", e);
            }
        }

        private VirtualFile createModulePom() throws IOException {
            VirtualFile baseDir = MavenModulePsiReference.this.myVirtualFile.getParent();
            String modulePath = PathUtil.getCanonicalPath((String)(baseDir.getPath() + "/" + MavenModulePsiReference.this.myText));
            VirtualFile moduleDir = VfsUtil.createDirectories((String)modulePath);
            return moduleDir.createChildData((Object)this, "pom.xml");
        }
    }
}

