/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MissingOverrideAnnotationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("override" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection.getID must not return null");
        }
        return "override";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("missing.override.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MissingOverrideAnnotationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    private static class MissingOverrideAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingOverrideAnnotationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                return;
            }
            boolean useJdk6Rules = PsiUtil.isLanguageLevel6OrHigher((PsiElement)method);
            if (useJdk6Rules ? !MissingOverrideAnnotationVisitor.isJdk6Override(method) : !MissingOverrideAnnotationVisitor.isJdk5Override(method)) {
                return;
            }
            if (MethodUtils.isHashCode(method) || MethodUtils.isEquals(method) || MethodUtils.isToString(method)) {
                return;
            }
            if (MissingOverrideAnnotationVisitor.hasOverrideAnnotation((PsiModifierListOwner)method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean hasOverrideAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            if (modifierList == null) {
                return false;
            }
            PsiAnnotation annotation = modifierList.findAnnotation("java.lang.Override");
            return annotation != null;
        }

        private static boolean isJdk6Override(PsiMethod method) {
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            PsiMethod[] superMethods = MissingOverrideAnnotationVisitor.getSuperMethodsInJavaSense(method, methodClass);
            if (superMethods.length <= 0) {
                return false;
            }
            if (!methodClass.isInterface()) {
                return true;
            }
            for (PsiMethod superMethod : superMethods) {
                if (superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return false;
        }

        private static boolean isJdk5Override(PsiMethod method) {
            PsiMethod[] superMethods;
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            for (PsiMethod superMethod : superMethods = MissingOverrideAnnotationVisitor.getSuperMethodsInJavaSense(method, methodClass)) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || superClass.isInterface() || methodClass.isInterface() && superMethod.hasModifierProperty("protected")) continue;
                return true;
            }
            return false;
        }

        private static PsiMethod[] getSuperMethodsInJavaSense(@NotNull PsiMethod method, @NotNull PsiClass methodClass) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor.getSuperMethodsInJavaSense must not be null");
            }
            if (methodClass == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection$MissingOverrideAnnotationVisitor.getSuperMethodsInJavaSense must not be null");
            }
            PsiMethod[] superMethods = method.findSuperMethods();
            SmartList toExclude = new SmartList();
            for (PsiMethod superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (InheritanceUtil.isCorrectDescendant((PsiClass)methodClass, (PsiClass)superClass, (boolean)true)) continue;
                toExclude.add(superMethod);
            }
            if (!toExclude.isEmpty()) {
                ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(Arrays.asList(superMethods));
                result.removeAll((Collection<?>)toExclude);
                return result.toArray(new PsiMethod[result.size()]);
            }
            return superMethods;
        }
    }

    private static class MissingOverrideAnnotationFix
    extends InspectionGadgetsFix {
        private MissingOverrideAnnotationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("missing.override.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MissingOverrideAnnotationInspection$MissingOverrideAnnotationFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (!(parent instanceof PsiModifierListOwner)) {
                return;
            }
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)parent;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Override", (PsiElement)modifierListOwner);
            PsiModifierList modifierList = modifierListOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }
    }
}

