/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ReplaceInheritanceWithDelegationFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("replace.inheritance.with.delegation.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/ReplaceInheritanceWithDelegationFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/ReplaceInheritanceWithDelegationFix.doFix must not be null");
        }
        PsiElement nameElement = descriptor.getPsiElement();
        PsiClass aClass = (PsiClass)nameElement.getParent();
        assert (!(aClass instanceof PsiAnonymousClass));
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        RefactoringActionHandler anonymousToInner = factory.createInheritanceToDelegationHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        anonymousToInner.invoke(project, new PsiElement[]{aClass}, dataContext);
    }
}

