/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesConcreteMethodInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodOverridesConcreteMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodOverridesConcreteMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesConcreteMethodVisitor();
    }

    private static class AbstractMethodOverridesConcreteMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesConcreteMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/AbstractMethodOverridesConcreteMethodInspection$AbstractMethodOverridesConcreteMethodVisitor.visitMethod must not be null");
            }
            if (method.isConstructor()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!method.hasModifierProperty("abstract")) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                String superClassName = superClass.getQualifiedName();
                if (superClass.isInterface() || "java.lang.Object".equals(superClassName) || superMethod.hasModifierProperty("abstract")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

