/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMember member = (PsiMember)infos[1];
        String memberName = member.getName();
        String containingClassName = (String)infos[0];
        String elementName = containingClassName + '.' + memberName;
        return new MakePackagePrivateFix(elementName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisior();
    }

    private static class PrivateMemberAccessFromInnerClassVisior
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisior() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$PrivateMemberAccessFromInnerClassVisior.visitReferenceExpression must not be null");
            }
            if (JspPsiUtil.isInJspFile((PsiElement)expression)) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisior.getContainingContextClass(expression);
            if (containingClass == null) {
                return;
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            PsiClass memberClass = ClassUtils.getContainingClass((PsiElement)member);
            if (memberClass == null) {
                return;
            }
            if (memberClass.equals(containingClass)) {
                return;
            }
            String memberClassName = memberClass.getName();
            this.registerError((PsiElement)expression, memberClassName, member);
        }

        @Nullable
        private static PsiClass getContainingContextClass(PsiReferenceExpression expression) {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList args;
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (aClass instanceof PsiAnonymousClass && (args = (anonymousClass = (PsiAnonymousClass)aClass).getArgumentList()) != null && PsiTreeUtil.isAncestor((PsiElement)args, (PsiElement)expression, (boolean)true)) {
                return ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return aClass;
        }
    }

    private static class MakePackagePrivateFix
    extends InspectionGadgetsFix {
        private final String elementName;

        private MakePackagePrivateFix(String elementName) {
            this.elementName = elementName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression reference = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers = member.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("protected", false);
            modifiers.setModifierProperty("private", false);
        }
    }
}

