/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class HardcodedLineSeparatorsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("hardcoded.line.separator.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/HardcodedLineSeparatorsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("HardcodedLineSeparator" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/HardcodedLineSeparatorsInspection.getID must not return null");
        }
        return "HardcodedLineSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("hardcoded.line.separator.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/HardcodedLineSeparatorsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedLineSeparatorsVisitor();
    }

    private static class HardcodedLineSeparatorsVisitor
    extends BaseInspectionVisitor {
        private static final char NEW_LINE_CHAR = '\n';
        private static final char RETURN_CHAR = '\r';

        private HardcodedLineSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/HardcodedLineSeparatorsInspection$HardcodedLineSeparatorsVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (TypeUtils.isJavaLangString(type)) {
                String value = (String)expression.getValue();
                if (value == null) {
                    return;
                }
                if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0) {
                    this.registerError((PsiElement)expression, new Object[0]);
                }
            } else if (type.equals(PsiType.CHAR)) {
                Character value = (Character)expression.getValue();
                if (value == null) {
                    return;
                }
                char unboxedValue = value.charValue();
                if (unboxedValue == '\n' || unboxedValue == '\r') {
                    this.registerError((PsiElement)expression, new Object[0]);
                }
            }
        }
    }
}

