/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryEnumModifierInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryEnumModifierInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiElement parent = (PsiElement)infos[1];
        if (parent instanceof PsiMethod) {
            string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryEnumModifierInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor1", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryEnumModifierInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInterfaceModifierVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryEnumModifierFix((PsiElement)infos[0]);
    }

    private static class UnnecessaryInterfaceModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInterfaceModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryInterfaceModifierVisitor.visitClass must not be null");
            }
            if (!aClass.isEnum()) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (!aClass.hasModifierProperty("static")) {
                return;
            }
            PsiModifierList modifiers = aClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            for (PsiElement child : children = modifiers.getChildren()) {
                String text = child.getText();
                if (!"static".equals(text)) continue;
                this.registerError(child, child, aClass);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiElement[] children;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryInterfaceModifierVisitor.visitMethod must not be null");
            }
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("private")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!aClass.isEnum()) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (PsiElement child : children = modifiers.getChildren()) {
                String text = child.getText();
                if (!"private".equals(text)) continue;
                this.registerError(child, child, method);
            }
        }
    }

    private static class UnnecessaryEnumModifierFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryEnumModifierFix(PsiElement modifier) {
            this.m_name = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", modifier.getText());
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryEnumModifierInspection$UnnecessaryEnumModifierFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = element instanceof PsiModifierList ? (PsiModifierList)element : (PsiModifierList)element.getParent();
            assert (modifierList != null);
            if (modifierList.getParent() instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            } else {
                modifierList.setModifierProperty("private", false);
            }
        }
    }
}

