/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryThisInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryThisInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryThisInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryThisFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryThisVisitor();
    }

    private static class UnnecessaryThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryThisVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisVisitor.visitReferenceExpression must not be null");
            }
            super.visitReferenceExpression(expression);
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (parameterList == null) {
                return;
            }
            if (parameterList.getTypeArguments().length > 0) {
                return;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiThisExpression)) {
                return;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)qualifierExpression;
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            String referenceName = expression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (qualifier == null) {
                if (parent instanceof PsiCallExpression) {
                    this.registerError((PsiElement)qualifierExpression, new Object[0]);
                    return;
                }
                if (VariableSearchUtils.existsLocalOrParameter(referenceName, (PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)thisExpression, new Object[0]);
            } else {
                String qualifierName = qualifier.getReferenceName();
                if (qualifierName == null) {
                    return;
                }
                if (parent instanceof PsiCallExpression) {
                    PsiCallExpression callExpression = (PsiCallExpression)parent;
                    PsiMethod calledMethod = callExpression.resolveMethod();
                    if (calledMethod == null) {
                        return;
                    }
                    String methodName = calledMethod.getName();
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression);
                    while (parentClass != null) {
                        PsiMethod[] methods;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, new Object[0]);
                        }
                        if ((methods = parentClass.findMethodsByName(methodName, true)).length > 0) {
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                } else {
                    if (VariableSearchUtils.existsLocalOrParameter(referenceName, (PsiElement)expression)) {
                        return;
                    }
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression);
                    while (parentClass != null) {
                        PsiField field;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, new Object[0]);
                        }
                        if ((field = parentClass.findFieldByName(referenceName, true)) != null) {
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                }
            }
        }
    }

    private static class UnnecessaryThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryThisFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement thisToken = descriptor.getPsiElement();
            PsiReferenceExpression thisExpression = (PsiReferenceExpression)thisToken.getParent();
            assert (thisExpression != null);
            String newExpression = thisExpression.getReferenceName();
            if (newExpression == null) {
                return;
            }
            UnnecessaryThisFix.replaceExpression((PsiExpression)thisExpression, newExpression);
        }
    }
}

