/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class VolatileArrayFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("volatile.array.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/VolatileArrayFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeString = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("volatile.field.problem.descriptor", typeString);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/VolatileArrayFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VolatileArrayFieldVisitor();
    }

    private static class VolatileArrayFieldVisitor
    extends BaseInspectionVisitor {
        private VolatileArrayFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/VolatileArrayFieldInspection$VolatileArrayFieldVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasModifierProperty("volatile")) {
                return;
            }
            PsiType type = field.getType();
            if (type.getArrayDimensions() == 0) {
                return;
            }
            this.registerFieldError(field, type);
        }
    }
}

