/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntResourcesClassLoader;
import com.intellij.lang.ant.config.impl.ClassLoaderHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.config.AbstractProperty;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class AntBuildFileClassLoaderHolder
extends ClassLoaderHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntBuildFileClassLoaderHolder");

    public AntBuildFileClassLoaderHolder(AbstractProperty.AbstractPropertyContainer options) {
        super(options);
    }

    @Override
    protected ClassLoader buildClasspath() {
        ClassLoader parentLoader;
        ArrayList<File> files = new ArrayList<File>();
        for (AntClasspathEntry entry : (List)AntBuildFileImpl.ADDITIONAL_CLASSPATH.get(this.myOptions)) {
            entry.addFilesTo(files);
        }
        AntInstallation antInstallation = (AntInstallation)AntBuildFileImpl.RUN_WITH_ANT.get(this.myOptions);
        ClassLoader classLoader = parentLoader = antInstallation != null ? antInstallation.getClassLoader() : null;
        if (parentLoader != null && files.size() == 0) {
            return parentLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.debug((Throwable)e);
            }
        }
        return new AntResourcesClassLoader(urls, parentLoader, false, false);
    }
}

