/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptionNotFoundInspection
extends DevKitInspectionBase {
    @NonNls
    private static final String INSPECTION_PROFILE_ENTRY = "com.intellij.codeInspection.InspectionProfileEntry";
    @NonNls
    private static final String INSPECTION_DESCRIPTIONS = "inspectionDescriptions";

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.checkClass must not be null");
        }
        Project project = aClass.getProject();
        PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstanciatable(aClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(INSPECTION_PROFILE_ENTRY, GlobalSearchScope.allScope((Project)project));
        if (base == null || !aClass.isInheritor(base, true) || DescriptionNotFoundInspection.isPathMethodsAreOverriden(aClass)) {
            return null;
        }
        PsiMethod method = DescriptionNotFoundInspection.findNearestMethod("getShortName", aClass);
        if (method == null) {
            return null;
        }
        String filename = PsiUtil.getReturnedLiteral(method, aClass);
        if (filename == null) {
            return null;
        }
        for (PsiDirectory description : DescriptionNotFoundInspection.getInspectionDescriptionsDirs(module)) {
            VirtualFile vf;
            PsiFile file = description.findFile(filename + ".html");
            if (file == null || (vf = file.getVirtualFile()) == null || !vf.getNameWithoutExtension().equals(filename)) continue;
            return null;
        }
        PsiElement problem = DescriptionNotFoundInspection.getProblemElement(aClass, method);
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)(problem == null ? nameIdentifier : problem), "Inspection does not have a description", isOnTheFly, new LocalQuickFix[]{new CreateHtmlDescriptionFix(filename, module)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static PsiElement getProblemElement(PsiClass aClass, PsiMethod method) {
        if (method.getContainingClass() == aClass) {
            return PsiUtil.getReturnedExpression(method);
        }
        return aClass.getNameIdentifier();
    }

    private static boolean isPathMethodsAreOverriden(PsiClass aClass) {
        return !DescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", INSPECTION_PROFILE_ENTRY, aClass) || !DescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionUrl", INSPECTION_PROFILE_ENTRY, aClass) || !DescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", INSPECTION_PROFILE_ENTRY, aClass) || !DescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", INSPECTION_PROFILE_ENTRY, aClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @NotNull String classFQN, PsiClass cls) {
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.isLastMethodDefinitionIn must not be null");
        }
        if (classFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.isLastMethodDefinitionIn must not be null");
        }
        if (cls == null) {
            return false;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return classFQN.equals(containingClass.getQualifiedName());
        }
        return DescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, classFQN, cls.getSuperClass());
    }

    public static List<VirtualFile> getPotentialRoots(Module module) {
        PsiDirectory[] dirs = DescriptionNotFoundInspection.getInspectionDescriptionsDirs(module);
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (dirs.length != 0) {
            for (PsiDirectory dir : dirs) {
                PsiDirectory parent = dir.getParentDirectory();
                if (parent == null) continue;
                result.add(parent.getVirtualFile());
            }
        } else {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module).getSourceRoots()));
        }
        return result;
    }

    public static PsiDirectory[] getInspectionDescriptionsDirs(Module module) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(INSPECTION_DESCRIPTIONS);
        if (aPackage != null) {
            return aPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.getMethods()) {
            if (method.getParameterList().getParametersCount() != 0 || !method.getName().equals(name)) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return DescriptionNotFoundInspection.findNearestMethod(name, cls.getSuperClass());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Inspection Description Checker" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.getDisplayName must not return null");
        }
        return "Inspection Description Checker";
    }

    @NotNull
    public String getShortName() {
        if ("DescriptionNotFoundInspection" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspection.getShortName must not return null");
        }
        return "DescriptionNotFoundInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

