/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement {
    private final Project myProject;
    private final ResourceBundle myResourceBundle;

    public ResourceBundleFileStructureViewElement(Project project, ResourceBundle resourceBundle) {
        this.myProject = project;
        this.myResourceBundle = resourceBundle;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle;
    }

    public StructureViewTreeElement[] getChildren() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        LinkedHashMap<String, Property> propertyNames = new LinkedHashMap<String, Property>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            List<Property> properties = propertiesFile.getProperties();
            for (Property property : properties) {
                String name = property.getUnescapedKey();
                if (propertyNames.containsKey(name)) continue;
                propertyNames.put(name, property);
            }
        }
        ArrayList<ResourceBundlePropertyStructureViewElement> result = new ArrayList<ResourceBundlePropertyStructureViewElement>(propertyNames.size());
        for (String property : propertyNames.keySet()) {
            result.add(new ResourceBundlePropertyStructureViewElement(this.myProject, this.myResourceBundle, property));
        }
        return result.toArray(new StructureViewTreeElement[result.size()]);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName();
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PropertiesFileType.FILE_ICON;
            }

            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

