/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeCallback
extends AbstractDiffCallback {
    protected boolean myIsDryRun;
    protected SVNURL myURL;
    protected boolean myIsAddNecessitatedMerge;
    protected String myAddedPath = null;
    protected boolean myIsForce;
    protected SVNDiffOptions myDiffOptions;
    protected Map myConflictedPaths;
    protected SVNMergeDriver myMergeDriver;

    public SVNMergeCallback(SVNAdminArea adminArea, SVNURL url, boolean force, boolean dryRun, SVNDiffOptions options, Map conflictedPathsGetter, SVNMergeDriver mergeDriver) {
        super(adminArea);
        this.myURL = url;
        this.myIsDryRun = dryRun;
        this.myIsForce = force;
        this.myDiffOptions = options;
        this.myConflictedPaths = conflictedPathsGetter;
        this.myMergeDriver = mergeDriver;
    }

    public File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("merge");
    }

    public boolean isDiffUnversioned() {
        return false;
    }

    public boolean isDiffCopiedAsAdded() {
        return false;
    }

    public Map getConflictedPaths() {
        return this.myConflictedPaths;
    }

    public SVNStatusType propertiesChanged(String path, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus != SVNStatusType.INAPPLICABLE) {
            return obstructedStatus;
        }
        SVNProperties regularProps = new SVNProperties();
        this.categorizeProperties(diff, regularProps, null, null);
        if (regularProps.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        try {
            SVNProperties filteredProps;
            SVNMergeDriver.MergeSource mergeSource;
            File file = this.getFile(path);
            SVNWCAccess wcAccess = this.getWCAccess();
            if (wcAccess.getAdminArea(file) == null) {
                wcAccess.probeTry(file, true, -1);
            }
            if ((mergeSource = this.myMergeDriver.getCurrentMergeSource()).getRevision1() < mergeSource.getRevision2() && (filteredProps = this.myMergeDriver.filterSelfReferentialMergeInfo(regularProps, file)) != null) {
                regularProps = filteredProps;
            }
            SVNStatusType status = SVNPropertiesManager.mergeProperties(this.getWCAccess(), file, originalProperties, regularProps, false, this.myIsDryRun);
            if (!this.myIsDryRun) {
                Iterator propsIter = regularProps.nameSet().iterator();
                while (propsIter.hasNext()) {
                    String propName = (String)propsIter.next();
                    SVNPropertyValue propValue = regularProps.getSVNPropertyValue(propName);
                    if (!"svn:mergeinfo".equals(propName)) continue;
                    SVNPropertyValue mergeInfoProp = originalProperties.getSVNPropertyValue("svn:mergeinfo");
                    if (mergeInfoProp == null && propValue != null) {
                        this.myMergeDriver.addPathWithNewMergeInfo(file);
                        continue;
                    }
                    if (mergeInfoProp == null || propValue != null) continue;
                    this.myMergeDriver.addPathWithDeletedMergeInfo(file);
                }
            }
            return status;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                this.setIsConflicted(isTreeConflicted, true);
                return SVNStatusType.MISSING;
            }
            throw e;
        }
    }

    public SVNStatusType directoryAdded(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                return SVNStatusType.CHANGED;
            }
            return SVNStatusType.MISSING;
        }
        SVNURL copyFromURL = null;
        long copyFromRevision = -1L;
        if (this.myMergeDriver.myIsSameRepository) {
            copyFromURL = this.myURL.appendPath(path, false);
            copyFromRevision = revision;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus == SVNStatusType.MISSING || obstructedStatus == SVNStatusType.OBSTRUCTED && (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK)) {
            return obstructedStatus;
        }
        if (fileType == SVNFileType.NONE) {
            if (this.myIsDryRun) {
                this.myAddedPath = path;
            } else {
                if (!mergedFile.mkdirs() && SVNFileType.getType(mergedFile) != SVNFileType.DIRECTORY) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", mergedFile);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                dir.getWCAccess().setEventHandler(null);
                SVNWCManager.add(mergedFile, dir, copyFromURL, copyFromRevision, null);
                dir.getWCAccess().setEventHandler(oldEventHandler);
            }
            return SVNStatusType.CHANGED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
            if (entry == null || entry.isScheduledForDeletion()) {
                if (!this.myIsDryRun) {
                    ISVNEventHandler oldEventHandler = dir.getWCAccess().getEventHandler();
                    dir.getWCAccess().setEventHandler(null);
                    SVNWCManager.add(mergedFile, dir, copyFromURL, copyFromRevision, null);
                    dir.getWCAccess().setEventHandler(oldEventHandler);
                }
                if (this.myIsDryRun) {
                    this.myAddedPath = path;
                }
                return SVNStatusType.CHANGED;
            }
            if (this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflictOnAdd(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.ADDED);
            this.setIsConflicted(isTreeConflicted, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            SVNEntry entry;
            if (this.myIsDryRun) {
                this.myAddedPath = null;
            }
            if ((entry = this.getWCAccess().getEntry(mergedFile, false)) != null && this.myIsDryRun && this.isPathDeleted(path)) {
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflictOnAdd(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(isTreeConflicted, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (this.myIsDryRun) {
            this.myAddedPath = null;
        }
        return SVNStatusType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType directoryDeleted(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, true);
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus != SVNStatusType.INAPPLICABLE) {
            return obstructedStatus;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.DIRECTORY) {
            if (entry != null && !entry.isScheduledForDeletion()) {
                final ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
                ISVNEventHandler handler = new ISVNEventHandler(){

                    public void checkCancelled() throws SVNCancelException {
                        oldEventHandler.checkCancelled();
                    }

                    public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    }
                };
                this.getWCAccess().setEventHandler(handler);
                try {
                    this.delete(mergedFile, this.myIsForce, this.myIsDryRun, false);
                }
                catch (SVNException e) {
                    this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                    this.setIsConflicted(isTreeConflicted, true);
                    SVNStatusType sVNStatusType = SVNStatusType.CONFLICTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(oldEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            this.setIsConflicted(isTreeConflicted, true);
        } else {
            if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                return SVNStatusType.OBSTRUCTED;
            }
            if (fileType == SVNFileType.NONE) {
                this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
                this.setIsConflicted(isTreeConflicted, true);
                return SVNStatusType.MISSING;
            }
        }
        return SVNStatusType.UNKNOWN;
    }

    public void directoryOpened(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), this.myIsDryRun);
        if (dir == null) {
            return;
        }
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, true);
        SVNFileType type = SVNFileType.getType(mergedFile);
        if (entry == null || entry.isScheduledForDeletion()) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
            this.setIsConflicted(isTreeConflicted, true);
        } else if (entry.isDirectory() && type == SVNFileType.NONE) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            this.setIsConflicted(isTreeConflicted, true);
        } else if (entry.isDirectory() && type != SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(isTreeConflicted, true);
        } else if (type != SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
            this.setIsConflicted(isTreeConflicted, true);
        }
    }

    public SVNStatusType[] fileChanged(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        boolean needsMerge = true;
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), this.myIsDryRun);
        if (dir == null) {
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus != SVNStatusType.INAPPLICABLE) {
            return new SVNStatusType[]{obstructedStatus, SVNStatusType.UNCHANGED};
        }
        SVNStatusType[] result = new SVNStatusType[]{SVNStatusType.UNCHANGED, SVNStatusType.UNCHANGED};
        SVNEntry entry = this.getWCAccess().getEntry(mergedFile, false);
        SVNFileType fileType = null;
        if (entry != null) {
            fileType = SVNFileType.getType(mergedFile);
        }
        if (entry == null || fileType != SVNFileType.FILE && fileType != SVNFileType.SYMLINK) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            this.setIsConflicted(isTreeConflicted, true);
            return new SVNStatusType[]{SVNStatusType.MISSING, SVNStatusType.MISSING};
        }
        if (diff != null && !diff.isEmpty()) {
            boolean[] isTreeConflicted2 = new boolean[]{false};
            result[1] = this.propertiesChanged(path, originalProperties, diff, isTreeConflicted2);
            if (isTreeConflicted2[0]) {
                this.setIsConflicted(isTreeConflicted, true);
                return result;
            }
        }
        String name = mergedFile.getName();
        if (file1 != null) {
            boolean same;
            boolean textModified = dir.hasTextModifications(name, false);
            if (!textModified && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2)) && (same = SVNFileUtil.compareFiles(!this.myIsAddNecessitatedMerge ? file1 : file2, mergedFile, null))) {
                if (!this.myIsDryRun && !this.myIsAddNecessitatedMerge) {
                    SVNFileUtil.rename(file2, mergedFile);
                }
                result[0] = SVNStatusType.CHANGED;
                needsMerge = false;
            }
            if (needsMerge) {
                String localLabel = ".working";
                String baseLabel = ".merge-left.r" + revision1;
                String latestLabel = ".merge-right.r" + revision2;
                SVNStatusType mergeResult = dir.mergeText(name, file1, file2, null, localLabel, baseLabel, latestLabel, diff, this.myIsDryRun, this.myDiffOptions, null);
                dir.runLogs();
                if (mergeResult == SVNStatusType.CONFLICTED || mergeResult == SVNStatusType.CONFLICTED_UNRESOLVED) {
                    result[0] = mergeResult;
                } else if (textModified && mergeResult != SVNStatusType.UNCHANGED) {
                    result[0] = SVNStatusType.MERGED;
                } else if (mergeResult == SVNStatusType.MERGED) {
                    result[0] = SVNStatusType.CHANGED;
                } else if (mergeResult != SVNStatusType.MISSING) {
                    result[0] = SVNStatusType.UNCHANGED;
                }
                if (mergeResult == SVNStatusType.CONFLICTED) {
                    if (this.myConflictedPaths == null) {
                        this.myConflictedPaths = new SVNHashMap();
                    }
                    this.myConflictedPaths.put(path, path);
                }
            }
        }
        return result;
    }

    public SVNStatusType[] fileAdded(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        SVNStatusType[] result = new SVNStatusType[]{null, SVNStatusType.UNKNOWN};
        SVNProperties newProps = new SVNProperties(originalProperties);
        Iterator propChangesIter = diff.nameSet().iterator();
        while (propChangesIter.hasNext()) {
            String propName = (String)propChangesIter.next();
            if (SVNProperty.isWorkingCopyProperty(propName) || !this.myMergeDriver.isSameRepository() && !SVNProperty.isRegularProperty(propName) || !this.myMergeDriver.isSameRepository() && "svn:mergeinfo".equals(propName)) continue;
            SVNPropertyValue propValue = diff.getSVNPropertyValue(propName);
            newProps.put(propName, propValue);
        }
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            if (this.myIsDryRun && this.myAddedPath != null && SVNPathUtil.isAncestor(this.myAddedPath, path)) {
                result[0] = SVNStatusType.CHANGED;
                if (!newProps.isEmpty()) {
                    result[1] = SVNStatusType.CHANGED;
                }
            } else {
                result[0] = SVNStatusType.MISSING;
            }
            return result;
        }
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus != SVNStatusType.INAPPLICABLE) {
            return new SVNStatusType[]{obstructedStatus, SVNStatusType.UNCHANGED};
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.NONE) {
            if (!this.myIsDryRun) {
                SVNTreeConflictDescription existingConflict;
                String copyFromURL = null;
                long copyFromRevision = -1L;
                if (this.myMergeDriver.myIsSameRepository) {
                    String targePath = this.myMergeDriver.myTarget.getAbsolutePath();
                    String minePath = mergedFile.getAbsolutePath();
                    String relativePath = SVNPathUtil.getRelativePath(targePath, minePath);
                    copyFromURL = this.myURL.appendPath(relativePath, false).toString();
                    copyFromRevision = revision2;
                }
                if ((existingConflict = this.getWCAccess().getTreeConflict(mergedFile)) != null) {
                    this.myMergeDriver.recordTreeConflictOnAdd(mergedFile, this.getAdminArea(), SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                    this.setIsConflicted(isTreeConflicted, true);
                } else {
                    SVNWCManager.addRepositoryFile(dir, mergedFile.getName(), null, file2, newProps, null, copyFromURL, copyFromRevision);
                }
            }
            result[0] = SVNStatusType.CHANGED;
            if (!newProps.isEmpty()) {
                result[1] = SVNStatusType.CHANGED;
            }
        } else if (fileType == SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflictOnAdd(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(isTreeConflicted, true);
            result[0] = this.myIsDryRun && this.isPathDeleted(path) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
        } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            if (this.myIsDryRun && this.isPathDeleted(path)) {
                result[0] = SVNStatusType.CHANGED;
            } else {
                this.myMergeDriver.recordTreeConflictOnAdd(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                this.setIsConflicted(isTreeConflicted, true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType fileDeleted(String path, File file1, File file2, String mimeType1, String mimeType2, SVNProperties originalProperties, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        File mergedFile = this.getFile(path);
        SVNAdminArea dir = this.retrieve(mergedFile.getParentFile(), true);
        if (dir == null) {
            return SVNStatusType.MISSING;
        }
        SVNStatusType obstructedStatus = this.getStatusForObstructedOrMissing(path);
        if (obstructedStatus != SVNStatusType.INAPPLICABLE) {
            return obstructedStatus;
        }
        SVNFileType fileType = SVNFileType.getType(mergedFile);
        if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
            if (this.areFilesTheSame(file1, originalProperties, mergedFile, dir) || this.myMergeDriver.myIsForce || this.myMergeDriver.myIsRecordOnly) {
                ISVNEventHandler oldEventHandler = this.getWCAccess().getEventHandler();
                this.getWCAccess().setEventHandler(null);
                try {
                    this.delete(mergedFile, true, this.myIsDryRun, false);
                }
                catch (SVNException e) {
                    SVNStatusType sVNStatusType = SVNStatusType.OBSTRUCTED;
                    return sVNStatusType;
                }
                finally {
                    this.getWCAccess().setEventHandler(oldEventHandler);
                }
                return SVNStatusType.CHANGED;
            }
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
            this.setIsConflicted(isTreeConflicted, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.DIRECTORY) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.OBSTRUCTED);
            this.setIsConflicted(isTreeConflicted, true);
            return SVNStatusType.OBSTRUCTED;
        }
        if (fileType == SVNFileType.NONE) {
            this.myMergeDriver.recordTreeConflict(mergedFile, dir, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            this.setIsConflicted(isTreeConflicted, true);
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType[] directoryClosed(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        return new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
    }

    protected File getFile(String path) {
        return this.getAdminArea().getFile(path);
    }

    protected SVNAdminArea retrieve(File path, boolean lenient) throws SVNException {
        if (this.getAdminArea() == null) {
            return null;
        }
        try {
            return this.getAdminArea().getWCAccess().retrieve(path);
        }
        catch (SVNException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected void delete(File path, boolean force, boolean dryRun, boolean keepLocal) throws SVNException {
        if (!force && !keepLocal) {
            SVNWCManager.canDelete(path, this.getWCAccess().getOptions(), this.getWCAccess());
        }
        SVNAdminArea root = this.getWCAccess().retrieve(path.getParentFile());
        if (!dryRun) {
            SVNWCManager.delete(this.getWCAccess(), root, path, !keepLocal, false);
        }
    }

    protected boolean areFilesTheSame(File older, SVNProperties originalProps, File mine, SVNAdminArea adminArea) throws SVNException {
        SVNProperties workingProps = adminArea.getProperties(mine.getName()).asMap();
        if (this.arePropsTheSame(originalProps, workingProps)) {
            return !adminArea.hasVersionedFileTextChanges(mine, older, true);
        }
        return false;
    }

    private SVNStatusType getStatusForObstructedOrMissing(String path) {
        File file = this.getFile(path);
        SVNEntry entry = null;
        try {
            entry = this.getWCAccess().getEntry(file, true);
        }
        catch (SVNException svne) {
            // empty catch block
        }
        if (entry != null && entry.isAbsent()) {
            return SVNStatusType.MISSING;
        }
        SVNNodeKind expectedKind = this.getWorkingNodeKind(entry, path);
        SVNNodeKind diskKind = this.getDiskKind(path);
        if (entry != null && entry.isDirectory() && entry.isScheduledForDeletion() && diskKind == SVNNodeKind.DIR) {
            expectedKind = SVNNodeKind.DIR;
        }
        if (expectedKind == diskKind) {
            return SVNStatusType.INAPPLICABLE;
        }
        if (diskKind == SVNNodeKind.NONE) {
            return SVNStatusType.MISSING;
        }
        return SVNStatusType.OBSTRUCTED;
    }

    private SVNNodeKind getWorkingNodeKind(SVNEntry entry, String path) {
        if (entry == null || entry.isScheduledForDeletion() || this.myIsDryRun && this.isPathDeleted(path) || entry.isDeleted() && !entry.isScheduledForAddition()) {
            return SVNNodeKind.NONE;
        }
        return entry.getKind();
    }

    private SVNNodeKind getDiskKind(String path) {
        File file = this.getFile(path);
        SVNFileType type = null;
        type = SVNFileType.getType(file);
        if (type == SVNFileType.UNKNOWN) {
            return SVNNodeKind.UNKNOWN;
        }
        if (this.myIsDryRun && this.isPathDeleted(path)) {
            return SVNNodeKind.NONE;
        }
        return SVNFileType.getNodeKind(type);
    }

    private boolean arePropsTheSame(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = props2.compareTo(props1);
        SVNProperties regularPropsDiff = new SVNProperties();
        this.categorizeProperties(propsDiff, regularPropsDiff, null, null);
        Iterator propNamesIter = regularPropsDiff.nameSet().iterator();
        while (propNamesIter.hasNext()) {
            String propName = (String)propNamesIter.next();
            if ("svn:mergeinfo".equals(propName)) continue;
            return false;
        }
        return true;
    }
}

