/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.MockDocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;

public abstract class EditorWriteActionHandler
extends EditorActionHandler {
    @Override
    public final void execute(final Editor editor, final DataContext dataContext) {
        Project project;
        if (editor.isViewer()) {
            return;
        }
        if (dataContext != null && (project = PlatformDataKeys.PROJECT.getData(dataContext)) != null && !FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(editor.getDocument(), editor.getProject()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RangeMarker guard;
                Document doc = editor.getDocument();
                SelectionModel selectionModel = editor.getSelectionModel();
                if (selectionModel.hasBlockSelection() && (guard = selectionModel.getBlockSelectionGuard()) != null) {
                    MockDocumentEvent evt = new MockDocumentEvent(editor.getDocument(), editor.getCaretModel().getOffset());
                    ReadOnlyFragmentModificationException e = new ReadOnlyFragmentModificationException(evt, guard);
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                    return;
                }
                doc.startGuardedBlockChecking();
                try {
                    EditorWriteActionHandler.this.executeWriteAction(editor, dataContext);
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }
        });
    }

    public abstract void executeWriteAction(Editor var1, DataContext var2);
}

