/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.EffectType;
import gnu.trove.THashSet;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AttributesFlyweight {
    private static final MyTHashSet entries = new MyTHashSet();
    private final Color myForeground;
    private final Color myBackground;
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    private final Color myErrorStripeColor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        AttributesFlyweight attributesFlyweight;
        AttributesFlyweight attributesFlyweight2;
        AttributesFlyweight key = new AttributesFlyweight(foreground, background, fontType, effectColor, effectType, errorStripeColor);
        MyTHashSet myTHashSet = entries;
        synchronized (myTHashSet) {
            int idx = entries.index(key);
            if (idx >= 0) {
                AttributesFlyweight attributesFlyweight3 = entries.get(idx);
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl7 : MonitorExitStatement: MONITOREXIT : var7_7
                attributesFlyweight2 = attributesFlyweight3;
                if (attributesFlyweight3 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/markup/AttributesFlyweight.create must not return null");
                return attributesFlyweight2;
            }
            entries.add(key);
            attributesFlyweight = key;
        }
        attributesFlyweight2 = attributesFlyweight;
        if (attributesFlyweight != null) return attributesFlyweight2;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/markup/AttributesFlyweight.create must not return null");
    }

    AttributesFlyweight(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myFontType = fontType;
        this.myEffectColor = effectColor;
        this.myEffectType = effectType;
        this.myErrorStripeColor = errorStripeColor;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    public Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    public AttributesFlyweight withForeground(Color fore) {
        return AttributesFlyweight.create(fore, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
    }

    public AttributesFlyweight withBackground(Color back) {
        return AttributesFlyweight.create(this.myForeground, back, this.myFontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
    }

    public AttributesFlyweight withFontType(int fontType) {
        return AttributesFlyweight.create(this.myForeground, this.myBackground, fontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
    }

    public AttributesFlyweight withEffectColor(Color effectColor) {
        return AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, effectColor, this.myEffectType, this.myErrorStripeColor);
    }

    public AttributesFlyweight withEffectType(EffectType effectType) {
        return AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, effectType, this.myErrorStripeColor);
    }

    public AttributesFlyweight withErrorStripeColor(Color stripeColor) {
        return AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, stripeColor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (this.myBackground != null ? !this.myBackground.equals(that.myBackground) : that.myBackground != null) {
            return false;
        }
        if (this.myEffectColor != null ? !this.myEffectColor.equals(that.myEffectColor) : that.myEffectColor != null) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (this.myErrorStripeColor != null ? !this.myErrorStripeColor.equals(that.myErrorStripeColor) : that.myErrorStripeColor != null) {
            return false;
        }
        return !(this.myForeground != null ? !this.myForeground.equals(that.myForeground) : that.myForeground != null);
    }

    public int hashCode() {
        int result = this.myForeground != null ? this.myForeground.hashCode() : 0;
        result = 31 * result + (this.myBackground != null ? this.myBackground.hashCode() : 0);
        result = 31 * result + this.myFontType;
        result = 31 * result + (this.myEffectColor != null ? this.myEffectColor.hashCode() : 0);
        result = 31 * result + (this.myEffectType != null ? this.myEffectType.hashCode() : 0);
        result = 31 * result + (this.myErrorStripeColor != null ? this.myErrorStripeColor.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static final class MyTHashSet
    extends THashSet<AttributesFlyweight> {
        private MyTHashSet() {
        }

        public int index(AttributesFlyweight obj) {
            return super.index((Object)obj);
        }

        public AttributesFlyweight get(int index) {
            return (AttributesFlyweight)this._set[index];
        }
    }
}

