/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;

public enum AnnotationSource {
    LOCAL{

        @Override
        public ColorKey getColor() {
            return EditorColors.ANNOTATIONS_COLOR;
        }

        @Override
        public boolean showMerged() {
            return false;
        }
    }
    ,
    MERGE{

        @Override
        public ColorKey getColor() {
            return EditorColors.ANNOTATIONS_MERGED_COLOR;
        }

        @Override
        public boolean showMerged() {
            return true;
        }
    };


    public abstract boolean showMerged();

    public abstract ColorKey getColor();

    public static AnnotationSource getInstance(boolean showMerged) {
        return showMerged ? MERGE : LOCAL;
    }
}

