/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleManager.getInstance must not be null");
        }
        return ServiceManager.getService(project, CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CodeStyleManager.getInstance must not be null");
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull Editor var1);

    public abstract Indent getIndent(String var1, FileType var2);

    public abstract String fillIndent(Indent var1, FileType var2);

    public abstract Indent zeroIndent();

    @Nullable
    public abstract PsiElement insertNewLineIndentMarker(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;
}

