/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.Alarm");
    private boolean myDisposed;
    private final List<Request> myRequests;
    private final List<Request> myPendingRequests;
    private final ThreadPoolExecutor myExecutorService;
    private static final ThreadPoolExecutor ourSharedExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"Alarm pool(shared)", (int)3);
    private final Object LOCK;
    private final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        this.myDisposed = true;
        this.cancelAllRequests();
        if (this.myThreadToUse == ThreadToUse.OWN_THREAD) {
            this.myExecutorService.getQueue().clear();
            this.myExecutorService.shutdown();
        }
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(Disposable parentDisposable) {
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/Alarm.<init> must not be null");
        }
        this(threadToUse, null);
        LOG.assertTrue(threadToUse != ThreadToUse.OWN_THREAD, (Object)"You must provide parent Disposable for ThreadToUse.OWN_THREAD Alarm");
    }

    public Alarm(@NotNull ThreadToUse threadToUse, Disposable parentDisposable) {
        if (threadToUse == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/Alarm.<init> must not be null");
        }
        this.myRequests = new ArrayList<Request>();
        this.myPendingRequests = new ArrayList<Request>();
        this.LOCK = new Object();
        this.myThreadToUse = threadToUse;
        ThreadPoolExecutor threadPoolExecutor = this.myExecutorService = threadToUse == ThreadToUse.OWN_THREAD ? ConcurrencyUtil.newSingleThreadExecutor((String)"Alarm pool(own)", (int)3) : ourSharedExecutorService;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(Runnable request, int delayMillis) {
        this._addRequest(request, delayMillis, this.myThreadToUse == ThreadToUse.SWING_THREAD ? ModalityState.current() : null);
    }

    public void addComponentRequest(Runnable request, int delay) {
        assert (this.myActivationComponent != null);
        this._addRequest(request, delay, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(Runnable request, int delayMillis, ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addRequest(Runnable request, int delayMillis, ModalityState modalityState) {
        Object object = this.LOCK;
        synchronized (object) {
            Request requestToSchedule = new Request(request, modalityState, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this._add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void _add(Request requestToSchedule) {
        ScheduledFuture<?> future = JobScheduler.getScheduler().schedule(requestToSchedule, (long)requestToSchedule.myDelay, TimeUnit.MILLISECONDS);
        requestToSchedule.setFuture(future);
        this.myRequests.add(requestToSchedule);
    }

    private void flushPending() {
        for (Request each : this.myPendingRequests) {
            this._add(each);
        }
        this.myPendingRequests.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(Runnable request) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelRequest(request, this.myRequests);
            this.cancelRequest(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelRequest(Runnable request, List<Request> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.getTask() != request) continue;
            r.cancel();
            list.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            int count = this.cancelAllRequests(this.myRequests);
            this.cancelAllRequests(this.myPendingRequests);
            return count;
        }
    }

    private int cancelAllRequests(List<Request> list) {
        int count = 0;
        for (Request request : list) {
            ++count;
            request.cancel();
        }
        list.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public static boolean isEventDispatchThread() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isDispatchThread() || EventQueue.isDispatchThread();
    }

    public Alarm setActivationComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/Alarm.setActivationComponent must not be null");
        }
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }

            @Override
            public void hideNotify() {
            }
        });
        return this;
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final int myDelay;

        private Request(Runnable task, ModalityState modalityState, int delayMillis) {
            this.myTask = task;
            this.myModalityState = modalityState;
            this.myDelay = delayMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    if (Alarm.this.myDisposed) break block10;
                    Object object = Alarm.this.LOCK;
                    synchronized (object) {
                        if (this.myTask == null) {
                            return;
                        }
                    }
                    Runnable scheduledTask = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Runnable task;
                            Object object = Alarm.this.LOCK;
                            synchronized (object) {
                                task = Request.this.myTask;
                                if (task == null) {
                                    return;
                                }
                                Request.this.myTask = null;
                                Alarm.this.myRequests.remove(Request.this);
                            }
                            if (Alarm.this.myThreadToUse == ThreadToUse.SWING_THREAD && !Alarm.this.isEdt()) {
                                try {
                                    SwingUtilities.invokeAndWait(task);
                                }
                                catch (Exception e) {
                                    LOG.error((Throwable)e);
                                }
                            } else {
                                task.run();
                            }
                        }
                    };
                    if (this.myModalityState != null) {
                        Application app = ApplicationManager.getApplication();
                        if (app != null) {
                            app.invokeLater(scheduledTask, this.myModalityState);
                        } else {
                            SwingUtilities.invokeLater(scheduledTask);
                        }
                    } else {
                        this.myFuture = Alarm.this.myExecutorService.submit(scheduledTask);
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private Runnable getTask() {
            return this.myTask;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.myFuture = future;
        }

        public ModalityState getModalityState() {
            return this.myModalityState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                if (this.myFuture != null) {
                    this.myFuture.cancel(false);
                }
                this.myTask = null;
            }
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        OWN_THREAD;

    }
}

