/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentUtil {
    public static final String FORCE_RELOAD_REQUESTOR = "FileContentUtil.saveOrReload";

    private FileContentUtil() {
    }

    public static void setFileText(@Nullable Project project, VirtualFile virtualFile, String text) throws IOException {
        if (project == null) {
            project = ProjectUtil.guessProjectForFile(virtualFile);
        }
        if (project != null) {
            Document document;
            PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(project);
            Document document2 = document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
            if (document != null) {
                document.setText(text != null ? text : "");
                psiDocumentManager.commitDocument(document);
                FileDocumentManager.getInstance().saveDocument(document);
                return;
            }
        }
        VfsUtil.saveText(virtualFile, text != null ? text : "");
        virtualFile.refresh(false, false);
    }

    public static void reparseFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/FileContentUtil.reparseFiles must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/FileContentUtil.reparseFiles must not be null");
        }
        THashSet list = new THashSet();
        for (VirtualFile file : files) {
            FileContentUtil.saveOrReload(file, (Collection<VFilePropertyChangeEvent>)list);
        }
        if (includeOpenFiles) {
            for (VirtualFile open : FileEditorManager.getInstance(project).getOpenFiles()) {
                if (files.contains(open)) continue;
                FileContentUtil.saveOrReload(open, (Collection<VFilePropertyChangeEvent>)list);
            }
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable((Set)list){
            final /* synthetic */ Set val$list;
            {
                this.val$list = set;
            }

            @Override
            public void run() {
                ((BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(new ArrayList(this.val$list));
            }
        });
    }

    private static void saveOrReload(VirtualFile virtualFile, Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (virtualFile == null || virtualFile.isDirectory()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(virtualFile) && (document = documentManager.getDocument(virtualFile)) != null) {
            documentManager.saveDocument(document);
        }
        events.add(new VFilePropertyChangeEvent(FORCE_RELOAD_REQUESTOR, virtualFile, "name", virtualFile.getName(), virtualFile.getName(), false));
    }
}

