/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.TestAllInPackage2;
import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JUnit3OutputObjectRegistry
extends OutputObjectRegistry {
    public JUnit3OutputObjectRegistry(PacketProcessor mainTransport, PacketProcessor auxilaryTransport) {
        super(mainTransport, auxilaryTransport);
    }

    public JUnit3OutputObjectRegistry(PacketProcessor out) {
        super(out);
    }

    protected int getTestCont(Object test) {
        return ((Test)test).countTestCases();
    }

    protected void addStringRepresentation(Object test, Packet packet) {
        if (test instanceof TestRunnerUtil.FailedTestCase) {
            JUnit3OutputObjectRegistry.addTestMethod((Packet)packet, (String)((TestRunnerUtil.FailedTestCase)((Object)test)).getMethodName(), (String)((TestCase)test).getName());
        } else if (test instanceof TestCase) {
            JUnit3OutputObjectRegistry.addTestMethod((Packet)packet, (String)((TestCase)test).getName(), (String)test.getClass().getName());
        } else if (test instanceof TestAllInPackage2) {
            TestAllInPackage2 allInPackage = (TestAllInPackage2)((Object)test);
            JUnit3OutputObjectRegistry.addAllInPackage((Packet)packet, (String)allInPackage.getName());
        } else if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            String fullName = testSuite.getName();
            if (fullName == null) {
                this.addUnknownTest(packet, test);
                return;
            }
            JUnit3OutputObjectRegistry.addTestClass((Packet)packet, (String)fullName);
        } else if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            JUnit3OutputObjectRegistry.addTestClass((Packet)packet, (String)((TestRunnerUtil.SuiteMethodWrapper)test).getClassName());
        } else {
            this.addUnknownTest(packet, test);
        }
    }
}

