/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorMain;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.util.ScriptGenerator;

public class GitRebaseEditorService
implements ApplicationComponent {
    private String myEditorCommand;
    private final Object myScriptLock;
    private final Map<Integer, GitRebaseEditorHandler> myHandlers;
    private final Object myHandlersLock;
    private final XmlRpcServer myXmlRpcServer;
    private static final Random oursRandom = new Random();
    private boolean myInitialized;
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    public GitRebaseEditorService(@NotNull XmlRpcServer xmlRpcServer) {
        if (xmlRpcServer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rebase/GitRebaseEditorService.<init> must not be null");
        }
        this.myScriptLock = new Object();
        this.myHandlers = new THashMap();
        this.myHandlersLock = new Object();
        this.myInitialized = false;
        this.myXmlRpcServer = xmlRpcServer;
    }

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ServiceManager.getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        GitRebaseEditorService gitRebaseEditorService = service;
        if (gitRebaseEditorService == null) {
            throw new IllegalStateException("@NotNull method git4idea/rebase/GitRebaseEditorService.getInstance must not return null");
        }
        return gitRebaseEditorService;
    }

    @NotNull
    public String getComponentName() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/rebase/GitRebaseEditorService.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
        if (!this.myInitialized) {
            this.myXmlRpcServer.addHandler("Git4ideaRebaseEditorHandler", (Object)new InternalHandler());
            this.myInitialized = true;
        }
    }

    public void disposeComponent() {
        this.myXmlRpcServer.removeHandler("Git4ideaRebaseEditorHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getEditorCommand() {
        Object object = this.myScriptLock;
        // MONITORENTER : object
        if (this.myEditorCommand == null) {
            ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorMain.class);
            generator.addInternal(Integer.toString(this.myXmlRpcServer.getPortNumber()));
            generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
            this.myEditorCommand = generator.commandLine();
        }
        String string = this.myEditorCommand;
        // MONITOREXIT : object
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method git4idea/rebase/GitRebaseEditorService.getEditorCommand must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerHandler(GitRebaseEditorHandler handler) {
        this.initComponent();
        Integer rc = null;
        Object object = this.myHandlersLock;
        synchronized (object) {
            for (int i = Integer.MAX_VALUE; i > 0; --i) {
                int code = Math.abs(oursRandom.nextInt());
                if (code <= 0 || this.myHandlers.containsKey(code)) continue;
                rc = code;
                break;
            }
            if (rc == null) {
                throw new IllegalStateException("There is a problem with random number allocation");
            }
            this.myHandlers.put(rc, handler);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(int handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already remoted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GitRebaseEditorHandler getHandler(int handlerNo) {
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        GitRebaseEditorHandler h = this.myHandlers.get(handlerNo);
        if (h == null) {
            throw new IllegalStateException("The handler " + handlerNo + " is not registered");
        }
        GitRebaseEditorHandler gitRebaseEditorHandler = h;
        // MONITOREXIT : object
        if (gitRebaseEditorHandler != null) return gitRebaseEditorHandler;
        throw new IllegalStateException("@NotNull method git4idea/rebase/GitRebaseEditorService.getHandler must not return null");
    }

    public void configureHandler(GitLineHandler h, int editorNo) {
        h.setEnvironment("GIT_EDITOR", this.getEditorCommand());
        h.setEnvironment("IDEA_REBASE_HANDER_NO", Integer.toString(editorNo));
    }

    public class InternalHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int editCommits(int handlerNo, String path) {
            GitRebaseEditorHandler editor = GitRebaseEditorService.this.getHandler(handlerNo);
            GitHandler handler = editor.getHandler();
            handler.suspendWriteLock();
            try {
                int n = editor.editCommits(path);
                return n;
            }
            finally {
                handler.resumeWriteLock();
            }
        }
    }
}

