/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.util.containers.HashSet;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.vfs.GitConfigListener;
import git4idea.vfs.GitRootsListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GitConfigTracker
implements GitRootsListener {
    private Project myProject;
    private GitVcs myVcs;
    private final ProjectLevelVcsManager myVcsManager;
    private GitConfigListener myMulticaster;
    private final HashSet<VirtualFile> myReportedRoots = new HashSet();
    private LocalFileSystem myLocalFileSystem;
    private MyFileListener myFileListener;

    public GitConfigTracker(Project project, GitVcs vcs, GitConfigListener multicaster) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myMulticaster = multicaster;
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcs.addGitRootsListener(this);
        this.myFileListener = new MyFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myFileListener);
        this.gitRootsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gitRootsChanged() {
        VirtualFile[] contentRoots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)this.myVcs);
        if (contentRoots == null || contentRoots.length == 0) {
            return;
        }
        Set<VirtualFile> currentRootSet = GitUtil.gitRootsForPaths(Arrays.asList(contentRoots));
        HashSet newRoots = new HashSet(currentRootSet);
        HashSet<VirtualFile> hashSet = this.myReportedRoots;
        synchronized (hashSet) {
            Iterator i = this.myReportedRoots.iterator();
            while (i.hasNext()) {
                VirtualFile root = (VirtualFile)i.next();
                if (root.isValid()) continue;
                i.remove();
            }
            newRoots.removeAll(this.myReportedRoots);
            this.myReportedRoots.clear();
            this.myReportedRoots.addAll(currentRootSet);
        }
        for (VirtualFile root : newRoots) {
            VirtualFile config = root.findFileByRelativePath(".git/config");
            this.myMulticaster.configChanged(root, config);
        }
        VirtualFile userHome = this.getUserHome();
        if (userHome != null) {
            userHome.getChildren();
        }
    }

    @Nullable
    private VirtualFile getUserHome() {
        return this.myLocalFileSystem.findFileByPath(System.getProperty("user.home"));
    }

    public void dispose() {
        this.myVcs.removeGitRootsListener(this);
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myFileListener);
    }

    private class MyFileListener
    extends VirtualFileAdapter {
        private MyFileListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkConfigAffected(VirtualFile file) {
            if (file.getName().equals(".gitconfig")) {
                VirtualFile userHome = GitConfigTracker.this.getUserHome();
                VirtualFile parent = file.getParent();
                if (userHome != null && parent != null && parent.equals(userHome)) {
                    HashSet allRoots;
                    HashSet hashSet = GitConfigTracker.this.myReportedRoots;
                    synchronized (hashSet) {
                        allRoots = new HashSet((Collection)GitConfigTracker.this.myReportedRoots);
                    }
                    for (VirtualFile root : allRoots) {
                        GitConfigTracker.this.myMulticaster.configChanged(root, file);
                    }
                }
                return;
            }
            VirtualFile base = GitUtil.getPossibleBase(file, ".git", "config");
            if (base != null) {
                boolean reported;
                HashSet hashSet = GitConfigTracker.this.myReportedRoots;
                synchronized (hashSet) {
                    reported = GitConfigTracker.this.myReportedRoots.contains((Object)base);
                }
                if (reported) {
                    GitConfigTracker.this.myMulticaster.configChanged(base, file);
                }
            }
        }

        public void fileCreated(VirtualFileEvent event) {
            this.checkConfigAffected(event.getFile());
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            this.checkConfigAffected(event.getFile());
        }

        public void contentsChanged(VirtualFileEvent event) {
            this.checkConfigAffected(event.getFile());
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            super.fileCopied(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileMoved(VirtualFileMoveEvent event) {
            VirtualFile userHome;
            String fileName = event.getFileName();
            VirtualFile newParent = event.getNewParent();
            VirtualFile oldParent = event.getOldParent();
            if (fileName.equals("config")) {
                this.checkParent(newParent);
                this.checkParent(oldParent);
            }
            if (fileName.equals(".gitconfig") && (userHome = GitConfigTracker.this.getUserHome()) != null && (newParent.equals(userHome) || oldParent.equals(userHome))) {
                HashSet allRoots;
                HashSet hashSet = GitConfigTracker.this.myReportedRoots;
                synchronized (hashSet) {
                    allRoots = new HashSet((Collection)GitConfigTracker.this.myReportedRoots);
                }
                VirtualFile config = userHome.findChild(".gitconfig");
                for (VirtualFile root : allRoots) {
                    GitConfigTracker.this.myMulticaster.configChanged(root, config);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkParent(VirtualFile parent) {
            VirtualFile base;
            if (parent.getName().equals(".git") && (base = parent.getParent()) != null) {
                boolean reported;
                HashSet hashSet = GitConfigTracker.this.myReportedRoots;
                synchronized (hashSet) {
                    reported = GitConfigTracker.this.myReportedRoots.contains((Object)base);
                }
                if (reported) {
                    GitConfigTracker.this.myMulticaster.configChanged(base, parent.findChild("config"));
                }
            }
        }
    }
}

