/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipDirectoryStream;
import com.sun.nio.zipfs.ZipFileAttributeView;
import com.sun.nio.zipfs.ZipFileAttributes;
import com.sun.nio.zipfs.ZipFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ZipPath
extends Path {
    private final ZipFileSystem zfs;
    private final byte[] path;
    private volatile int[] offsets;
    private int hashcode = 0;
    private volatile byte[] resolved = null;
    private static final DirectoryStream.Filter<Path> acceptAllFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) {
            return true;
        }
    };

    ZipPath(ZipFileSystem zipFileSystem, byte[] byArray) {
        this(zipFileSystem, byArray, false);
    }

    ZipPath(ZipFileSystem zipFileSystem, byte[] byArray, boolean bl) {
        this.zfs = zipFileSystem;
        this.path = bl ? byArray : this.normalize(byArray);
    }

    @Override
    public ZipPath getRoot() {
        if (this.isAbsolute()) {
            return new ZipPath(this.zfs, new byte[]{this.path[0]});
        }
        return null;
    }

    public Path getName() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        if (n == 1 && this.path[0] != 47) {
            return this;
        }
        int n2 = this.offsets[n - 1];
        int n3 = this.path.length - n2;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new ZipPath(this.zfs, byArray);
    }

    @Override
    public ZipPath getParent() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        int n2 = this.offsets[n - 1] - 1;
        if (n2 <= 0) {
            return this.getRoot();
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.path, 0, byArray, 0, n2);
        return new ZipPath(this.zfs, byArray);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public ZipPath getName(int n) {
        this.initOffsets();
        if (n < 0 || n >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int n2 = this.offsets[n];
        int n3 = n == this.offsets.length - 1 ? this.path.length - n2 : this.offsets[n + 1] - n2 - 1;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new ZipPath(this.zfs, byArray);
    }

    @Override
    public ZipPath subpath(int n, int n2) {
        this.initOffsets();
        if (n < 0 || n >= this.offsets.length || n2 > this.offsets.length || n >= n2) {
            throw new IllegalArgumentException();
        }
        int n3 = this.offsets[n];
        int n4 = n2 == this.offsets.length ? this.path.length - n3 : this.offsets[n2] - n3 - 1;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.path, n3, byArray, 0, n4);
        return new ZipPath(this.zfs, byArray);
    }

    public ZipPath toRealPath(boolean bl) throws IOException {
        ZipPath zipPath = new ZipPath(this.zfs, this.getResolvedPath());
        zipPath.checkAccess(new AccessMode[0]);
        return zipPath;
    }

    public boolean isHidden() {
        return false;
    }

    @Override
    public ZipPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        byte[] byArray = this.zfs.getDefaultDir().path;
        int n = byArray.length;
        boolean bl = byArray[n - 1] == 47;
        byte[] byArray2 = null;
        byArray2 = bl ? new byte[n + this.path.length] : new byte[n + 1 + this.path.length];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (!bl) {
            byArray2[n++] = 47;
        }
        System.arraycopy(this.path, 0, byArray2, n, this.path.length);
        return new ZipPath(this.zfs, byArray2, true);
    }

    @Override
    public URI toUri() {
        String string = this.zfs.toString();
        if (File.separatorChar == '\\') {
            string = "/" + string.replace("\\", "/");
        }
        try {
            return new URI("zip", "", string, this.zfs.getString(this.toAbsolutePath().path));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private boolean equalsNameAt(ZipPath zipPath, int n) {
        int n2 = this.offsets[n];
        int n3 = 0;
        n3 = n == this.offsets.length - 1 ? this.path.length - n2 : this.offsets[n + 1] - n2 - 1;
        int n4 = zipPath.offsets[n];
        int n5 = 0;
        n5 = n == zipPath.offsets.length - 1 ? zipPath.path.length - n4 : zipPath.offsets[n + 1] - n4 - 1;
        if (n3 != n5) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (this.path[n2 + i] == zipPath.path[n4 + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path relativize(Path path) {
        int n;
        ZipPath zipPath = this.checkPath(path);
        if (zipPath.equals(this)) {
            return null;
        }
        if (this.isAbsolute() != zipPath.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getNameCount();
        int n3 = zipPath.getNameCount();
        int n4 = Math.min(n2, n3);
        for (n = 0; n < n4 && this.equalsNameAt(zipPath, n); ++n) {
        }
        int n5 = n2 - n;
        int n6 = n5 * 3 - 1;
        if (n < n3) {
            n6 += zipPath.path.length - zipPath.offsets[n] + 1;
        }
        byte[] byArray = new byte[n6];
        int n7 = 0;
        while (n5 > 0) {
            byArray[n7++] = 46;
            byArray[n7++] = 46;
            if (n7 < n6) {
                byArray[n7++] = 47;
            }
            --n5;
        }
        if (n < n3) {
            System.arraycopy(zipPath.path, zipPath.offsets[n], byArray, n7, zipPath.path.length - zipPath.offsets[n]);
        }
        return new ZipPath(this.getFileSystem(), byArray);
    }

    @Override
    public ZipFileSystem getFileSystem() {
        return this.zfs;
    }

    @Override
    public boolean isAbsolute() {
        return this.path[0] == 47;
    }

    @Override
    public ZipPath resolve(Path path) {
        if (path == null) {
            return this;
        }
        ZipPath zipPath = this.checkPath(path);
        if (zipPath.isAbsolute()) {
            return zipPath;
        }
        byte[] byArray = null;
        if (this.path[this.path.length - 1] == 47) {
            byArray = new byte[this.path.length + zipPath.path.length];
            System.arraycopy(this.path, 0, byArray, 0, this.path.length);
            System.arraycopy(zipPath.path, 0, byArray, this.path.length, zipPath.path.length);
        } else {
            byArray = new byte[this.path.length + 1 + zipPath.path.length];
            System.arraycopy(this.path, 0, byArray, 0, this.path.length);
            byArray[this.path.length] = 47;
            System.arraycopy(zipPath.path, 0, byArray, this.path.length + 1, zipPath.path.length);
        }
        return new ZipPath(this.zfs, byArray);
    }

    @Override
    public ZipPath resolve(String string) {
        return this.resolve(this.getFileSystem().getPath(string));
    }

    @Override
    public boolean startsWith(Path path) {
        ZipPath zipPath = this.checkPath(path);
        if (zipPath.isAbsolute() != this.isAbsolute()) {
            return false;
        }
        int n = zipPath.getNameCount();
        if (this.getNameCount() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (zipPath.getName(i).equals(this.getName(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(Path path) {
        ZipPath zipPath = this.checkPath(path);
        if (zipPath.isAbsolute()) {
            return this.isAbsolute() ? this.equals(zipPath) : false;
        }
        int n = zipPath.getNameCount();
        int n2 = this.getNameCount();
        if (n2 < n) {
            return false;
        }
        --n;
        --n2;
        while (n >= 0) {
            if (!zipPath.getName(n).equals(this.getName(n2))) {
                return false;
            }
            --n;
            --n2;
        }
        return true;
    }

    @Override
    public Path normalize() {
        byte[] byArray = this.getResolved();
        if (byArray == this.path) {
            return this;
        }
        if (byArray.length == 0) {
            return null;
        }
        return new ZipPath(this.zfs, byArray, true);
    }

    private ZipPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof ZipPath)) {
            throw new ProviderMismatchException();
        }
        return (ZipPath)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.path.length) {
                byte by;
                if ((by = this.path[n2++]) == 47) continue;
                ++n;
                while (n2 < this.path.length && this.path[n2] != 47) {
                    ++n2;
                }
            }
            int[] nArray = new int[n];
            n = 0;
            n2 = 0;
            while (n2 < this.path.length) {
                byte by = this.path[n2];
                if (by == 47) {
                    ++n2;
                    continue;
                }
                nArray[n++] = n2++;
                while (n2 < this.path.length && this.path[n2] != 47) {
                    ++n2;
                }
            }
            ZipPath zipPath = this;
            synchronized (zipPath) {
                if (this.offsets == null) {
                    this.offsets = nArray;
                }
            }
        }
    }

    byte[] getResolvedPath() {
        byte[] byArray = this.resolved;
        if (byArray == null) {
            byArray = this.isAbsolute() ? this.getResolved() : this.toAbsolutePath().getResolvedPath();
            if (byArray[0] == 47) {
                byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
            }
            this.resolved = byArray;
        }
        return this.resolved;
    }

    private byte[] normalize(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i];
            if (n2 == 92) {
                return this.normalize(byArray, i);
            }
            if (n2 == 47 && n == 47) {
                return this.normalize(byArray, i - 1);
            }
            if (n2 == 0) {
                throw new InvalidPathException(this.zfs.getString(byArray), "Path: nul character not allowed");
            }
            n = n2;
        }
        return byArray;
    }

    private byte[] normalize(byte[] byArray, int n) {
        int n2;
        byte[] byArray2 = new byte[byArray.length];
        for (n2 = 0; n2 < n; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        int n3 = n2;
        int n4 = 0;
        while (n2 < byArray.length) {
            int n5;
            if ((n5 = byArray[n2++]) == 92) {
                n5 = 47;
            }
            if (n5 == 47 && n4 == 47) continue;
            if (n5 == 0) {
                throw new InvalidPathException(this.zfs.getString(byArray), "Path: nul character not allowed");
            }
            byArray2[n3++] = n5;
            n4 = n5;
        }
        if (n3 > 1 && byArray2[n3 - 1] == 47) {
            --n3;
        }
        return n3 == byArray2.length ? byArray2 : Arrays.copyOf(byArray2, n3);
    }

    private byte[] getResolved() {
        if (this.path.length == 0) {
            return this.path;
        }
        for (int i = 0; i < this.path.length; ++i) {
            byte by = this.path[i];
            if (by != 46) continue;
            return this.resolve0();
        }
        return this.path;
    }

    private byte[] resolve0() {
        byte[] byArray = new byte[this.path.length];
        int n = this.getNameCount();
        int[] nArray = new int[n];
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = this.offsets[i];
            int n6 = n4 = i == this.offsets.length - 1 ? this.path.length - n5 : this.offsets[i + 1] - n5 - 1;
            if (n4 == 1 && this.path[n5] == 46) continue;
            if (n4 == 2 && this.path[n5] == 46 && this.path[n5 + 1] == 46) {
                if (n2 >= 0) {
                    n3 = nArray[n2--];
                    continue;
                }
                if (this.path[0] == 47) {
                    if (n3 != 0) continue;
                    byArray[n3++] = 47;
                    continue;
                }
                if (n3 != 0 && byArray[n3 - 1] != 47) {
                    byArray[n3++] = 47;
                }
                while (n4-- > 0) {
                    byArray[n3++] = this.path[n5++];
                }
                continue;
            }
            if (n3 == 0 && this.path[0] == 47 || n3 != 0 && byArray[n3 - 1] != 47) {
                byArray[n3++] = 47;
            }
            nArray[++n2] = n3;
            while (n4-- > 0) {
                byArray[n3++] = this.path[n5++];
            }
        }
        if (n3 > 1 && byArray[n3 - 1] == 47) {
            --n3;
        }
        return n3 == byArray.length ? byArray : Arrays.copyOf(byArray, n3);
    }

    @Override
    public String toString() {
        return this.zfs.getString(this.path);
    }

    @Override
    public int hashCode() {
        int n = this.hashcode;
        if (n == 0) {
            this.hashcode = n = Arrays.hashCode(this.path);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof ZipPath && this.zfs == ((ZipPath)object).zfs && this.compareTo((Path)object) == 0;
    }

    @Override
    public int compareTo(Path path) {
        ZipPath zipPath = this.checkPath(path);
        int n = this.path.length;
        int n2 = zipPath.path.length;
        int n3 = Math.min(n, n2);
        byte[] byArray = this.path;
        byte[] byArray2 = zipPath.path;
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = byArray2[i] & 0xFF;
            if (n4 == n5) continue;
            return n4 - n5;
        }
        return n - n2;
    }

    public Path createSymbolicLink(Path path, FileAttribute<?> ... fileAttributeArray) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Path createLink(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Path readSymbolicLink() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Path createDirectory(FileAttribute<?> ... fileAttributeArray) throws IOException {
        this.zfs.createDirectory(this.getResolvedPath(), fileAttributeArray);
        return this;
    }

    public final Path createFile(FileAttribute<?> ... fileAttributeArray) throws IOException {
        OutputStream outputStream = this.newOutputStream(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public InputStream newInputStream(OpenOption ... openOptionArray) throws IOException {
        if (openOptionArray.length > 0) {
            for (OpenOption openOption : openOptionArray) {
                if (openOption == StandardOpenOption.READ) continue;
                throw new UnsupportedOperationException("'" + openOption + "' not allowed");
            }
        }
        return this.zfs.newInputStream(this.getResolvedPath());
    }

    public final DirectoryStream<Path> newDirectoryStream() throws IOException {
        return this.newDirectoryStream(acceptAllFilter);
    }

    public DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new ZipDirectoryStream(this, filter);
    }

    public final DirectoryStream<Path> newDirectoryStream(String string) throws IOException {
        if (string.equals("*")) {
            return this.newDirectoryStream();
        }
        final PathMatcher pathMatcher = this.getFileSystem().getPathMatcher("glob:" + string);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return pathMatcher.matches(path.getName());
            }
        };
        return this.newDirectoryStream((DirectoryStream.Filter<? super Path>)filter);
    }

    public final void delete() throws IOException {
        this.zfs.deleteFile(this.getResolvedPath(), true);
    }

    public final void deleteIfExists() throws IOException {
        this.zfs.deleteFile(this.getResolvedPath(), false);
    }

    ZipFileAttributes getAttributes() throws IOException {
        ZipFileAttributes zipFileAttributes = this.zfs.getFileAttributes(this.getResolvedPath());
        if (zipFileAttributes == null) {
            throw new NoSuchFileException(this.toString());
        }
        return zipFileAttributes;
    }

    public <V extends FileAttributeView> V getFileAttributeView(Class<V> clazz, LinkOption ... linkOptionArray) {
        return ZipFileAttributeView.get(this, clazz);
    }

    public void setAttribute(String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            string2 = "basic";
            string3 = string;
        } else {
            string2 = string.substring(0, n++);
            string3 = string.substring(n);
        }
        ZipFileAttributeView zipFileAttributeView = ZipFileAttributeView.get(this, string2);
        if (zipFileAttributeView == null) {
            throw new UnsupportedOperationException("view <" + zipFileAttributeView + "> is not supported");
        }
        zipFileAttributeView.setAttribute(string3, object);
    }

    void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
        this.zfs.setTimes(this.getResolvedPath(), fileTime, fileTime2, fileTime3);
    }

    private Object getAttributesImpl(String string, boolean bl) throws IOException {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            string2 = "basic";
            string3 = string;
        } else {
            string2 = string.substring(0, n++);
            string3 = string.substring(n);
        }
        ZipFileAttributeView zipFileAttributeView = ZipFileAttributeView.get(this, string2);
        if (zipFileAttributeView == null) {
            throw new UnsupportedOperationException("view not supported");
        }
        return zipFileAttributeView.getAttribute(string3, bl);
    }

    public Object getAttribute(String string, LinkOption ... linkOptionArray) throws IOException {
        return this.getAttributesImpl(string, false);
    }

    public Map<String, ?> readAttributes(String string, LinkOption ... linkOptionArray) throws IOException {
        return (Map)this.getAttributesImpl(string, true);
    }

    public FileStore getFileStore() throws IOException {
        if (this.exists()) {
            return this.zfs.getFileStore(this);
        }
        throw new NoSuchFileException(this.zfs.getString(this.path));
    }

    public boolean isSameFile(Path path) throws IOException {
        if (path == null || this.getFileSystem() != path.getFileSystem()) {
            return false;
        }
        this.checkAccess(new AccessMode[0]);
        path.checkAccess(new AccessMode[0]);
        return Arrays.equals(this.getResolvedPath(), ((ZipPath)path).getResolvedPath());
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) {
        if (watchService == null || kindArray == null || modifierArray == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kindArray) {
        return this.register(watchService, kindArray, new WatchEvent.Modifier[0]);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ZipPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < ZipPath.this.getNameCount()) {
                    ZipPath zipPath = ZipPath.this.getName(this.i);
                    ++this.i;
                    return zipPath;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    public SeekableByteChannel newByteChannel(Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return this.zfs.newByteChannel(this.getResolvedPath(), set, fileAttributeArray);
    }

    FileChannel newFileChannel(Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        return this.zfs.newFileChannel(this.getResolvedPath(), set, fileAttributeArray);
    }

    public SeekableByteChannel newByteChannel(OpenOption ... openOptionArray) throws IOException {
        HashSet hashSet = new HashSet(openOptionArray.length);
        Collections.addAll(hashSet, openOptionArray);
        return this.newByteChannel(hashSet, new FileAttribute[0]);
    }

    public void checkAccess(AccessMode ... accessModeArray) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        block5: for (AccessMode accessMode : accessModeArray) {
            switch (accessMode) {
                case READ: {
                    continue block5;
                }
                case WRITE: {
                    bl = true;
                    continue block5;
                }
                case EXECUTE: {
                    bl2 = true;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        ZipFileAttributes zipFileAttributes = this.zfs.getFileAttributes(this.getResolvedPath());
        if (zipFileAttributes == null && (this.path.length != 1 || this.path[0] != 47)) {
            throw new NoSuchFileException(this.toString());
        }
        if (bl && this.zfs.isReadOnly()) {
            throw new AccessDeniedException(this.toString());
        }
        if (bl2) {
            throw new AccessDeniedException(this.toString());
        }
    }

    public boolean exists() {
        if (this.path.length == 1 && this.path[0] == 47) {
            return true;
        }
        try {
            return this.zfs.exists(this.getResolvedPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean notExists() {
        return !this.exists();
    }

    public OutputStream newOutputStream(OpenOption ... openOptionArray) throws IOException {
        if (openOptionArray.length == 0) {
            return this.zfs.newOutputStream(this.getResolvedPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        return this.zfs.newOutputStream(this.getResolvedPath(), openOptionArray);
    }

    public Path moveTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.zfs.provider() == path.getFileSystem().provider() && this.zfs.getZipFile().isSameFile(((ZipPath)path).zfs.getZipFile())) {
            this.zfs.copyFile(true, this.getResolvedPath(), ((ZipPath)path).getResolvedPath(), copyOptionArray);
        } else {
            this.copyToTarget(path, copyOptionArray);
            this.delete();
        }
        return path;
    }

    public Path copyTo(Path path, CopyOption ... copyOptionArray) throws IOException {
        if (this.zfs.provider() == path.getFileSystem().provider() && this.zfs.getZipFile().isSameFile(((ZipPath)path).zfs.getZipFile())) {
            this.zfs.copyFile(false, this.getResolvedPath(), ((ZipPath)path).getResolvedPath(), copyOptionArray);
        } else {
            this.copyToTarget(path, copyOptionArray);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToTarget(Path path, CopyOption ... copyOptionArray) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (CopyOption object : copyOptionArray) {
            if (object == StandardCopyOption.REPLACE_EXISTING) {
                bl = true;
                continue;
            }
            if (object != StandardCopyOption.COPY_ATTRIBUTES) continue;
            bl2 = true;
        }
        ZipFileAttributes zipFileAttributes = this.getAttributes();
        if (bl) {
            try {
                path.deleteIfExists();
                n = 0;
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                n = 1;
            }
        } else {
            n = path.exists() ? 1 : 0;
        }
        if (n != 0) {
            throw new FileAlreadyExistsException(path.toString());
        }
        if (zipFileAttributes.isDirectory()) {
            path.createDirectory(new FileAttribute[0]);
        } else {
            try (InputStream inputStream = this.zfs.newInputStream(this.getResolvedPath());
                 OutputStream iOException = path.newOutputStream(new OpenOption[0]);){
                byte[] byArray = new byte[8192];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    iOException.write(byArray, 0, n2);
                }
            }
        }
        if (bl2) {
            BasicFileAttributeView basicFileAttributeView = (BasicFileAttributeView)path.getFileAttributeView(BasicFileAttributeView.class, new LinkOption[0]);
            try {
                basicFileAttributeView.setTimes(zipFileAttributes.lastModifiedTime(), zipFileAttributes.lastAccessTime(), zipFileAttributes.creationTime());
            }
            catch (IOException iOException) {
                try {
                    path.delete();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }
}

