/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui.classbrowser;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.ui.CommonToolBar;
import com.sun.java.swing.ui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.ui.SAEditorPane;
import sun.jvm.hotspot.ui.action.HSDBActionManager;
import sun.jvm.hotspot.ui.classbrowser.HTMLGenerator;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;

public class ClassBrowserPanel
extends JPanel
implements ActionListener {
    private StatusBar statusBar;
    private ClassBrowserToolBar toolBar;
    private JSplitPane splitPane;
    private SAEditorPane classesEditor;
    private SAEditorPane contentEditor;
    private HTMLGenerator htmlGen = new HTMLGenerator();

    public ClassBrowserPanel() {
        HyperlinkListener hyperListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ClassBrowserPanel.this.contentEditor.setText(ClassBrowserPanel.this.htmlGen.genHTMLForHyperlink(e.getDescription()));
                }
            }
        };
        this.classesEditor = new SAEditorPane();
        this.classesEditor.addHyperlinkListener(hyperListener);
        this.contentEditor = new SAEditorPane();
        this.contentEditor.addHyperlinkListener(hyperListener);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JScrollPane(this.classesEditor), "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)new JScrollPane(this.contentEditor), "Center");
        this.splitPane = new JSplitPane(0, topPanel, bottomPanel);
        this.splitPane.setDividerLocation(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.statusBar = new StatusBar();
        this.add((Component)this.statusBar, "South");
        this.toolBar = new ClassBrowserToolBar(this.statusBar);
        this.add((Component)this.toolBar, "North");
        this.registerActions();
    }

    public void setClassesText(String text) {
        this.classesEditor.setText(text);
        this.splitPane.setDividerLocation(0.5);
    }

    public void setContentText(String text) {
        this.contentEditor.setText(text);
        this.splitPane.setDividerLocation(0.5);
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("find-classes-command")) {
            this.findClasses();
        }
    }

    protected void registerActions() {
        this.registerAction("find-classes-command");
    }

    private void registerAction(String actionName) {
        ActionManager manager = ActionManager.getInstance();
        DelegateAction action = manager.getDelegateAction(actionName);
        action.addActionListener(this);
    }

    private void findClasses() {
        String findText = this.toolBar.getFindText();
        if (findText == null || findText.equals("")) {
            return;
        }
        this.setContentText(this.htmlGen.genHTMLForWait("Finding classes ..."));
        InstanceKlass[] klasses = SystemDictionaryHelper.findInstanceKlasses(findText);
        if (klasses.length == 0) {
            this.setContentText(this.htmlGen.genHTMLForMessage("No class found with name containing '" + findText + "'"));
        } else {
            this.setContentText(this.htmlGen.genHTMLForKlassNames(klasses));
        }
    }

    private class ClassBrowserToolBar
    extends CommonToolBar {
        private JTextField searchTF;

        public ClassBrowserToolBar(StatusBar status) {
            super(HSDBActionManager.getInstance(), status);
        }

        protected void addComponents() {
            this.searchTF = new JTextField();
            this.searchTF.setToolTipText("Find classes");
            InputMap im = this.searchTF.getInputMap();
            im.put(KeyStroke.getKeyStroke("ENTER"), "enterPressed");
            ActionMap am = this.searchTF.getActionMap();
            am.put("enterPressed", this.manager.getAction("find-classes-command"));
            this.add(this.searchTF);
            this.addButton(this.manager.getAction("find-classes-command"));
        }

        public String getFindText() {
            return this.searchTF.getText();
        }
    }
}

