/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class SideButton
extends JButton {
    public SideButton(Action action) {
        super(action);
        this.fixIcon();
        this.doStyle();
    }

    public SideButton(Action action, boolean usename) {
        super(action);
        if (!usename) {
            this.setText(null);
        }
        this.fixIcon();
        this.doStyle();
    }

    public SideButton(Action action, String imagename) {
        super(action);
        this.setIcon(SideButton.makeIcon(imagename));
        this.doStyle();
    }

    void fixIcon() {
        Icon i = this.getIcon();
        if (i != null && i instanceof ImageIcon) {
            Image im = ((ImageIcon)i).getImage();
            this.setIcon(new ImageIcon(im.getScaledInstance(20, 20, 4)));
        }
    }

    public static ImageIcon makeIcon(String imagename) {
        Image im = ImageProvider.get("dialogs", imagename).getImage();
        return new ImageIcon(im.getScaledInstance(20, 20, 4));
    }

    public SideButton(String imagename, String property, String tooltip, ActionListener actionListener) {
        super(SideButton.makeIcon(imagename));
        this.doStyle();
        this.setActionCommand(imagename);
        this.addActionListener(actionListener);
        this.setToolTipText(tooltip);
    }

    public SideButton(String name, String imagename, String property, String tooltip, Shortcut shortcut, ActionListener actionListener) {
        super(I18n.tr(name), SideButton.makeIcon(imagename));
        if (shortcut != null) {
            shortcut.setMnemonic(this);
            if (tooltip != null) {
                tooltip = Main.platform.makeTooltip(tooltip, shortcut);
            }
        }
        this.setup(name, property, tooltip, actionListener);
    }

    public SideButton(String name, String imagename, String property, String tooltip, ActionListener actionListener) {
        super(I18n.tr(name), SideButton.makeIcon(imagename));
        this.setup(name, property, tooltip, actionListener);
    }

    private void setup(String name, String property, String tooltip, ActionListener actionListener) {
        this.doStyle();
        this.setActionCommand(name);
        this.addActionListener(actionListener);
        this.setToolTipText(tooltip);
        this.putClientProperty("help", "Dialog/" + property + "/" + name);
    }

    private void doStyle() {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setIconTextGap(2);
    }
}

