/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadStrategy;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UploadStrategySelectionPanel
extends JPanel
implements PropertyChangeListener {
    public static final String UPLOAD_STRATEGY_SPECIFICATION_PROP = UploadStrategySelectionPanel.class.getName() + ".uploadStrategySpecification";
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    private ButtonGroup bgStrategies;
    private ButtonGroup bgMultiChangesetPolicies;
    private Map<UploadStrategy, JRadioButton> rbStrategy;
    private Map<UploadStrategy, JLabel> lblNumRequests;
    private Map<UploadStrategy, JMultilineLabel> lblStrategies;
    private JTextField tfChunkSize;
    private JPanel pnlMultiChangesetPolicyPanel;
    private JRadioButton rbFillOneChangeset;
    private JRadioButton rbUseMultipleChangesets;
    private JMultilineLabel lblMultiChangesetPoliciesHeader;
    private long numUploadedObjects = 0L;

    public UploadStrategySelectionPanel() {
        this.build();
    }

    protected JPanel buildUploadStrategyPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        this.bgStrategies = new ButtonGroup();
        this.rbStrategy = new HashMap<UploadStrategy, JRadioButton>();
        this.lblStrategies = new HashMap<UploadStrategy, JMultilineLabel>();
        this.lblNumRequests = new HashMap<UploadStrategy, JLabel>();
        for (UploadStrategy strategy : UploadStrategy.values()) {
            this.rbStrategy.put(strategy, new JRadioButton());
            this.lblNumRequests.put(strategy, new JLabel());
            this.lblStrategies.put(strategy, new JMultilineLabel(""));
            this.bgStrategies.add(this.rbStrategy.get((Object)strategy));
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 4;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 3, 0);
        gc.anchor = 23;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Please select the upload strategy:")), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        gc.anchor = 23;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        JLabel lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
        lbl.setText(I18n.tr("Upload data in one request"));
        pnl.add((Component)lbl, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        lbl = this.lblStrategies.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY);
        lbl.setText(I18n.tr("Upload data in chunks of objects. Chunk size: "));
        pnl.add((Component)lbl, gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        this.tfChunkSize = new JTextField(4);
        pnl.add((Component)this.tfChunkSize, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        lbl = this.lblStrategies.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY);
        lbl.setText(I18n.tr("Upload each object individually"));
        pnl.add((Component)lbl, gc);
        gc.gridx = 3;
        gc.gridy = 3;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gc);
        this.tfChunkSize.addFocusListener(new TextFieldFocusHandler());
        this.tfChunkSize.getDocument().addDocumentListener(new ChunkSizeInputVerifier());
        StrategyChangeListener strategyChangeListener = new StrategyChangeListener();
        this.tfChunkSize.addFocusListener(strategyChangeListener);
        this.tfChunkSize.addActionListener(strategyChangeListener);
        for (UploadStrategy strategy : UploadStrategy.values()) {
            this.rbStrategy.get((Object)strategy).addItemListener(strategyChangeListener);
        }
        return pnl;
    }

    protected JPanel buildMultiChangesetPolicyPanel() {
        this.pnlMultiChangesetPolicyPanel = new JPanel();
        this.pnlMultiChangesetPolicyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        this.lblMultiChangesetPoliciesHeader = new JMultilineLabel(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. Which strategy do you want to use?</html>", this.numUploadedObjects));
        this.pnlMultiChangesetPolicyPanel.add((Component)this.lblMultiChangesetPoliciesHeader, gc);
        gc.gridy = 1;
        this.rbFillOneChangeset = new JRadioButton(I18n.tr("Fill up one changeset and return to the Upload Dialog"));
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbFillOneChangeset, gc);
        gc.gridy = 2;
        this.rbUseMultipleChangesets = new JRadioButton(I18n.tr("Open and use as many new changesets as necessary"));
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbUseMultipleChangesets, gc);
        this.bgMultiChangesetPolicies = new ButtonGroup();
        this.bgMultiChangesetPolicies.add(this.rbFillOneChangeset);
        this.bgMultiChangesetPolicies.add(this.rbUseMultipleChangesets);
        return this.pnlMultiChangesetPolicyPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.anchor = 18;
        gc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.buildUploadStrategyPanel(), gc);
        gc.gridy = 1;
        this.add((Component)this.buildMultiChangesetPolicyPanel(), gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)new JPanel(), gc);
        int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        this.pnlMultiChangesetPolicyPanel.setVisible(maxChunkSize > 0 && this.numUploadedObjects > (long)maxChunkSize);
    }

    public void setNumUploadedObjects(int numUploadedObjects) {
        this.numUploadedObjects = Math.max(numUploadedObjects, 0);
        this.updateNumRequestsLabels();
    }

    public void setUploadStrategySpecification(UploadStrategySpecification strategy) {
        if (strategy == null) {
            return;
        }
        this.rbStrategy.get((Object)strategy.getStrategy()).setSelected(true);
        this.tfChunkSize.setEnabled(strategy.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY);
        if (strategy.getStrategy().equals((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY)) {
            if (strategy.getChunkSize() != -1) {
                this.tfChunkSize.setText(Integer.toString(strategy.getChunkSize()));
            } else {
                this.tfChunkSize.setText("1");
            }
        }
    }

    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategy strategy = this.getUploadStrategy();
        int chunkSize = this.getChunkSize();
        UploadStrategySpecification spec = new UploadStrategySpecification();
        switch (strategy) {
            case INDIVIDUAL_OBJECTS_STRATEGY: {
                spec.setStrategy(strategy);
                break;
            }
            case SINGLE_REQUEST_STRATEGY: {
                spec.setStrategy(strategy);
                break;
            }
            case CHUNKED_DATASET_STRATEGY: {
                spec.setStrategy(strategy).setChunkSize(chunkSize);
            }
        }
        if (this.pnlMultiChangesetPolicyPanel.isVisible()) {
            if (this.rbFillOneChangeset.isSelected()) {
                spec.setPolicy(MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG);
            } else if (this.rbUseMultipleChangesets.isSelected()) {
                spec.setPolicy(MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS);
            } else {
                spec.setPolicy(null);
            }
        } else {
            spec.setPolicy(null);
        }
        return spec;
    }

    protected UploadStrategy getUploadStrategy() {
        UploadStrategy strategy = null;
        for (UploadStrategy s : this.rbStrategy.keySet()) {
            if (!this.rbStrategy.get((Object)s).isSelected()) continue;
            strategy = s;
            break;
        }
        return strategy;
    }

    protected int getChunkSize() {
        try {
            int chunkSize = Integer.parseInt(this.tfChunkSize.getText().trim());
            return chunkSize;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void initFromPreferences() {
        UploadStrategy strategy = UploadStrategy.getFromPreferences();
        this.rbStrategy.get((Object)strategy).setSelected(true);
        int chunkSize = Main.pref.getInteger("osm-server.upload-strategy.chunk-size", 1);
        this.tfChunkSize.setText(Integer.toString(chunkSize));
        this.updateNumRequestsLabels();
    }

    public void rememberUserInput() {
        UploadStrategy strategy = this.getUploadStrategy();
        UploadStrategy.saveToPreferences(strategy);
        try {
            int chunkSize = Integer.parseInt(this.tfChunkSize.getText().trim());
            Main.pref.putInteger("osm-server.upload-strategy.chunk-size", chunkSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void updateNumRequestsLabels() {
        JLabel lbl;
        int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (maxChunkSize > 0 && this.numUploadedObjects > (long)maxChunkSize) {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(false);
            lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            lbl.setIcon(ImageProvider.get("warning-small.png"));
            lbl.setText(I18n.tr("Upload in one request not possible (too many objects to upload)"));
            lbl.setToolTipText(I18n.tr("<html>Cannot upload {0} objects in one request because the<br>max. changeset size {1} on server ''{2}'' is exceeded.</html>", this.numUploadedObjects, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
            this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setSelected(true);
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(false);
            this.lblMultiChangesetPoliciesHeader.setText(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. What strategy do you want to use?</html>", this.numUploadedObjects));
            if (!this.rbFillOneChangeset.isSelected() && !this.rbUseMultipleChangesets.isSelected()) {
                this.rbUseMultipleChangesets.setSelected(true);
            }
            this.pnlMultiChangesetPolicyPanel.setVisible(true);
        } else {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(true);
            lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            lbl.setText(I18n.tr("Upload data in one request"));
            lbl.setIcon(null);
            lbl.setToolTipText("");
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(true);
            this.pnlMultiChangesetPolicyPanel.setVisible(false);
        }
        this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setText(I18n.tr("(1 request)"));
        if (this.numUploadedObjects == 0L) {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.tr("(# requests unknown)"));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)"));
        } else {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", this.numUploadedObjects, this.numUploadedObjects));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)"));
            int chunkSize = this.getChunkSize();
            if (chunkSize == -1) {
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)"));
            } else {
                int chunks = (int)Math.ceil((double)this.numUploadedObjects / (double)chunkSize);
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", chunks, chunks));
            }
        }
    }

    public void initEditingOfChunkSize() {
        this.tfChunkSize.requestFocusInWindow();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.setNumUploadedObjects((Integer)evt.getNewValue());
        }
    }

    class StrategyChangeListener
    implements ItemListener,
    FocusListener,
    ActionListener {
        StrategyChangeListener() {
        }

        protected void notifyStrategy() {
            UploadStrategySelectionPanel.this.firePropertyChange(UPLOAD_STRATEGY_SPECIFICATION_PROP, null, UploadStrategySelectionPanel.this.getUploadStrategySpecification());
        }

        public void itemStateChanged(ItemEvent e) {
            UploadStrategy strategy = UploadStrategySelectionPanel.this.getUploadStrategy();
            if (strategy == null) {
                return;
            }
            switch (strategy) {
                case CHUNKED_DATASET_STRATEGY: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(true);
                    UploadStrategySelectionPanel.this.tfChunkSize.requestFocusInWindow();
                    break;
                }
                default: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(false);
                }
            }
            this.notifyStrategy();
        }

        public void focusGained(FocusEvent arg0) {
        }

        public void focusLost(FocusEvent arg0) {
            this.notifyStrategy();
        }

        public void actionPerformed(ActionEvent arg0) {
            this.notifyStrategy();
        }
    }

    class ChunkSizeInputVerifier
    implements DocumentListener,
    PropertyChangeListener {
        ChunkSizeInputVerifier() {
        }

        protected void setErrorFeedback(JTextField tf, String message) {
            tf.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            tf.setToolTipText(message);
            tf.setBackground(BG_COLOR_ERROR);
        }

        protected void clearErrorFeedback(JTextField tf, String message) {
            tf.setBorder(UIManager.getBorder("TextField.border"));
            tf.setToolTipText(message);
            tf.setBackground(UIManager.getColor("TextField.background"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void valiateChunkSize() {
            try {
                int chunkSize = Integer.parseInt(UploadStrategySelectionPanel.this.tfChunkSize.getText().trim());
                int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
                if (chunkSize <= 0) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Illegal chunk size <= 0. Please enter an integer > 1"));
                } else if (maxChunkSize > 0 && chunkSize > maxChunkSize) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", chunkSize, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
                } else {
                    this.clearErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Please enter an integer > 1"));
                }
                if (maxChunkSize > 0 && chunkSize > maxChunkSize) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", chunkSize, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
                }
            }
            catch (NumberFormatException e) {
                this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Value ''{0}'' is not a number. Please enter an integer > 1", UploadStrategySelectionPanel.this.tfChunkSize.getText().trim()));
            }
            finally {
                UploadStrategySelectionPanel.this.updateNumRequestsLabels();
            }
        }

        public void changedUpdate(DocumentEvent arg0) {
            this.valiateChunkSize();
        }

        public void insertUpdate(DocumentEvent arg0) {
            this.valiateChunkSize();
        }

        public void removeUpdate(DocumentEvent arg0) {
            this.valiateChunkSize();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == UploadStrategySelectionPanel.this.tfChunkSize && evt.getPropertyName().equals("enabled") && ((Boolean)evt.getNewValue()).booleanValue()) {
                this.valiateChunkSize();
            }
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTextField) {
                JTextField tf = (JTextField)c;
                tf.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

