/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private static final StackTraceElement[] EMPTY_STACK = new StackTraceElement[0];
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;
    private static final List<Throwable> SUPPRESSED_SENTINEL = Collections.unmodifiableList(new ArrayList(0));
    private List<Throwable> suppressedExceptions = SUPPRESSED_SENTINEL;
    private static final String NULL_CAUSE_MESSAGE = "Cannot suppress a null exception.";
    private static final String SELF_SUPPRESSION_MESSAGE = "Self-suppression not permitted";
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public Throwable(String string, Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = string;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this.fillInStackTrace();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public synchronized Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable throwable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (throwable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = throwable;
        return this;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new WrappedPrintStream(printStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter printStreamOrWriter) {
        Set<Throwable> set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(this);
        Object object = printStreamOrWriter.lock();
        synchronized (object) {
            printStreamOrWriter.println(this);
            StackTraceElement[] stackTraceElementArray = this.getOurStackTrace();
            for (StackTraceElement serializable : stackTraceElementArray) {
                printStreamOrWriter.println("\tat " + serializable);
            }
            for (Serializable serializable : this.getSuppressed()) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray, SUPPRESSED_CAPTION, "\t", set);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray, CAUSE_CAPTION, "", set);
            }
        }
    }

    private void printEnclosedStackTrace(PrintStreamOrWriter printStreamOrWriter, StackTraceElement[] stackTraceElementArray, String string, String string2, Set<Throwable> set) {
        assert (Thread.holdsLock(printStreamOrWriter.lock()));
        if (set.contains(this)) {
            printStreamOrWriter.println("\t[CIRCULAR REFERENCE:" + this + "]");
        } else {
            set.add(this);
            StackTraceElement[] stackTraceElementArray2 = this.getOurStackTrace();
            int n = stackTraceElementArray2.length - 1;
            for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
            }
            int n2 = stackTraceElementArray2.length - 1 - n;
            printStreamOrWriter.println(string2 + string + this);
            for (int i = 0; i <= n; ++i) {
                printStreamOrWriter.println(string2 + "\tat " + stackTraceElementArray2[i]);
            }
            if (n2 != 0) {
                printStreamOrWriter.println(string2 + "\t... " + n2 + " more");
            }
            for (Throwable throwable : this.getSuppressed()) {
                throwable.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray2, SUPPRESSED_CAPTION, string2 + "\t", set);
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                super.printEnclosedStackTrace(printStreamOrWriter, stackTraceElementArray2, CAUSE_CAPTION, string2, set);
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(new WrappedPrintWriter(printWriter));
    }

    public synchronized native Throwable fillInStackTrace();

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            int n = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[n];
            for (int i = 0; i < n; ++i) {
                this.stackTrace[i] = this.getStackTraceElement(i);
            }
        }
        return this.stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        StackTraceElement[] stackTraceElementArray2 = (StackTraceElement[])stackTraceElementArray.clone();
        for (int i = 0; i < stackTraceElementArray2.length; ++i) {
            if (stackTraceElementArray2[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        Throwable throwable = this;
        synchronized (throwable) {
            this.stackTrace = stackTraceElementArray2;
        }
    }

    native int getStackTraceDepth();

    native StackTraceElement getStackTraceElement(int var1);

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.suppressedExceptions != null) {
            Object object = null;
            if (this.suppressedExceptions.isEmpty()) {
                object = SUPPRESSED_SENTINEL;
            } else {
                object = new ArrayList(1);
                for (Throwable throwable : this.suppressedExceptions) {
                    if (throwable == null) {
                        throw new NullPointerException(NULL_CAUSE_MESSAGE);
                    }
                    if (throwable == this) {
                        throw new IllegalArgumentException(SELF_SUPPRESSION_MESSAGE);
                    }
                    object.add(throwable);
                }
            }
            this.suppressedExceptions = object;
        }
        if (this.stackTrace != null) {
            for (StackTraceElement stackTraceElement : this.stackTrace) {
                if (stackTraceElement != null) continue;
                throw new NullPointerException("null StackTraceElement in serial stream. ");
            }
        } else {
            this.stackTrace = EMPTY_STACK;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        objectOutputStream.defaultWriteObject();
    }

    public final synchronized void addSuppressed(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException(SELF_SUPPRESSION_MESSAGE);
        }
        if (throwable == null) {
            if (this.suppressedExceptions == SUPPRESSED_SENTINEL) {
                this.suppressedExceptions = null;
                return;
            }
            throw new NullPointerException(NULL_CAUSE_MESSAGE);
        }
        assert (throwable != null && throwable != this);
        if (this.suppressedExceptions == null) {
            return;
        }
        if (this.suppressedExceptions == SUPPRESSED_SENTINEL) {
            this.suppressedExceptions = new ArrayList<Throwable>(1);
        }
        assert (this.suppressedExceptions != SUPPRESSED_SENTINEL);
        this.suppressedExceptions.add(throwable);
    }

    public final synchronized Throwable[] getSuppressed() {
        if (this.suppressedExceptions == SUPPRESSED_SENTINEL || this.suppressedExceptions == null) {
            return EMPTY_THROWABLE_ARRAY;
        }
        return this.suppressedExceptions.toArray(EMPTY_THROWABLE_ARRAY);
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return this.printWriter;
        }

        @Override
        void println(Object object) {
            this.printWriter.println(object);
        }
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return this.printStream;
        }

        @Override
        void println(Object object) {
            this.printStream.println(object);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        abstract Object lock();

        abstract void println(Object var1);
    }
}

