/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XTextComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.AuthenticationRequest;
import com.sun.star.ucb.InteractiveAugmentedIOException;
import com.sun.star.ucb.InteractiveNetworkConnectException;
import com.sun.star.ucb.InteractiveNetworkResolveNameException;
import com.sun.star.ucb.OpenCommandArgument2;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.common.UCB;
import com.sun.star.wizards.ui.UIConsts;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import com.sun.star.wizards.web.AbstractErrorHandler;
import com.sun.star.wizards.web.FTPDialogResources;
import com.sun.star.wizards.web.WWHID;
import com.sun.star.wizards.web.data.CGPublish;
import com.sun.star.wizards.web.data.CGSettings;
import java.util.List;
import java.util.Vector;

public class FTPDialog
extends UnoDialog2
implements UIConsts,
WWHID {
    private static final int STATUS_UNKONWN = 0;
    private static final int STATUS_OK = 1;
    private static final int STATUS_USER_PWD_WRONG = 2;
    private static final int STATUS_SERVER_NOT_FOUND = 3;
    private static final int STATUS_NO_RIGHTS = 4;
    private static final int STATUS_HOST_UNREACHABLE = 5;
    private static final int STATUS_CONNECTING = 6;
    private static final String ICON_ERROR = "ftperror.gif";
    private static final String ICON_OK = "ftpconnected.gif";
    private static final String ICON_UNKNOWN = "ftpunknown.gif";
    private static final String ICON_CONNECTING = "ftpconnecting.gif";
    private XControl ln1;
    private XFixedText lblFTPAddress;
    private XTextComponent txtHost;
    private XFixedText lblUsername;
    private XTextComponent txtUsername;
    private XFixedText lblPassword;
    private XTextComponent txtPassword;
    private XControl ln2;
    private XButton btnTestConnection;
    private XControl imgStatus;
    private XFixedText lblStatus;
    private XControl ln3;
    private XTextComponent txtDir;
    private XButton btnDir;
    private XButton btnOK;
    private XButton btnCancel;
    private XButton btnHelp;
    private FTPDialogResources resources;
    private List dataAware = new Vector();
    public String username = "";
    public String password = "";
    public String host = "";
    private String dir = "";
    private CGPublish publish;
    private UCB ucb;
    private String imagesDirectory;

    public FTPDialog(XMultiServiceFactory xMultiServiceFactory, CGPublish cGPublish) throws Exception {
        super(xMultiServiceFactory);
        this.publish = cGPublish;
        this.imagesDirectory = FileAccess.connectURLs(((CGSettings)this.publish.root).soTemplateDir, "../wizard/bitmap/");
        this.resources = new FTPDialogResources(xMultiServiceFactory);
        this.ucb = new UCB(xMultiServiceFactory);
        Helper.setUnoPropertyValues(this.xDialogModel, new String[]{"Closeable", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, "Moveable", PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "Title", PropertyNames.PROPERTY_WIDTH}, new Object[]{Boolean.TRUE, new Integer(160), HelpIds.getHelpIdString(41040), Boolean.TRUE, "FTPDialog", new Integer(167), new Integer(82), this.resources.resFTPDialog_title, new Integer(222)});
        this.build();
        this.configure();
        this.disconnect();
    }

    public void build() {
        String[] stringArray = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
        String[] stringArray2 = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
        String[] stringArray3 = new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
        this.ln1 = this.insertFixedLine("ln1", stringArray, new Object[]{INTEGERS[8], this.resources.resln1_value, "ln1", INTEGERS[6], INTEGERS[6], new Short(0), new Integer(210)});
        this.lblFTPAddress = this.insertLabel("lblFTPAddress", stringArray, new Object[]{INTEGERS[8], this.resources.reslblFTPAddress_value, "lblFTPAddress", INTEGER_12, new Integer(20), new Short(1), new Integer(95)});
        this.txtHost = this.insertTextField("txtHost", "disconnect", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{INTEGER_12, HelpIds.getHelpIdString(41041), "txtIP", new Integer(110), new Integer(18), new Short(2), new Integer(106)});
        this.lblUsername = this.insertLabel("lblUsername", stringArray, new Object[]{INTEGERS[8], this.resources.reslblUsername_value, "lblUsername", INTEGER_12, new Integer(36), new Short(3), new Integer(85)});
        this.txtUsername = this.insertTextField("txtUsername", "disconnect", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{INTEGER_12, HelpIds.getHelpIdString(41042), "txtUsername", new Integer(110), new Integer(34), new Short(4), new Integer(106)});
        this.lblPassword = this.insertLabel("lblPassword", stringArray, new Object[]{INTEGERS[8], this.resources.reslblPassword_value, "lblPassword", INTEGER_12, new Integer(52), new Short(5), new Integer(85)});
        this.txtPassword = this.insertTextField("txtPassword", "disconnect", new String[]{"EchoChar", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{new Short(42), INTEGER_12, HelpIds.getHelpIdString(41043), "txtPassword", new Integer(110), new Integer(50), new Short(6), new Integer(106)});
        this.ln2 = this.insertFixedLine("ln2", stringArray, new Object[]{INTEGERS[8], this.resources.resln2_value, "ln2", INTEGERS[6], new Integer(68), new Short(7), new Integer(210)});
        this.btnTestConnection = this.insertButton("btnConnect", "connect", stringArray2, new Object[]{INTEGER_14, HelpIds.getHelpIdString(41044), this.resources.resbtnConnect_value, "btnConnect", INTEGER_12, new Integer(80), new Short(8), INTEGER_50});
        this.imgStatus = this.insertImage("imgStatus", new String[]{"Border", PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "ScaleImage", "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{new Short(0), INTEGER_14, new Integer(68), new Integer(80), Boolean.FALSE, Boolean.FALSE, INTEGER_14});
        this.lblStatus = this.insertLabel("lblStatus", stringArray, new Object[]{INTEGERS[8], this.resources.resFTPDisconnected, "lblStatus", new Integer(86), new Integer(82), new Short(9), new Integer(99)});
        this.ln3 = this.insertFixedLine("ln3", stringArray, new Object[]{INTEGERS[8], this.resources.resln3_value, "ln3", INTEGERS[6], new Integer(100), new Short(10), new Integer(210)});
        this.txtDir = this.insertTextField("txtDir", null, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_TABINDEX, "Text", PropertyNames.PROPERTY_WIDTH}, new Object[]{new Boolean(false), INTEGER_12, HelpIds.getHelpIdString(41045), "txtDir", INTEGER_12, new Integer(113), new Short(11), this.resources.restxtDir_value, new Integer(184)});
        this.btnDir = this.insertButton("btnDir", "chooseDirectory", stringArray2, new Object[]{INTEGER_14, HelpIds.getHelpIdString(41046), this.resources.resbtnDir_value, "btnDir", new Integer(199), new Integer(112), new Short(12), INTEGER_16});
        this.btnOK = this.insertButton("btnOK", null, stringArray3, new Object[]{INTEGER_14, HelpIds.getHelpIdString(41047), this.resources.resbtnOK_value, "btnOK", new Integer(165), new Integer(142), new Short(1), new Short(13), INTEGER_50});
        this.btnCancel = this.insertButton("btnCancel", null, stringArray3, new Object[]{INTEGER_14, HelpIds.getHelpIdString(41048), this.resources.resbtnCancel_value, "btnCancel", new Integer(113), new Integer(142), new Short(2), new Short(14), INTEGER_50});
        this.btnHelp = this.insertButton("btnHelp", null, stringArray3, new Object[]{INTEGER_14, "", this.resources.resbtnHelp_value, "btnHelp", new Integer(57), new Integer(142), new Short(3), new Short(15), INTEGER_50});
    }

    private void configure() {
        this.dataAware.add(UnoDataAware.attachEditControl(this, "host", this.txtHost, null, true));
        this.dataAware.add(UnoDataAware.attachEditControl(this, "username", this.txtUsername, null, true));
        this.dataAware.add(UnoDataAware.attachEditControl(this, "password", this.txtPassword, null, true));
    }

    public short execute(UnoDialog unoDialog) throws Exception {
        this.host = this.extractHost(this.publish.cp_URL);
        this.username = this.publish.cp_Username == null ? "" : this.publish.cp_Username;
        this.password = this.publish.password == null ? "" : this.publish.password;
        this.dir = this.extractDir(this.publish.cp_URL);
        this.setLabel(0);
        this.enableTestButton();
        this.updateUI();
        short s = this.executeDialog(unoDialog);
        if (s == 1) {
            this.publish.cp_URL = "ftp://" + this.host() + this.getDir();
            this.publish.cp_Username = this.username;
            this.publish.password = this.password;
        }
        return s;
    }

    private void updateUI() {
        DataAware.updateUI(this.dataAware);
        this.setDir(this.dir);
    }

    private String extractHost(String string) {
        if (string == null || string.length() < 6) {
            return "";
        }
        String string2 = string.substring(6);
        int n = string2.indexOf("/");
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private String extractDir(String string) {
        if (string == null || string.length() < 6) {
            return "/";
        }
        String string2 = string.substring(6);
        int n = string2.indexOf("/");
        if (n == -1) {
            return "/";
        }
        return string2.substring(n);
    }

    private void enableTestButton() {
        FTPDialog.setEnabled((Object)this.btnTestConnection, !this.isEmpty(this.host) && !this.isEmpty(this.username) && !this.isEmpty(this.password));
    }

    private final boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public String getAcountUrl() {
        return "ftp://" + this.username + ":" + this.password + "@" + this.host();
    }

    private String host() {
        return FTPDialog.host(this.host);
    }

    private static String host(String string) {
        return string.startsWith("ftp://") ? string.substring(6) : string;
    }

    private String getFullUrl() {
        return this.getAcountUrl() + this.dir;
    }

    public void connect() {
        FTPDialog.setEnabled((Object)this.btnTestConnection, false);
        this.setLabel(6);
        boolean bl = false;
        try {
            this.connect(this.getFullUrl());
            bl = true;
        }
        catch (InteractiveAugmentedIOException interactiveAugmentedIOException) {
            try {
                this.connect(this.getAcountUrl());
                this.setDir("/");
                bl = true;
            }
            catch (Exception exception) {
                this.setLabel(4);
            }
        }
        catch (InteractiveNetworkResolveNameException interactiveNetworkResolveNameException) {
            this.setLabel(3);
        }
        catch (AuthenticationRequest authenticationRequest) {
            this.setLabel(2);
        }
        catch (InteractiveNetworkConnectException interactiveNetworkConnectException) {
            this.setLabel(5);
        }
        catch (Exception exception) {
            this.setLabel(-1);
            exception.printStackTrace();
        }
        if (bl) {
            this.setLabel(1);
            FTPDialog.setEnabled((Object)this.btnDir, true);
            FTPDialog.setEnabled((Object)this.btnOK, true);
        }
        FTPDialog.setEnabled((Object)this.btnTestConnection, true);
    }

    private void connect(String string) throws Exception {
        Object object = this.ucb.getContent(string);
        List list = this.ucb.listFiles(string, null);
        OpenCommandArgument2 openCommandArgument2 = new OpenCommandArgument2();
        openCommandArgument2.Mode = 1;
        openCommandArgument2.Priority = 32768;
        this.ucb.executeCommand(object, "open", openCommandArgument2);
        Object object2 = this.ucb.getContentProperty(object, "Title", String.class);
    }

    public void setDir(String string) {
        this.dir = string;
        Helper.setUnoPropertyValue(FTPDialog.getModel(this.txtDir), "Text", this.dir);
    }

    public String getDir() {
        return this.dir;
    }

    public void disconnect() {
        this.enableTestButton();
        FTPDialog.setEnabled((Object)this.btnOK, false);
        FTPDialog.setEnabled((Object)this.btnDir, false);
        this.setLabel(0);
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=localhost,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.ServiceManager";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            CGPublish cGPublish = new CGPublish();
            cGPublish.cp_URL = "ftp://tv-1/Folder";
            cGPublish.cp_Username = "ronftp";
            cGPublish.password = "ronftp";
            FTPDialog fTPDialog = new FTPDialog(xMultiServiceFactory, cGPublish);
            fTPDialog.execute(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setLabel(int n) {
        switch (n) {
            case 0: {
                this.setLabel(this.resources.resFTPDisconnected, ICON_UNKNOWN);
                break;
            }
            case 1: {
                this.setLabel(this.resources.resFTPConnected, ICON_OK);
                break;
            }
            case 2: {
                this.setLabel(this.resources.resFTPUserPwdWrong, ICON_ERROR);
                break;
            }
            case 3: {
                this.setLabel(this.resources.resFTPServerNotFound, ICON_ERROR);
                break;
            }
            case 4: {
                this.setLabel(this.resources.resFTPRights, ICON_ERROR);
                break;
            }
            case 5: {
                this.setLabel(this.resources.resFTPHostUnreachable, ICON_ERROR);
                break;
            }
            case 6: {
                this.setLabel(this.resources.resConnecting, ICON_CONNECTING);
                break;
            }
            default: {
                this.setLabel(this.resources.resFTPUnknownError, ICON_ERROR);
            }
        }
    }

    private void setLabel(String string, String string2) {
        Helper.setUnoPropertyValue(FTPDialog.getModel(this.lblStatus), PropertyNames.PROPERTY_LABEL, string);
        Helper.setUnoPropertyValue(FTPDialog.getModel(this.imgStatus), PropertyNames.PROPERTY_IMAGEURL, this.imageUrl(string2));
    }

    private String imageUrl(String string) {
        String string2 = this.imagesDirectory + string;
        return string2;
    }

    public void chooseDirectory() {
        SystemDialog systemDialog = SystemDialog.createOfficeFolderDialog(this.xMSF);
        String string = systemDialog.callFolderDialog(this.resources.resFTPDirectory, "", this.getFullUrl());
        if (string != null) {
            if (string.startsWith("ftp://")) {
                this.setDir(this.extractDir(string));
            } else {
                AbstractErrorHandler.showMessage(this.xMSF, this.xControl.getPeer(), this.resources.resIllegalFolder, 1);
            }
        }
    }

    public static final String getFullURL(CGPublish cGPublish) {
        return "ftp://" + cGPublish.cp_Username + ":" + cGPublish.password + "@" + FTPDialog.host(cGPublish.cp_URL);
    }
}

