/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStatusListener;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseBroadcaster;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiArticle;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiOptionsEventHandlerImpl;
import com.sun.star.wiki.WikiPropDialog;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLException;

public final class WikiEditorImpl
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XDispatch,
XInitialization {
    private final XComponentContext m_xContext;
    private static final String m_implementationName = WikiEditorImpl.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.wiki.WikiEditor"};
    public static final String[] supportedServiceNames = new String[]{"com.sun.star.frame.ProtocolHandler"};
    public static final Class implementationClass = WikiEditorImpl.class;
    public static final String protocolName = "vnd.com.sun.star.wiki:";
    private Map m_statusListeners = new HashMap();
    private XComponent xComp;
    private String sTempUrl;
    private XFrame m_xFrame;
    private XModel m_xModel;
    private Settings m_aSettings;
    private String m_aFilterName;
    private XSelectionSupplier m_sel;
    private XController m_ctrl;
    private boolean m_bInitialized;

    public WikiEditorImpl(XComponentContext xComponentContext) {
        this.m_xContext = xComponentContext;
        this.m_aSettings = Settings.getSettings(this.m_xContext);
    }

    public static XSingleComponentFactory __getComponentFactory(String string) {
        XSingleComponentFactory xSingleComponentFactory = null;
        if (string.equals(m_implementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(WikiEditorImpl.class, (String[])m_serviceNames);
        } else if (string.equals(WikiOptionsEventHandlerImpl.m_sImplementationName)) {
            xSingleComponentFactory = Factory.createComponentFactory(WikiOptionsEventHandlerImpl.class, (String[])WikiOptionsEventHandlerImpl.m_pServiceNames);
        }
        return xSingleComponentFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        boolean bl = Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
        return bl && Factory.writeRegistryServiceInfo((String)WikiOptionsEventHandlerImpl.m_sImplementationName, (String[])WikiOptionsEventHandlerImpl.m_pServiceNames, (XRegistryKey)xRegistryKey);
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String string) {
        int n = m_serviceNames.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public synchronized void initialize(Object[] objectArray) throws com.sun.star.uno.Exception {
        if (this.m_bInitialized) {
            // empty if block
        }
        if (objectArray.length > 0) {
            this.m_bInitialized = true;
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)objectArray[0]);
            XCloseBroadcaster xCloseBroadcaster = (XCloseBroadcaster)UnoRuntime.queryInterface(XCloseBroadcaster.class, (Object)this.m_xFrame);
        }
    }

    public void dispatch(URL uRL, PropertyValue[] propertyValueArray) {
        URL uRL2 = uRL;
        if (uRL.Protocol.compareTo(protocolName) == 0) {
            try {
                if (uRL2.Path.compareTo("send") == 0) {
                    this.sendArticle();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public XDispatch queryDispatch(URL uRL, String string, int n) {
        if (uRL.Protocol.equals(protocolName)) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] dispatchDescriptorArray) {
        int n = dispatchDescriptorArray.length;
        XDispatch[] xDispatchArray = new XDispatch[n];
        for (int i = 0; i < n; ++i) {
            xDispatchArray[i] = this.queryDispatch(dispatchDescriptorArray[i].FeatureURL, dispatchDescriptorArray[i].FrameName, dispatchDescriptorArray[i].SearchFlags);
        }
        return xDispatchArray;
    }

    public void removeStatusListener(XStatusListener xStatusListener, URL uRL) {
    }

    public void addStatusListener(XStatusListener xStatusListener, URL uRL) {
        String string = uRL.Complete;
        this.m_statusListeners.put(string, xStatusListener);
        this.callStatusListener(string, xStatusListener);
    }

    public void callStatusListeners() {
        Set set = this.m_statusListeners.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            XStatusListener xStatusListener = (XStatusListener)entry.getValue();
            this.callStatusListener(string, xStatusListener);
        }
    }

    public void callStatusListener(String string, XStatusListener xStatusListener) {
        try {
            URI uRI = new URI(string);
            this.setListenerState(xStatusListener, "command", false);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    private void setListenerState(XStatusListener xStatusListener, String string, boolean bl) {
        URL uRL = new URL();
        uRL.Complete = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendArticle() {
        if (this.m_xFrame != null) {
            WikiDialog wikiDialog = null;
            try {
                Object object;
                if (this.m_xModel == null && (object = this.m_xFrame.getController()) != null) {
                    this.m_xModel = object.getModel();
                }
                if (this.m_xModel != null) {
                    object = Helper.GetDocServiceName(this.m_xContext, this.m_xModel);
                    this.m_aFilterName = Helper.GetFilterName(this.m_xContext, "MediaWiki", (String)object);
                    if (this.m_aFilterName == null || this.m_aFilterName.length() == 0) {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 1, null, false);
                        throw new RuntimeException();
                    }
                    this.m_aSettings.loadConfiguration();
                    wikiDialog = new WikiPropDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.SendToMediaWiki?location=application", this);
                    ((WikiPropDialog)wikiDialog).fillWikiList();
                    ((WikiPropDialog)wikiDialog).SetWikiTitle(Helper.GetDocTitle(this.m_xModel));
                    ((WikiPropDialog)wikiDialog).show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (wikiDialog != null) {
                    wikiDialog.DisposeDialog();
                }
            }
        }
    }

    public boolean SendArticleImpl(WikiPropDialog wikiPropDialog, Hashtable hashtable) {
        boolean bl = false;
        if (wikiPropDialog != null) {
            Object object;
            String string = null;
            try {
                object = new WikiArticle(this.m_xContext, wikiPropDialog.GetWikiTitle(), hashtable, true, wikiPropDialog);
                boolean bl2 = true;
                if (!((WikiArticle)object).NotExist()) {
                    wikiPropDialog.SetThrobberActive(false);
                    bl2 = Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 32, wikiPropDialog.GetWikiTitle(), true);
                    wikiPropDialog.SetThrobberActive(true);
                }
                if (bl2) {
                    PropertyValue[] propertyValueArray = new PropertyValue[2];
                    propertyValueArray[0] = new PropertyValue();
                    propertyValueArray[0].Name = "FilterName";
                    propertyValueArray[0].Value = this.m_aFilterName;
                    propertyValueArray[1] = new PropertyValue();
                    propertyValueArray[1].Name = "Overwrite";
                    propertyValueArray[1].Value = new Boolean(true);
                    string = Helper.CreateTempFile(this.m_xContext);
                    XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.m_xModel);
                    if (xStorable == null) {
                        throw new RuntimeException();
                    }
                    xStorable.storeToURL(string, propertyValueArray);
                    String string2 = Helper.EachLine(string);
                    if (((WikiArticle)object).setArticle(string2, wikiPropDialog.m_sWikiComment, wikiPropDialog.m_bWikiMinorEdit)) {
                        bl = true;
                        Object object2 = this.m_xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", this.m_xContext);
                        XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)object2);
                        Helper.SetDocTitle(this.m_xModel, ((WikiArticle)object).GetTitle());
                        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                        hashtable2.put("Doc", ((WikiArticle)object).GetTitle());
                        hashtable2.put("Url", ((WikiArticle)object).GetMainURL());
                        hashtable2.put("CompleteUrl", ((WikiArticle)object).GetMainURL() + ((WikiArticle)object).GetTitle());
                        this.m_aSettings.addWikiDoc(hashtable2);
                        this.m_aSettings.storeConfiguration();
                    } else {
                        Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                    }
                }
            }
            catch (WikiCancelException wikiCancelException) {
            }
            catch (SSLException sSLException) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 25, null, false);
                }
            }
            catch (Exception exception) {
                if (Helper.IsConnectionAllowed()) {
                    Helper.ShowError(this.m_xContext, (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.m_xFrame.getContainerWindow()), 6, 0, null, false);
                }
                exception.printStackTrace();
            }
            if (string != null) {
                try {
                    object = new File(new URI(string));
                    ((File)object).delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }
}

