/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.deps.DependenciesProvider;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ui.DependenciesEditorPanel;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class DependenciesPanel
extends JPanel {
    private final JCProjectProperties props;
    private ResolvedDependencies deps;
    private final Object lock = new Object();
    private Cancellable cancel;

    public DependenciesPanel(JCProjectProperties props) {
        this.props = props;
        this.setLayout(new BorderLayout());
        JLabel lbl = new JLabel(NbBundle.getMessage(DependenciesPanel.class, (String)"MSG_LOADING"));
        this.add((Component)lbl, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        if (this.deps == null) {
            Object object = this.lock;
            synchronized (object) {
                this.cancel = this.props.getDependencies(new R());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancel != null) {
                this.cancel.cancel();
                this.cancel = null;
            }
        }
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDependencies(ResolvedDependencies deps) {
        Object object = this.lock;
        synchronized (object) {
            this.deps = deps;
            if (this.cancel == null) {
                return;
            }
            this.cancel = null;
        }
        if (deps != null) {
            this.removeAll();
            this.add((Component)new DependenciesEditorPanel(this.props.getProject(), deps), "Center");
        } else {
            this.removeAll();
            this.add(new JLabel(NbBundle.getMessage(DependenciesPanel.class, (String)"MSG_LOAD_FAILED")));
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolvedDependencies getDependencies() {
        Object object = this.lock;
        synchronized (object) {
            return this.deps;
        }
    }

    private class R
    implements DependenciesProvider.Receiver,
    Runnable {
        private volatile ResolvedDependencies deps;

        private R() {
        }

        @Override
        public void receive(ResolvedDependencies deps) {
            this.deps = deps;
            EventQueue.invokeLater(this);
        }

        @Override
        public boolean failed(Throwable failure) {
            DependenciesPanel.this.setDependencies(null);
            return true;
        }

        @Override
        public void run() {
            DependenciesPanel.this.setDependencies(this.deps);
        }
    }
}

