/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.simpleunit.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.simpleunit.wizard.GenerateTestChooseElementsVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateTestChooseElementsWizardPanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    private GenerateTestChooseElementsVisualPanel component;
    private final String unitTestKind;
    private final ChangeSupport cs;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private RequestProcessor.Task task;
    private WizardDescriptor wizard;

    public GenerateTestChooseElementsWizardPanel(String unitTestKind) {
        this.unitTestKind = unitTestKind;
        this.cs = new ChangeSupport((Object)this);
    }

    public GenerateTestChooseElementsVisualPanel getComponent() {
        if (this.component == null) {
            this.component = new GenerateTestChooseElementsVisualPanel();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("UnitTestCppUnit".equals(this.unitTestKind) ? "CreateCppUnitTestWizardP1" : "CreateTestWizardP1");
    }

    public boolean isValid() {
        return this.initialized.get();
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
        if (!this.initialized.get() && this.task == null) {
            this.component.showLoadingNode();
            RunnableImpl runnable = new RunnableImpl();
            this.task = RequestProcessor.getDefault().post((Runnable)runnable);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        settings.putProperty("UnitTestFunctions", this.component.getSelectedElements());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RunnableImpl
    implements Runnable {
        private ElementNode.Description topDescription = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                GenerateTestChooseElementsWizardPanel.this.initialized.set(true);
                GenerateTestChooseElementsWizardPanel.this.component.setRootElement(this.topDescription);
                GenerateTestChooseElementsWizardPanel.this.fireChangeEvent();
            } else {
                try {
                    this.initializeTopLevelDescriptions();
                }
                finally {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        private void initializeTopLevelDescriptions() {
            Lookup lookup = (Lookup)GenerateTestChooseElementsWizardPanel.this.wizard.getProperty("UnitTestContextLookup");
            Parameters.notNull((CharSequence)"Lookup must be initialized in 'UnitTestContextLookup' property of wizard", (Object)lookup);
            DataObject dob = (DataObject)lookup.lookup(DataObject.class);
            if (dob != null) {
                GenerateTestChooseElementsWizardPanel.this.wizard.putProperty("UnitTestDefaultName", (Object)dob.getName());
                CsmFile file = CsmUtilities.getCsmFile((DataObject)dob, (boolean)false, (boolean)false);
                this.topDescription = null;
                if (file != null) {
                    Collection delcs = file.getDeclarations();
                    HashMap<CsmScope, Collection<CsmFunction>> functions = new HashMap<CsmScope, Collection<CsmFunction>>();
                    this.extractFunctions(functions, delcs);
                    List<ElementNode.Description> topDescrs = this.convert(file, functions);
                    this.topDescription = ElementNode.Description.create(topDescrs);
                }
            }
        }

        private void extractFunctions(Map<CsmScope, Collection<CsmFunction>> functions, Collection<CsmOffsetableDeclaration> delcs) {
            for (CsmOffsetableDeclaration decl : delcs) {
                if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                    CsmScope scope;
                    CsmFunction fun = this.handleFunction((CsmFunction)decl);
                    if (fun == null || (scope = fun.getScope()) == null) continue;
                    Collection<CsmFunction> scopeFunctions = functions.get(scope);
                    if (scopeFunctions == null) {
                        scopeFunctions = new LinkedHashSet<CsmFunction>();
                    }
                    if (scopeFunctions.contains(fun)) continue;
                    scopeFunctions.add(fun);
                    functions.put(scope, scopeFunctions);
                    continue;
                }
                if (CsmKindUtilities.isClass((CsmObject)decl)) {
                    this.extractMethods(functions, (CsmClass)decl);
                    continue;
                }
                if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) continue;
                CsmNamespaceDefinition nsDef = (CsmNamespaceDefinition)decl;
                this.extractFunctions(functions, nsDef.getDeclarations());
            }
        }

        private void extractMethods(Map<CsmScope, Collection<CsmFunction>> functions, CsmClass clazz) {
            Collection<CsmFunction> list = functions.get(clazz);
            if (list == null) {
                list = new LinkedHashSet<CsmFunction>();
            }
            for (CsmMember member : clazz.getMembers()) {
                CsmFunction fun;
                if (!CsmKindUtilities.isFunction((CsmObject)member) || (fun = this.handleFunction((CsmFunction)member)) == null || list.contains(fun)) continue;
                list.add(fun);
            }
            if (!list.isEmpty()) {
                functions.put((CsmScope)clazz, list);
            }
        }

        private CsmFunction handleFunction(CsmFunction fun) {
            fun = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)fun);
            CsmFunction out = null;
            boolean skip = false;
            if ("main".contentEquals(fun.getName())) {
                if ("main".contentEquals(fun.getQualifiedName())) {
                    skip = true;
                }
            } else if (CsmKindUtilities.isOperator((CsmObject)fun)) {
                skip = true;
            } else if (CsmKindUtilities.isMethod((CsmObject)fun)) {
                CsmMethod method = (CsmMethod)fun;
                if (CsmKindUtilities.isDestructor((CsmObject)method)) {
                    skip = true;
                } else if (method.isAbstract()) {
                    skip = true;
                } else if (!method.getVisibility().equals((Object)CsmVisibility.PUBLIC)) {
                    skip = true;
                }
            } else {
                CsmScope scope = fun.getScope();
                if (CsmKindUtilities.isFile((CsmObject)scope)) {
                    skip = true;
                }
            }
            if (!skip) {
                out = fun;
            }
            return out;
        }

        private List<ElementNode.Description> convert(CsmFile file, Map<CsmScope, Collection<CsmFunction>> functions) {
            ArrayList<ElementNode.Description> descrs = new ArrayList<ElementNode.Description>();
            for (Map.Entry<CsmScope, Collection<CsmFunction>> entry : functions.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                CsmObject container = (CsmObject)entry.getKey();
                List<ElementNode.Description> funs = this.convertFunctions2Descriptions(entry.getValue());
                if (CsmKindUtilities.isNamespace((Object)container) && ((CsmNamespace)container).isGlobal()) {
                    if (functions.size() == 1) {
                        container = file;
                    } else {
                        descrs.addAll(funs);
                        continue;
                    }
                }
                descrs.add(ElementNode.Description.create((CsmObject)container, funs, (boolean)false, (boolean)false));
            }
            return descrs;
        }

        private List<ElementNode.Description> convertFunctions2Descriptions(Collection<CsmFunction> funs) {
            ArrayList<ElementNode.Description> out = new ArrayList<ElementNode.Description>();
            for (CsmFunction csmFunction : funs) {
                out.add(ElementNode.Description.create((CsmObject)csmFunction, null, (boolean)true, (boolean)false));
            }
            return out;
        }
    }
}

