/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Backup
extends Tool {
    private void showUsage() {
        this.out.println("Creates a backup of a database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-file <filename>]  The target file name (default: backup.zip)\n" + " [-dir <dir>]        Source directory (default: .)\n" + " [-db <database>]    Source database name\n" + " [-quiet]            Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new Backup().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = "backup.zip";
        String string2 = ".";
        String string3 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.equals("-dir")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string4.equals("-db")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string4.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string4.equals("-file")) {
                string = stringArray[++i];
                continue;
            }
            if (string4.equals("-help") || string4.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string4);
            this.showUsage();
            return;
        }
        this.process(string, string2, string3, bl);
    }

    public static void execute(String string, String string2, String string3, boolean bl) throws SQLException {
        new Backup().process(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string, String string2, String string3, boolean bl) throws SQLException {
        ArrayList arrayList = FileLister.getDatabaseFiles(string2, string3, true);
        if (arrayList.size() == 0) {
            if (!bl) {
                this.printNoDatabaseFilesFound(string2, string3);
            }
            return;
        }
        if (FileUtils.exists(string = FileUtils.normalize(string))) {
            FileUtils.delete(string);
        }
        OutputStream outputStream = null;
        try {
            String string4;
            int n;
            outputStream = FileUtils.openFileOutputStream(string, false);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            String string5 = "";
            for (n = 0; n < arrayList.size(); ++n) {
                string4 = (String)arrayList.get(n);
                if (!string4.endsWith(".data.db")) continue;
                string5 = FileUtils.getParent(string4);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string4 = (String)arrayList.get(n);
                String string6 = FileUtils.getAbsolutePath(string4);
                if (!string6.startsWith(string5)) {
                    throw Message.getInternalError(string6 + " does not start with " + string5);
                }
                string6 = string6.substring(string5.length());
                string6 = BackupCommand.correctFileName(string6);
                ZipEntry zipEntry = new ZipEntry(string6);
                zipOutputStream.putNextEntry(zipEntry);
                InputStream inputStream = null;
                try {
                    inputStream = FileUtils.openFileInputStream(string4);
                    IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    IOUtils.closeSilently(inputStream);
                }
                zipOutputStream.closeEntry();
                if (bl) continue;
                this.out.println("Processed: " + string4);
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }
}

