/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class CollectionRemove {
    static final String SUPPRESS_WARNING_KEY = "element-type-mismatch";
    static final String WARN_FOR_CASTABLE_KEY = "warn-for-castable";
    static final boolean WARN_FOR_CASTABLE_DEFAULT = true;
    private static final Pattern SPLIT = Pattern.compile("(.+)\\.([^.]+)\\((.*)\\)");

    public static List<ErrorDescription> collectionRemove(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Collection.remove(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> collectionContains(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Collection.contains(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapRemove(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Map.remove(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapGet(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Map.get(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsKey(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Map.containsKey(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsValue(HintContext hintContext) {
        return CollectionRemove.run(hintContext, "java.util.Map.containsValue(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static List<ErrorDescription> run(HintContext hintContext, String string, String string2, int ... nArray) {
        DeclaredType declaredType;
        TypeMirror typeMirror;
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)hintContext.getPath().getLeaf();
        ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
        TreePath treePath = new TreePath(hintContext.getPath(), expressionTree);
        Element element = hintContext.getInfo().getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        ExecutableElement executableElement2 = CollectionRemove.resolveMethod(hintContext.getInfo(), string2);
        if (executableElement2 == null) {
            return null;
        }
        block0 : switch (expressionTree.getKind()) {
            case MEMBER_SELECT: {
                typeMirror = hintContext.getInfo().getTrees().getTypeMirror(new TreePath(treePath, ((MemberSelectTree)expressionTree).getExpression()));
                if (typeMirror != null && typeMirror.getKind() == TypeKind.TYPEVAR) {
                    typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                }
                if (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
                    declaredType = (DeclaredType)typeMirror;
                    break;
                }
                declaredType = null;
                break;
            }
            case IDENTIFIER: {
                for (Scope scope = hintContext.getInfo().getTrees().getScope(hintContext.getPath()); scope != null; scope = scope.getEnclosingScope()) {
                    for (ExecutableElement annotatedConstruct : ElementFilter.methodsIn(hintContext.getInfo().getElements().getAllMembers(scope.getEnclosingClass()))) {
                        if (annotatedConstruct != executableElement2 && !hintContext.getInfo().getElements().overrides(annotatedConstruct, executableElement2, typeElement)) continue;
                        declaredType = (DeclaredType)scope.getEnclosingClass().asType();
                        break block0;
                    }
                }
                declaredType = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (declaredType == null) {
            return null;
        }
        typeMirror = (ExecutableType)hintContext.getInfo().getTypes().asMemberOf(declaredType, executableElement2);
        assert (nArray.length % 2 == 0);
        for (int i = 0; i < nArray.length; i += 2) {
            String string3;
            void var16_22;
            TypeMirror typeMirror2;
            TypeMirror typeMirror22 = hintContext.getInfo().getTrees().getTypeMirror(new TreePath(hintContext.getPath(), methodInvocationTree.getArguments().get(nArray[i + 0])));
            TypeMirror typeMirror3 = org.netbeans.modules.java.hints.errors.Utilities.resolveCapturedType(hintContext.getInfo(), typeMirror.getParameterTypes().get(nArray[i + 1]));
            if (typeMirror3.getKind() == TypeKind.WILDCARD && (typeMirror2 = ((WildcardType)typeMirror3).getExtendsBound()) == null) {
                TypeMirror typeMirror4 = hintContext.getInfo().getElements().getTypeElement("java.lang.Object").asType();
            }
            if (hintContext.getInfo().getTypes().isAssignable(typeMirror22, (TypeMirror)var16_22)) continue;
            if (CollectionRemove.compatibleTypes(hintContext.getInfo(), typeMirror22, (TypeMirror)var16_22)) {
                string3 = "HINT_SuspiciousCall";
                if (!hintContext.getPreferences().getBoolean(WARN_FOR_CASTABLE_KEY, true)) {
                    continue;
                }
            } else {
                string3 = "HINT_SuspiciousCallIncompatibleTypes";
            }
            String string4 = string.substring(0, string.indexOf(40));
            String string5 = NbBundle.getMessage(CollectionRemove.class, (String)string3, (Object)string4, (Object)Utilities.getTypeName((TypeMirror)typeMirror22, (boolean)false), (Object)Utilities.getTypeName((TypeMirror)var16_22, (boolean)false));
            linkedList.add(ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string5, new Fix[0]));
        }
        return linkedList;
    }

    private static boolean compatibleTypes(CompilationInfo compilationInfo, TypeMirror typeMirror, TypeMirror typeMirror2) {
        typeMirror = compilationInfo.getTypes().erasure(typeMirror);
        typeMirror2 = compilationInfo.getTypes().erasure(typeMirror2);
        return compilationInfo.getTypeUtilities().isCastable(typeMirror, typeMirror2);
    }

    private static ExecutableElement resolveMethod(CompilationInfo compilationInfo, String string) {
        Matcher matcher = SPLIT.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string2);
        if (typeElement == null) {
            return null;
        }
        String[] stringArray = string4.split(",");
        LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
        TypeElement typeElement2 = (TypeElement)compilationInfo.getTopLevelElements().get(0);
        for (String string5 : stringArray) {
            linkedList.add(compilationInfo.getTreeUtilities().parseType(string5, typeElement2));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!string3.equals(executableElement.getSimpleName().toString()) || executableElement.getParameters().size() != linkedList.size()) continue;
            Iterator iterator = linkedList.iterator();
            boolean bl = true;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (compilationInfo.getTypes().isSameType(compilationInfo.getTypes().erasure(variableElement.asType()), (TypeMirror)iterator.next())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return executableElement;
        }
        return null;
    }

    public static final class CollectionRemoveCustomizerImpl
    extends OneCheckboxCustomizerProvider {
        public CollectionRemoveCustomizerImpl() {
            super(NbBundle.getMessage(CollectionRemove.class, (String)"LBL_CollectionRemoveCustomizer.warnForCastable"), NbBundle.getMessage(CollectionRemove.class, (String)"TP_CollectionRemoveCustomizer.warnForCastable"), CollectionRemove.WARN_FOR_CASTABLE_KEY, true);
        }
    }
}

