/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.DirectClosureBuffer;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class ClosurePool {
    private final List<MagazineHolder> partial = new LinkedList<MagazineHolder>();
    private final List<MagazineHolder> full = new LinkedList<MagazineHolder>();
    private final Set<Magazine> magazines = new HashSet<Magazine>();
    private final CallContext callContext;
    private static final Closure NULL_CLOSURE = new Closure(){

        public void invoke(Closure.Buffer buffer) {
        }
    };

    ClosurePool(CallContext callContext) {
        this.callContext = callContext;
    }

    synchronized void recycle(Magazine magazine) {
        magazine.recycle();
        if (!magazine.isEmpty()) {
            MagazineHolder h = new MagazineHolder(this, magazine);
            if (magazine.isFull()) {
                this.full.add(h);
            } else {
                this.partial.add(h);
            }
        } else {
            this.magazines.remove(magazine);
        }
    }

    private synchronized MagazineHolder getMagazineHolder() {
        if (!this.partial.isEmpty()) {
            return this.partial.get(0);
        }
        if (!this.full.isEmpty()) {
            MagazineHolder h = this.full.remove(0);
            this.partial.add(h);
            return h;
        }
        Magazine m = new Magazine(this.callContext);
        MagazineHolder h = new MagazineHolder(this, m);
        this.partial.add(h);
        this.magazines.add(m);
        return h;
    }

    public synchronized Closure.Handle newClosureHandle(Closure closure) {
        Magazine.Slot s = null;
        MagazineHolder h = null;
        do {
            if ((s = (h = this.getMagazineHolder()).magazine.get()) != null) continue;
            this.partial.remove(0);
        } while (s == null);
        s.proxy.closure = closure;
        return new Handle(s, h);
    }

    static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final CallContext callContext;
        volatile Closure closure = ClosurePool.access$100();

        private static final Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        Proxy(CallContext callContext) {
            this.callContext = callContext;
        }

        void invoke(long retvalAddress, long paramAddress) {
            this.closure.invoke(new DirectClosureBuffer(this.callContext, retvalAddress, paramAddress));
        }
    }

    private static final class MagazineHolder {
        private final WeakReference<ClosurePool> poolref;
        private final Magazine magazine;

        public MagazineHolder(ClosurePool pool, Magazine magazine) {
            this.poolref = new WeakReference<ClosurePool>(pool);
            this.magazine = magazine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                ClosurePool pool = (ClosurePool)this.poolref.get();
                if (pool != null) {
                    pool.recycle(this.magazine);
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class Magazine {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private final CallContext ctx;
        private final long magazine;
        private boolean nativeEmpty = false;
        private final List<Slot> free = new ArrayList<Slot>();
        private final List<Slot> all = new ArrayList<Slot>();

        Magazine(CallContext ctx) {
            this.ctx = ctx;
            this.magazine = Foreign.getInstance().newClosureMagazine(ctx.getAddress(), Proxy.METHOD);
        }

        Slot get() {
            if (!this.free.isEmpty()) {
                return this.free.remove(this.free.size() - 1);
            }
            return !this.nativeEmpty ? this.newSlot() : null;
        }

        private Slot newSlot() {
            Proxy proxy2 = new Proxy(this.ctx);
            long h = Foreign.getInstance().closureMagazineGet(this.magazine, proxy2);
            if (h == 0L) {
                this.nativeEmpty = true;
                return null;
            }
            Slot s = new Slot(h, proxy2);
            this.all.add(s);
            return s;
        }

        boolean isFull() {
            return this.free.size() == this.all.size();
        }

        boolean isEmpty() {
            return this.free.isEmpty();
        }

        void recycle() {
            this.free.clear();
            for (Slot s : this.all) {
                if (!s.autorelease) continue;
                s.proxy.closure = NULL_CLOSURE;
                this.free.add(s);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                boolean release = true;
                for (Slot s : this.all) {
                    if (s.autorelease) continue;
                    release = false;
                    break;
                }
                if (this.magazine != 0L && release) {
                    Foreign.getInstance().freeClosureMagazine(this.magazine);
                }
            }
            finally {
                super.finalize();
            }
        }

        static final class Slot {
            final long handle;
            final long cbAddress;
            final Proxy proxy;
            volatile boolean autorelease;

            public Slot(long handle, Proxy proxy2) {
                this.handle = handle;
                this.proxy = proxy2;
                this.autorelease = true;
                this.cbAddress = IO.getAddress(handle);
            }
        }
    }

    private static final class Handle
    implements Closure.Handle {
        private final MagazineHolder holder;
        private final Magazine.Slot slot;
        private volatile boolean disposed = false;

        Handle(Magazine.Slot slot, MagazineHolder holder) {
            this.slot = slot;
            this.holder = holder;
        }

        public long getAddress() {
            return this.slot.cbAddress;
        }

        public void setAutoRelease(boolean autorelease2) {
            this.slot.autorelease = autorelease2;
        }

        @Deprecated
        public void free() {
            this.dispose();
        }

        public synchronized void dispose() {
            if (this.disposed) {
                throw new IllegalStateException("closure already disposed");
            }
            this.disposed = true;
            this.slot.autorelease = true;
        }
    }
}

