/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.quicksearch.AbstractQuickSearchComboBar;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.modules.quicksearch.QuickSearchComboBar;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.netbeans.modules.quicksearch.SearchResultRender;
import org.netbeans.modules.quicksearch.recent.RecentSearches;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class QuickSearchPopup
extends JPanel
implements ListDataListener,
ActionListener,
TaskListener,
Runnable {
    private AbstractQuickSearchComboBar comboBar;
    private ResultsModel rModel;
    private Rectangle popupBounds = new Rectangle();
    private Timer updateTimer;
    private static final int COALESCE_TIME = 600;
    private String searchedText;
    private int catWidth;
    private int resultWidth;
    private Task evalTask;
    private static final RequestProcessor RP = new RequestProcessor(QuickSearchPopup.class);
    private JLabel hintLabel;
    private JSeparator hintSep;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JLabel noResultsLabel;
    private JLabel searchingLabel;
    private JSeparator searchingSep;
    private JPanel statusPanel;
    private boolean explicitlyInvoked = false;

    public QuickSearchPopup(AbstractQuickSearchComboBar comboBar) {
        this.comboBar = comboBar;
        this.initComponents();
        this.rModel = ResultsModel.getInstance();
        this.jList1.setModel(this.rModel);
        this.jList1.setCellRenderer(new SearchResultRender(this));
        this.rModel.addListDataListener(this);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.jList1.setBackground(QuickSearchComboBar.getResultBackground());
        }
        this.updateStatusPanel();
        this.setVisible(false);
    }

    void invoke() {
        ResultsModel.ItemResult result = (ResultsModel.ItemResult)this.jList1.getModel().getElementAt(this.jList1.getSelectedIndex());
        if (result != null) {
            RecentSearches.getDefault().add(result);
            result.getAction().run();
            this.clearModel();
        }
    }

    void selectNext() {
        int oldSel = this.jList1.getSelectedIndex();
        if (oldSel >= 0 && oldSel < this.jList1.getModel().getSize() - 1) {
            this.jList1.setSelectedIndex(oldSel + 1);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.setVisible(true);
        }
    }

    void selectPrev() {
        int oldSel = this.jList1.getSelectedIndex();
        if (oldSel > 0) {
            this.jList1.setSelectedIndex(oldSel - 1);
        }
        if (this.jList1.getModel().getSize() > 0) {
            this.setVisible(true);
        }
    }

    public JList getList() {
        return this.jList1;
    }

    public void clearModel() {
        this.rModel.setContent(null);
    }

    public void maybeEvaluate(String text) {
        this.searchedText = text;
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(600, this);
        }
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.start();
        } else {
            this.updateTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateTimer.stop();
        if (this.comboBar.getCommand().isFocusOwner()) {
            if (this.evalTask != null) {
                this.evalTask.removeTaskListener((TaskListener)this);
            }
            this.evalTask = CommandEvaluator.evaluate(this.searchedText, this.rModel);
            this.evalTask.addTaskListener((TaskListener)this);
            RP.post((Runnable)this.evalTask);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.statusPanel = new JPanel();
        this.searchingSep = new JSeparator();
        this.searchingLabel = new JLabel();
        this.noResultsLabel = new JLabel();
        this.hintSep = new JSeparator();
        this.hintLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getPopupBorderColor()));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setViewportBorder(null);
        this.jList1.setFocusable(false);
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                QuickSearchPopup.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                QuickSearchPopup.this.jList1MouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.statusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.searchingSep, gridBagConstraints);
        this.searchingLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.searchingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.statusPanel.add((Component)this.searchingLabel, gridBagConstraints);
        this.noResultsLabel.setForeground(Color.red);
        this.noResultsLabel.setHorizontalAlignment(0);
        this.noResultsLabel.setText(NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.noResultsLabel.text"));
        this.noResultsLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.noResultsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.statusPanel.add((Component)this.hintSep, gridBagConstraints);
        this.hintLabel.setBackground(QuickSearchComboBar.getResultBackground());
        this.hintLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.statusPanel.add((Component)this.hintLabel, gridBagConstraints);
        this.add((Component)this.statusPanel, "Last");
    }

    private void jList1MouseMoved(MouseEvent evt) {
        Point loc = evt.getPoint();
        int index = this.jList1.locationToIndex(loc);
        if (index == -1) {
            return;
        }
        Rectangle rect = this.jList1.getCellBounds(index, index);
        if (rect != null && rect.contains(loc)) {
            this.jList1.setSelectedIndex(index);
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.comboBar.invokeSelectedItem();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updatePopup();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updatePopup();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updatePopup();
    }

    public void updatePopup() {
        int modelSize = this.rModel.getSize();
        JLayeredPane lPane = JLayeredPane.getLayeredPaneAbove(this.comboBar);
        if (lPane == null) {
            return;
        }
        if (!this.isDisplayable()) {
            lPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER + 1));
        }
        boolean statusVisible = this.updateStatusPanel();
        this.computePopupBounds(this.popupBounds, lPane, modelSize);
        this.setBounds(this.popupBounds);
        if ((modelSize > 0 || statusVisible) && this.comboBar.getCommand().isFocusOwner()) {
            if (modelSize > 0 && !this.isVisible()) {
                this.jList1.setSelectedIndex(0);
            }
            if (this.jList1.getSelectedIndex() >= modelSize) {
                this.jList1.setSelectedIndex(modelSize - 1);
            }
            if (this.explicitlyInvoked || !this.searchedText.isEmpty()) {
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
        }
        this.explicitlyInvoked = false;
        this.revalidate();
    }

    void explicitlyInvoked() {
        this.explicitlyInvoked = true;
    }

    public int getCategoryWidth() {
        if (this.catWidth <= 0) {
            this.catWidth = QuickSearchPopup.computeWidth(this.jList1, 20, 30);
        }
        return this.catWidth;
    }

    public int getResultWidth() {
        if (this.resultWidth <= 0) {
            this.resultWidth = QuickSearchPopup.computeWidth(this.jList1, 42, 50);
        }
        return this.resultWidth;
    }

    public void taskFinished(Task task) {
        this.evalTask = null;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updatePopup();
    }

    private void computePopupBounds(Rectangle result, JLayeredPane lPane, int modelSize) {
        Dimension cSize = this.comboBar.getSize();
        int width = this.getCategoryWidth() + this.getResultWidth() + 3;
        Point location = new Point(cSize.width - width - 1, this.comboBar.getBottomLineY() - 1);
        if (SwingUtilities.getWindowAncestor(this.comboBar) != null) {
            location = SwingUtilities.convertPoint(this.comboBar, location, lPane);
        }
        result.setLocation(location);
        this.jList1.setFixedCellHeight(15);
        this.jList1.setFixedCellHeight(-1);
        this.jList1.setVisibleRowCount(modelSize);
        Dimension preferredSize = this.jList1.getPreferredSize();
        preferredSize.width = width;
        preferredSize.height += this.statusPanel.getPreferredSize().height + 3;
        result.setSize(preferredSize);
    }

    private static int computeWidth(JComponent comp, int maxCharCount, int percent) {
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        int charW = fm.charWidth('X');
        int result = charW * maxCharCount;
        Window w = SwingUtilities.windowForComponent(comp);
        if (w != null) {
            result = Math.min(result, w.getWidth() * percent / 100);
        }
        return result;
    }

    private boolean updateStatusPanel() {
        boolean shouldBeVisible = false;
        boolean isInProgress = this.evalTask != null;
        this.searchingSep.setVisible(isInProgress);
        this.searchingLabel.setVisible(isInProgress);
        if (this.comboBar instanceof QuickSearchComboBar) {
            if (isInProgress) {
                ((QuickSearchComboBar)this.comboBar).startProgressAnimation();
            } else {
                ((QuickSearchComboBar)this.comboBar).stopProgressAnimation();
            }
        }
        shouldBeVisible = shouldBeVisible || isInProgress;
        boolean searchedNotEmpty = this.searchedText != null && this.searchedText.trim().length() > 0;
        boolean areNoResults = this.rModel.getSize() <= 0 && searchedNotEmpty && !isInProgress;
        this.noResultsLabel.setVisible(areNoResults);
        this.comboBar.setNoResults(areNoResults);
        shouldBeVisible = shouldBeVisible || areNoResults;
        this.hintLabel.setText(this.getHintText());
        boolean isNarrowed = CommandEvaluator.getEvalCat() != null && searchedNotEmpty;
        this.hintSep.setVisible(isNarrowed);
        this.hintLabel.setVisible(isNarrowed);
        shouldBeVisible = shouldBeVisible || isNarrowed;
        return shouldBeVisible;
    }

    private String getHintText() {
        ProviderModel.Category evalCat = CommandEvaluator.getEvalCat();
        if (evalCat == null) {
            return null;
        }
        return NbBundle.getMessage(QuickSearchPopup.class, (String)"QuickSearchPopup.hintLabel.text", (Object)evalCat.getDisplayName(), (Object)SearchResultRender.getKeyStrokeAsText(this.comboBar.getKeyStroke()));
    }
}

