/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class DefaultProjectActionHandler
implements ProjectActionHandler,
ExecutionListener {
    private ProjectActionEvent pae;
    private volatile Future<Integer> executorTask;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private static final boolean RUN_REMOTE_IN_OUTPUT_WINDOW = true;

    @Override
    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
    }

    private String getArguments() {
        return this.pae.getProfile().getArgsFlat();
    }

    private String[] getEnvironment() {
        return this.pae.getProfile().getEnvironment().getenv();
    }

    @Override
    public void execute(final InputOutput io) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    DefaultProjectActionHandler.this._execute(io);
                }
            });
        } else {
            this._execute(io);
        }
    }

    private void _execute(InputOutput io) {
        String path;
        String commands;
        String csdirs;
        ProjectActionEvent.Type actionType = this.pae.getType();
        if (actionType != ProjectActionEvent.PredefinedType.RUN && actionType != ProjectActionEvent.PredefinedType.BUILD && actionType != ProjectActionEvent.PredefinedType.CLEAN && actionType != ProjectActionEvent.PredefinedType.BUILD_TESTS && actionType != ProjectActionEvent.PredefinedType.TEST) assert (false);
        String runDirectory = this.pae.getProfile().getRunDirectory();
        MakeConfiguration conf = this.pae.getConfiguration();
        PlatformInfo pi = conf.getPlatformInfo();
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        String exe = this.pae.getExecutable();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.pae.getProfile().getArgsArray()));
        Map<String, String> env = this.pae.getProfile().getEnvironment().getenvAsMap();
        boolean showInput = actionType == ProjectActionEvent.PredefinedType.RUN;
        boolean unbuffer = false;
        boolean runInInternalTerminal = false;
        CompilerSet cs = null;
        int consoleType = this.pae.getProfile().getConsoleType().getValue();
        if (actionType == ProjectActionEvent.PredefinedType.RUN) {
            boolean bl = runInInternalTerminal = consoleType == 3;
            if (this.pae.getProfile().getTerminalType() == null || this.pae.getProfile().getTerminalPath() == null) {
                String errmsg = Utilities.isMac() ? DefaultProjectActionHandler.getString("Err_NoTermFoundMacOSX") : DefaultProjectActionHandler.getString("Err_NoTermFound");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errmsg));
                consoleType = 2;
            }
            if (!conf.getDevelopmentHost().isLocalhost() && !runInInternalTerminal) {
                consoleType = 2;
            }
            if (consoleType == 2) {
                if (pi.getPlatform() == 3) {
                    exe = CndPathUtilitities.naturalize((String)exe);
                } else if (conf.getDevelopmentHost().isLocalhost()) {
                    exe = CndPathUtilitities.toAbsolutePath((String)runDirectory, (String)exe);
                }
                unbuffer = true;
            } else if (!runInInternalTerminal) {
                showInput = false;
                if (consoleType == 0) {
                    consoleType = RunProfile.getDefaultConsoleType();
                }
            }
            cs = conf.getCompilerSet().getCompilerSet();
            if (cs != null) {
                csdirs = cs.getDirectory();
                commands = cs.getCompilerFlavor().getCommandFolder(conf.getDevelopmentHost().getBuildPlatform());
                if (commands != null && commands.length() > 0) {
                    csdirs = csdirs + pi.pathSeparator() + commands;
                }
                path = (path = env.get(pi.getPathName())) == null ? pi.getPathAsString() + pi.pathSeparator() + csdirs : path + pi.pathSeparator() + csdirs;
                env.put(pi.getPathName(), path);
            }
        } else {
            cs = conf.getCompilerSet().getCompilerSet();
            csdirs = cs.getDirectory();
            commands = cs.getCompilerFlavor().getCommandFolder(conf.getDevelopmentHost().getBuildPlatform());
            if (commands != null && commands.length() > 0) {
                csdirs = csdirs + pi.pathSeparator() + commands;
            }
            path = (path = env.get(pi.getPathName())) == null ? csdirs + pi.pathSeparator() + pi.getPathAsString() : csdirs + pi.pathSeparator() + path;
            env.put(pi.getPathName(), path);
            if (conf.isQmakeConfiguration()) {
                String qmakePath = cs.getTool((ToolKind)PredefinedToolKind.QMakeTool).getPath();
                qmakePath = CppUtils.normalizeDriveLetter(cs, qmakePath.replace('\\', '/'));
                args.add("QMAKE=" + CndPathUtilitities.escapeOddCharacters((String)qmakePath));
            }
        }
        CompilerLineConvertor converter = null;
        if (actionType == ProjectActionEvent.PredefinedType.BUILD) {
            converter = new CompilerLineConvertor(conf.getCompilerSet().getCompilerSet(), execEnv, FileUtil.toFileObject((File)new File(runDirectory)));
        }
        env.put("SPRO_EXPAND_ERRORS", "");
        String workingDirectory = DefaultProjectActionHandler.convertToRemoteIfNeeded(execEnv, runDirectory);
        if (workingDirectory == null) {
            // empty if block
        }
        ProcessChangeListener processChangeListener = new ProcessChangeListener(this, null, (LineConvertor)converter, io, this.pae.getActionName());
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(workingDirectory).unbufferOutput(unbuffer).setExecutable(exe).setArguments(args.toArray(new String[args.size()])).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(env);
        if ((actionType == ProjectActionEvent.PredefinedType.RUN || actionType == ProjectActionEvent.PredefinedType.DEBUG) && ServerList.get((ExecutionEnvironment)execEnv).getX11Forwarding() && !env.containsKey("DISPLAY")) {
            npb.setX11Forwarding(true);
        }
        if (actionType == ProjectActionEvent.PredefinedType.RUN && consoleType == 1) {
            String termPath = this.pae.getProfile().getTerminalPath();
            CndUtils.assertNotNull((Object)termPath, (String)"null terminal path");
            if (termPath != null) {
                String termBaseName = CndPathUtilitities.getBaseName((String)termPath);
                if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(termBaseName)) {
                    npb.useExternalTerminal(ExternalTerminalProvider.getTerminal((ExecutionEnvironment)execEnv, (String)termBaseName));
                }
            }
        }
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(showInput).inputOutput(io).outLineBased(!unbuffer).showProgress(true).postExecution((Runnable)processChangeListener).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        if (actionType == ProjectActionEvent.PredefinedType.BUILD || actionType == ProjectActionEvent.PredefinedType.CLEAN) {
            descr.noReset(true);
            if (cs != null) {
                descr.charset(cs.getEncoding());
            }
        }
        if (actionType == ProjectActionEvent.PredefinedType.RUN && cs != null) {
            descr.charset(cs.getEncoding());
        }
        NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)this.pae.getActionName());
        this.executorTask = es.run();
    }

    protected static String convertToRemoteIfNeeded(ExecutionEnvironment execEnv, String localDir) {
        if (!DefaultProjectActionHandler.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)execEnv).getRemotePath(localDir, false);
        }
        return localDir;
    }

    protected static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (CancellationException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addExecutionListener(ExecutionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public void cancel() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Future et = DefaultProjectActionHandler.this.executorTask;
                if (et != null) {
                    et.cancel(true);
                }
            }
        });
    }

    public void executionStarted(int pid) {
        for (ExecutionListener l : this.listeners) {
            l.executionStarted(pid);
        }
    }

    public void executionFinished(int rc) {
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(rc);
        }
    }

    private static String getString(String s) {
        return NbBundle.getBundle(DefaultProjectActionHandler.class).getString(s);
    }

    protected static String getString(String key, String ... a1) {
        return NbBundle.getMessage(DefaultProjectActionHandler.class, (String)key, (Object[])a1);
    }

    private static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private static final boolean showHeader = Boolean.getBoolean("cnd.execution.showheader");
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;
        private final InputOutput tab;
        private final String actionName;
        private long startTimeMillis;
        private Runnable postRunnable;

        public ProcessChangeListener(ExecutionListener listener, Writer outputListener, LineConvertor lineConvertor, InputOutput tab, String actionName) {
            this.listener = listener;
            this.outputListener = outputListener;
            this.lineConvertor = lineConvertor;
            this.tab = tab;
            this.actionName = actionName;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            final NativeProcess process = (NativeProcess)event.getSource();
            switch (event.state) {
                case INITIAL: {
                    break;
                }
                case STARTING: {
                    break;
                }
                case RUNNING: {
                    this.startTimeMillis = System.currentTimeMillis();
                    if (showHeader) assert (false);
                    if (this.listener == null) break;
                    this.listener.executionStarted(event.pid);
                    break;
                }
                case CANCELLED: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder res = new StringBuilder();
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString("TERMINATED"), ProcessChangeListener.this.actionName.toUpperCase()));
                            res.append(" (");
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                            res.append(')');
                            ProcessChangeListener.this.tab.getErr().printf("\n\r%s\n\r", new Object[]{res.toString()});
                            ProcessChangeListener.this.closeIO();
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(-1);
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(DefaultProjectActionHandler.getString("MSG_TERMINATED"), ProcessChangeListener.this.actionName));
                        }
                    };
                    break;
                }
                case ERROR: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder res = new StringBuilder();
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString("FAILED"), ProcessChangeListener.this.actionName.toUpperCase()));
                            res.append(" (");
                            if (process.exitValue() != 0) {
                                res.append(MessageFormat.format(DefaultProjectActionHandler.getString("EXIT_VALUE"), process.exitValue()));
                                res.append(' ');
                            }
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                            res.append(')');
                            ProcessChangeListener.this.tab.getErr().printf("\n\r%s\n\r", new Object[]{res.toString()});
                            ProcessChangeListener.this.closeIO();
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(-1);
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(DefaultProjectActionHandler.getString("MSG_FAILED"), ProcessChangeListener.this.actionName));
                        }
                    };
                    break;
                }
                case FINISHED: {
                    this.closeOutputListener();
                    this.postRunnable = new Runnable(){

                        @Override
                        public void run() {
                            int rc = process.exitValue();
                            StringBuilder res = new StringBuilder();
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString(rc == 0 ? "SUCCESSFUL" : "FAILED"), ProcessChangeListener.this.actionName.toUpperCase()));
                            res.append(" (");
                            if (rc != 0) {
                                res.append(MessageFormat.format(DefaultProjectActionHandler.getString("EXIT_VALUE"), process.exitValue()));
                                res.append(' ');
                            }
                            res.append(MessageFormat.format(DefaultProjectActionHandler.getString("TOTAL_TIME"), ProcessChangeListener.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis)));
                            res.append(')');
                            OutputWriter pw = rc == 0 ? ProcessChangeListener.this.tab.getOut() : ProcessChangeListener.this.tab.getErr();
                            pw.printf("\n\r%s\n\r", res.toString());
                            ProcessChangeListener.this.closeIO();
                            if (ProcessChangeListener.this.listener != null) {
                                ProcessChangeListener.this.listener.executionFinished(process.exitValue());
                            }
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(DefaultProjectActionHandler.getString(rc == 0 ? "MSG_SUCCESSFUL" : "MSG_FAILED"), ProcessChangeListener.this.actionName));
                        }
                    };
                }
            }
        }

        @Override
        public void run() {
            if (this.postRunnable != null) {
                this.postRunnable.run();
            }
        }

        private void closeIO() {
        }

        public LineConvertor newLineConvertor() {
            return new LineConvertor(){

                public List<ConvertedLine> convert(String line) {
                    return ProcessChangeListener.this.convert(line);
                }
            };
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.outputListener = null;
            }
        }

        private synchronized List<ConvertedLine> convert(String line) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(line);
                    this.outputListener.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(line);
            }
            return null;
        }

        private static String formatTime(long millis) {
            StringBuilder res = new StringBuilder();
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                res.append(" ").append(hours).append(DefaultProjectActionHandler.getString("HOUR"));
            }
            if (minutes > 0L) {
                res.append(" ").append(minutes - hours * 60L).append(DefaultProjectActionHandler.getString("MINUTE"));
            }
            if (seconds > 0L) {
                res.append(" ").append(seconds - minutes * 60L).append(DefaultProjectActionHandler.getString("SECOND"));
            } else {
                res.append(" ").append(millis - seconds * 1000L).append(DefaultProjectActionHandler.getString("MILLISECOND"));
            }
            return res.toString();
        }
    }
}

