/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product.components;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.components.ProductConfigurationLogic;
import org.netbeans.installer.product.components.StatusInterface;
import org.netbeans.installer.product.dependencies.Conflict;
import org.netbeans.installer.product.dependencies.InstallAfter;
import org.netbeans.installer.product.dependencies.Requirement;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.InstallationException;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.exceptions.UninstallationException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.ApplicationDescriptor;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.DependencyType;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.ExtendedUri;
import org.netbeans.installer.utils.helper.FileEntry;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.helper.NbiClassLoader;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.RemovalMode;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Text;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.UnixNativeUtils;
import org.netbeans.installer.wizard.components.WizardComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Product
extends RegistryNode
implements StatusInterface {
    private Version version;
    private List<Platform> supportedPlatforms = new ArrayList<Platform>();
    private Status initialStatus;
    private Status currentStatus;
    private boolean reinstallationForced;
    private List<ExtendedUri> logicUris = new ArrayList<ExtendedUri>();
    private List<ExtendedUri> dataUris = new ArrayList<ExtendedUri>();
    private List<String> features;
    private long requiredDiskSpace;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private NbiClassLoader classLoader;
    private ProductConfigurationLogic configurationLogic;
    private Throwable installationError;
    private List<Throwable> installationWarnings;
    private Throwable uninstallationError;
    private List<Throwable> uninstallationWarnings;
    private FilesList installedFiles;
    private InstallationPhase installationPhase;
    public static final String INSTALLATION_LOCATION_PROPERTY = "installation.location";
    public static final String INSTALLED_FILES_LIST_FILE_NAME = "installed-files.xml.gz";
    public static final String MANIFEST_LOGIC_CLASS = "Configuration-Logic-Class";
    public static final String INFO_PLIST_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">\n<plist version=\"0.9\">\n  <dict>\n    \n    <key>CFBundleName</key>\n    <string>{0}</string>\n    \n    <key>CFBundleVersion</key>\n    <string>{1}</string>\n    \n    <key>CFBundleExecutable</key>\n    <string>{3}</string>\n    \n    <key>CFBundlePackageType</key>\n    <string>APPL</string>\n    \n    <key>CFBundleShortVersionString</key>\n    <string>{2}</string>\n    \n    <key>CFBundleSignature</key>\n    <string>????</string>\n    \n    <key>CFBundleInfoDictionaryVersion</key>\n    <string>6.0</string>\n    \n    <key>CFBundleIconFile</key>\n    <string>{4}</string>\n  </dict>\n</plist>\n";
    private static final String APPLICATION_LOCATION_PROPERTY = "application.location";
    private static final String VERSION_TAG_NAME = "version";
    private static final String PLATFORMS_TAG_NAME = "platforms";
    private static final String STATUS_TAG_NAME = "status";
    private static final String FEATURES_TAG_NAME = "features";
    private static final String CONFIGURATION_LOGIC_TAG_NAME = "configuration-logic";
    private static final String INSTALLATION_DATA_TAG_NAME = "installation-data";
    private static final String DEPENDENCIES_TAG_NAME = "dependencies";
    private static final String PRODUCT_TAG_NAME = "product";
    private static final String SYSTEM_REQUIREMENTS_TAG_NAME = "system-requirements";
    private static final String DISK_SPACE_TAG_NAME = "disk-space";
    private static final String ERROR_CANNOT_INITIALIZE_PRODUCT_KEY = "P.error.cannot.initialize.product";
    private static final String ERROR_CANNOT_LOAD_LOGIC_KEY = "P.error.cannot.load.logic";
    private static final String ERROR_INSTALLATION_LOCATION_NOT_SET_KEY = "P.error.installdir.not.set";
    private static final String ERROR_INSTALLATION_LOCATION_SET_EMPTY_KEY = "P.error.installdir.set.empty";
    private static final String ERROR_CANNOT_CREATE_PRODUCT_CACHE_DIR_KEY = "P.error.cannot.create.cache.dir";
    private static final String ERROR_CACHE_NOT_DIRECTORY_KEY = "P.error.local.cache.not.dir";
    private static final String ERROR_CANNOT_LOAD_PRODUCT_KEY = "P.error.cannot.load.product";
    private static final String ERROR_LOGIC_NOT_YET_DOWNLOADED_KEY = "P.error.logic.not.yet.downloaded";
    private static final String ERROR_DATA_NOT_CACHED_KEY = "P.error.installation.data.not.cached";
    private static final String ERROR_CANNOT_EXTRACT_DATA_KEY = "P.error.cannot.extract.data";
    private static final String ERROR_CANNOT_SAVE_FILES_LIST_KEY = "P.error.cannot.save.files.list";
    private static final String ERROR_CANNOT_GET_WIZARD_COMPONENTS_KEY = "P.error.cannot.get.wizard.components";
    private static final String ERROR_CANNOT_WRAP_FOR_MACOS_KEY = "P.error.cannot.wrap.for.macos";
    private static final String ERROR_CANNOT_GET_FILES_LIST_KEY = "P.error.cannot.get.files.list";
    private static final String ERROR_CANNOT_DELETE_FILES_LIST_KEY = "P.error.cannot.delete.files.list";
    private static final String ERROR_CANNOT_DELETE_FILE_KEY = "P.error.cannot.delete.file";
    private static final String ERROR_CANNOT_REMOVE_FROM_SYSTEM_KEY = "P.error.cannot.remove.from.system";
    private static final String ERROR_NOT_ENOUGH_SPACE_KEY = "P.error.not.enough.space";
    private static final String ERROR_CANNOT_CLEAR_DATA_CACHE_KEY = "P.error.cannot.clear.cache";
    private static final String ERROR_SYSTEM_INTEGRATION_FAILER_KEY = "P.error.system.integartion.failed";
    private static final String MESSAGE_INSTALLATION_STRING = ResourceUtils.getString(Product.class, "P.message.installation");
    private static final String MESSAGE_UNINSTALLATION_STRING = ResourceUtils.getString(Product.class, "P.message.uninstallation");
    private static final String MESSAGE_CONFIGURATION_STRING = ResourceUtils.getString(Product.class, "P.message.configuration");
    private static final String MESSAGE_UNCONFIGURATION_STRING = ResourceUtils.getString(Product.class, "P.message.unconfiguration");
    private static final String MESSAGE_LEGAL_ARTIFACTS_STRING = ResourceUtils.getString(Product.class, "P.message.legal.artifacts");
    private static final String MESSAGE_RUN_LOGIC_STRING = ResourceUtils.getString(Product.class, "P.message.run.logic");
    private static final String MESSAGE_SYSTEM_REGISTRATION_STRING = ResourceUtils.getString(Product.class, "P.message.system.registration");
    private static final String MESSAGE_SAVE_INSTALL_FILES_LIST_STRING = ResourceUtils.getString(Product.class, "P.message.save.installation.files.list");
    private static final String MESSAGE_DELETE_STRING = ResourceUtils.getString(Product.class, "P.message.delete");

    public void install(Progress progress) throws InstallationException {
        LogManager.logIndent("Start installation of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
        CompositeProgress totalProgress = new CompositeProgress();
        CompositeProgress unjarProgress = new CompositeProgress();
        Progress logicProgress = new Progress();
        this.installationPhase = InstallationPhase.INITIALIZATION;
        try {
            this.getLogic();
        }
        catch (InitializationException e) {
            throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_INITIALIZE_PRODUCT_KEY, this.getDisplayName()), e);
        }
        totalProgress.addChild(unjarProgress, 100 - this.configurationLogic.getLogicPercentage());
        totalProgress.addChild(logicProgress, this.configurationLogic.getLogicPercentage());
        totalProgress.synchronizeTo(progress);
        totalProgress.synchronizeDetails(true);
        if (this.getInstallationLocation() == null) {
            throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_INSTALLATION_LOCATION_NOT_SET_KEY, this.getDisplayName()));
        }
        if (this.getInstallationLocation().equals(new File(""))) {
            throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_INSTALLATION_LOCATION_SET_EMPTY_KEY, this.getDisplayName()));
        }
        File cache = this.getLocalCache();
        if (!cache.exists()) {
            if (!cache.mkdirs()) {
                throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_CREATE_PRODUCT_CACHE_DIR_KEY, cache, this.getDisplayName()));
            }
        } else if (!cache.isDirectory()) {
            throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CACHE_NOT_DIRECTORY_KEY, cache, this.getDisplayName()));
        }
        this.installedFiles = new FilesList();
        if (progress.isCanceled()) {
            return;
        }
        this.installationPhase = InstallationPhase.EXTRACTION;
        totalProgress.setTitle(StringUtils.format(MESSAGE_INSTALLATION_STRING, this.getDisplayName()));
        File contentsDir = new File(this.getInstallationLocation(), "Contents");
        File macosDir = new File(contentsDir, "MacOS");
        File resourcesDir = new File(contentsDir, "Resources");
        File infoplist = new File(contentsDir, "Info.plist");
        File ds_store = new File(this.getInstallationLocation().getParentFile(), ".DS_Store");
        if (SystemUtils.isMacOS() && this.configurationLogic.wrapForMacOs()) {
            this.setProperty(APPLICATION_LOCATION_PROPERTY, this.getInstallationLocation().getAbsolutePath());
            this.setInstallationLocation(new File(resourcesDir, this.getInstallationLocation().getName().replaceAll("\\.app$", "")));
            UnixNativeUtils utils = (UnixNativeUtils)SystemUtils.getNativeUtils();
            try {
                this.installedFiles.add(FileUtils.mkdirs(contentsDir));
                this.installedFiles.add(FileUtils.mkdirs(resourcesDir));
                this.installedFiles.add(FileUtils.mkdirs(macosDir));
                String executableName = "executable";
                this.installedFiles.add(utils.createSymLink(new File(macosDir, "executable"), new File(this.getInstallationLocation(), this.configurationLogic.getExecutable())));
                String iconName = "icon.icns";
                if (this.configurationLogic.getIcon() != null) {
                    this.installedFiles.add(utils.createSymLink(new File(resourcesDir, "icon.icns"), new File(this.getInstallationLocation(), this.configurationLogic.getIcon())));
                }
                this.installedFiles.add(FileUtils.writeFile(infoplist, StringUtils.format(INFO_PLIST_STUB, this.getDisplayName(), this.getVersion().toString(), this.getVersion().toMinor(), "executable", "icon.icns")));
            }
            catch (IOException e) {
                throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_WRAP_FOR_MACOS_KEY), e);
            }
        }
        if (progress.isCanceled()) {
            return;
        }
        if (this.dataUris.size() > 0) {
            LogManager.log("... extracting files from the data archives");
            unjarProgress.setPercentage(100 % this.dataUris.size());
            unjarProgress.synchronizeDetails(true);
            for (ExtendedUri uri : this.dataUris) {
                Progress currentProgress = new Progress();
                unjarProgress.addChild(currentProgress, 100 / this.dataUris.size());
                URI dataUri = uri.getLocal();
                if (dataUri == null) {
                    throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_DATA_NOT_CACHED_KEY, this.getDisplayName()));
                }
                File dataFile = new File(uri.getLocal());
                if (!dataFile.exists()) {
                    throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_DATA_NOT_CACHED_KEY, this.getDisplayName()));
                }
                try {
                    this.installedFiles.add(FileUtils.unjar(dataFile, this.getInstallationLocation(), currentProgress));
                }
                catch (IOException e) {
                    if (e.getMessage().equals("Not enough space")) {
                        throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_NOT_ENOUGH_SPACE_KEY), e);
                    }
                    throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_EXTRACT_DATA_KEY, this.getDisplayName()), e);
                }
                catch (XMLException e) {
                    throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_EXTRACT_DATA_KEY, this.getDisplayName()), e);
                }
                try {
                    FileProxy.getInstance().deleteFile(uri);
                }
                catch (IOException e) {
                    throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_CLEAR_DATA_CACHE_KEY, dataFile), e);
                }
                if (!progress.isCanceled()) continue;
                break;
            }
        } else {
            LogManager.log("... no data archives assigned to this product");
            unjarProgress.setPercentage(100);
        }
        LogManager.log("... saving legal artifacts if required");
        progress.setDetail(StringUtils.format(MESSAGE_LEGAL_ARTIFACTS_STRING, new Object[0]));
        try {
            this.saveLegalArtifacts();
        }
        catch (IOException e) {
            this.addInstallationWarning(e);
        }
        if (progress.isCanceled()) {
            return;
        }
        this.installationPhase = InstallationPhase.CUSTOM_LOGIC;
        totalProgress.setTitle(StringUtils.format(MESSAGE_CONFIGURATION_STRING, this.getDisplayName()));
        progress.setDetail(StringUtils.format(MESSAGE_RUN_LOGIC_STRING, new Object[0]));
        LogManager.log("... running installation logic");
        this.configurationLogic.install(logicProgress);
        logicProgress.setPercentage(100);
        progress.setDetail("");
        if (progress.isCanceled()) {
            return;
        }
        this.installationPhase = InstallationPhase.FINALIZATION;
        LogManager.log("... register in system, create uninstaller, etc");
        if (this.configurationLogic.registerInSystem()) {
            try {
                progress.setDetail(StringUtils.format(MESSAGE_SYSTEM_REGISTRATION_STRING, new Object[0]));
                this.installedFiles.add(SystemUtils.addComponentToSystemInstallManager(this.getApplicationDescriptor()));
            }
            catch (NativeException e) {
                throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_SYSTEM_INTEGRATION_FAILER_KEY, this.getDisplayName()), e);
            }
            catch (IOException e) {
                throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_SYSTEM_INTEGRATION_FAILER_KEY, this.getDisplayName()), e);
            }
        }
        LogManager.log("... save installation files list");
        progress.setDetail(StringUtils.format(MESSAGE_SAVE_INSTALL_FILES_LIST_STRING, new Object[0]));
        try {
            this.installedFiles.saveXmlGz(this.getInstalledFilesList());
        }
        catch (XMLException e) {
            throw new InstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_SAVE_FILES_LIST_KEY), e);
        }
        this.installationPhase = InstallationPhase.COMPLETE;
        progress.setPercentage(100);
        progress.setDetail("");
        this.setStatus(Status.INSTALLED);
        LogManager.logUnindent("... finished installation of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
    }

    public void rollback(Progress progress) throws UninstallationException {
        CompositeProgress totalProgress = new CompositeProgress();
        Progress logicProgress = new Progress();
        Progress eraseProgress = new Progress();
        LogManager.logIndent("Start rollback of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
        try {
            this.getLogic();
        }
        catch (InitializationException e) {
            throw new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_INITIALIZE_PRODUCT_KEY, this.getDisplayName()), e);
        }
        int logicChunk = (int)((float)progress.getPercentage() * ((float)this.configurationLogic.getLogicPercentage() / 100.0f));
        int eraseChunk = (int)((double)progress.getPercentage() * (1.0 - (double)((float)this.configurationLogic.getLogicPercentage() / 100.0f)));
        totalProgress.setPercentage(100 - logicChunk - eraseChunk);
        totalProgress.addChild(logicProgress, logicChunk);
        totalProgress.addChild(eraseProgress, eraseChunk);
        totalProgress.synchronizeDetails(true);
        totalProgress.reverseSynchronizeTo(progress);
        switch (this.installationPhase) {
            case COMPLETE: 
            case FINALIZATION: {
                LogManager.log("... deleting installed files files");
                try {
                    FileUtils.deleteFile(this.getInstalledFilesList());
                }
                catch (IOException e) {
                    ErrorManager.notifyWarning(ResourceUtils.getString(Product.class, ERROR_CANNOT_DELETE_FILES_LIST_KEY), e);
                }
                if (this.configurationLogic.registerInSystem()) {
                    LogManager.log("... removing system integration");
                    try {
                        SystemUtils.removeComponentFromSystemInstallManager(this.getApplicationDescriptor());
                    }
                    catch (NativeException e) {
                        ErrorManager.notifyWarning(ResourceUtils.getString(Product.class, ERROR_CANNOT_REMOVE_FROM_SYSTEM_KEY, this.getDisplayName()), e);
                    }
                }
            }
            case CUSTOM_LOGIC: {
                LogManager.log("... running uninstallation logic");
                this.configurationLogic.uninstall(logicProgress);
            }
            case EXTRACTION: {
                logicProgress.setPercentage(100);
                LogManager.log("... deleting installed files");
                int total = this.installedFiles.getSize();
                int current = 0;
                for (FileEntry entry : this.installedFiles) {
                    File file = entry.getFile();
                    eraseProgress.setDetail(StringUtils.format(MESSAGE_DELETE_STRING, file));
                    eraseProgress.setPercentage(100 * ++current / total);
                    try {
                        FileUtils.deleteFile(file);
                    }
                    catch (IOException e) {
                        ErrorManager.notifyWarning(ResourceUtils.getString(Product.class, ERROR_CANNOT_DELETE_FILE_KEY), e);
                    }
                }
            }
            case INITIALIZATION: {
                eraseProgress.setPercentage(100);
            }
        }
        this.setStatus(Status.NOT_INSTALLED);
        LogManager.logUnindent("... finished rollbacking of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
    }

    public void uninstall(Progress progress) throws UninstallationException {
        LogManager.logIndent("Start uninstallation of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
        CompositeProgress totalProgress = new CompositeProgress();
        Progress logicProgress = new Progress();
        Progress eraseProgress = new Progress();
        try {
            this.getLogic();
        }
        catch (InitializationException e) {
            throw new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_INITIALIZE_PRODUCT_KEY, this.getDisplayName()), e);
        }
        totalProgress.addChild(logicProgress, this.configurationLogic.getLogicPercentage());
        totalProgress.addChild(eraseProgress, 100 - this.configurationLogic.getLogicPercentage());
        totalProgress.synchronizeTo(progress);
        totalProgress.synchronizeDetails(true);
        try {
            this.installedFiles = new FilesList().loadXmlGz(this.getInstalledFilesList());
        }
        catch (XMLException e) {
            throw new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_GET_FILES_LIST_KEY), e);
        }
        progress.setTitle(StringUtils.format(MESSAGE_UNCONFIGURATION_STRING, this.getDisplayName()));
        LogManager.log("... running uninstallation logic");
        this.configurationLogic.uninstall(logicProgress);
        logicProgress.setPercentage(100);
        progress.setDetail("");
        progress.setTitle(StringUtils.format(MESSAGE_UNINSTALLATION_STRING, this.getDisplayName()));
        LogManager.log("... removing installation files");
        if (this.configurationLogic.getRemovalMode() == RemovalMode.ALL) {
            try {
                File startPoint = this.getInstallationLocation();
                if (SystemUtils.isMacOS() && this.configurationLogic.wrapForMacOs()) {
                    startPoint = startPoint.getParentFile().getParentFile().getParentFile();
                }
                FileUtils.deleteFile(startPoint, true, eraseProgress);
            }
            catch (IOException e) {
                this.addUninstallationWarning(new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_DELETE_FILE_KEY), e));
            }
        } else {
            try {
                FileUtils.deleteFiles(this.installedFiles, eraseProgress);
            }
            catch (IOException e) {
                this.addUninstallationWarning(new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_DELETE_FILE_KEY), e));
            }
        }
        LogManager.log("... removing the system integration");
        if (this.configurationLogic.registerInSystem()) {
            try {
                SystemUtils.removeComponentFromSystemInstallManager(this.getApplicationDescriptor());
            }
            catch (NativeException e) {
                this.addUninstallationWarning(new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_REMOVE_FROM_SYSTEM_KEY, this.getDisplayName()), e));
            }
        }
        LogManager.log("... removing installation files list");
        progress.setDetail("");
        try {
            FileUtils.deleteFile(this.getInstalledFilesList());
        }
        catch (IOException e) {
            this.addUninstallationWarning(new UninstallationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_DELETE_FILES_LIST_KEY), e));
        }
        progress.setPercentage(100);
        this.setStatus(Status.NOT_INSTALLED);
        LogManager.logUnindent("...finished uninstallation of " + this.getDisplayName() + "(" + this.getUid() + "/" + this.getVersion() + ")");
    }

    public List<ExtendedUri> getLogicUris() {
        return this.logicUris;
    }

    public void downloadLogic(Progress progress) throws DownloadException {
        CompositeProgress overallProgress = new CompositeProgress();
        int percentageChunk = 100 / this.logicUris.size();
        int percentageLeak = 100 % this.logicUris.size();
        overallProgress.setPercentage(percentageLeak);
        overallProgress.synchronizeTo(progress);
        overallProgress.synchronizeDetails(true);
        for (ExtendedUri uri : this.logicUris) {
            Progress currentProgress = new Progress();
            overallProgress.addChild(currentProgress, percentageChunk);
            File cache = FileProxy.getInstance().getFile(uri.getRemote(), currentProgress);
            uri.setLocal(cache.toURI());
        }
    }

    public boolean isLogicDownloaded() {
        for (ExtendedUri uri : this.logicUris) {
            if (uri.getLocal() != null) continue;
            return false;
        }
        return true;
    }

    public ProductConfigurationLogic getLogic() throws InitializationException {
        if (this.configurationLogic != null) {
            return this.configurationLogic;
        }
        if (!this.isLogicDownloaded()) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_LOGIC_NOT_YET_DOWNLOADED_KEY, this.getDisplayName()));
        }
        try {
            ExtendedUri uri;
            String classname = null;
            Iterator<ExtendedUri> i$ = this.logicUris.iterator();
            while (i$.hasNext() && (classname = FileUtils.getJarAttribute(new File((uri = i$.next()).getLocal()), MANIFEST_LOGIC_CLASS)) == null) {
            }
            this.classLoader = new NbiClassLoader(this.logicUris);
            this.configurationLogic = (ProductConfigurationLogic)this.classLoader.loadClass(classname).newInstance();
            this.configurationLogic.setProduct(this);
            return this.configurationLogic;
        }
        catch (IOException e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
        catch (InstantiationException e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
        catch (NoClassDefFoundError e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_LOGIC_KEY, this.getDisplayName()), e);
        }
    }

    public List<ExtendedUri> getDataUris() {
        return this.dataUris;
    }

    public void downloadData(Progress progress) throws DownloadException {
        CompositeProgress overallProgress = new CompositeProgress();
        if (this.dataUris.size() > 0) {
            int percentageChunk = 100 / this.dataUris.size();
            int percentageLeak = 100 % this.dataUris.size();
            overallProgress.setPercentage(percentageLeak);
            overallProgress.synchronizeTo(progress);
            overallProgress.synchronizeDetails(true);
            for (ExtendedUri uri : this.dataUris) {
                Progress currentProgress = new Progress();
                overallProgress.addChild(currentProgress, percentageChunk);
                File cache = FileProxy.getInstance().getFile(uri.getRemote(), currentProgress);
                uri.setLocal(cache.toURI());
                if (!progress.isCanceled()) continue;
                return;
            }
        } else {
            overallProgress.setPercentage(100);
            overallProgress.synchronizeTo(progress);
        }
    }

    public boolean isDataDownloaded() {
        for (ExtendedUri uri : this.dataUris) {
            if (uri.getLocal() != null) continue;
            return false;
        }
        return true;
    }

    public List<WizardComponent> getWizardComponents() {
        try {
            return this.getLogic().getWizardComponents();
        }
        catch (InitializationException e) {
            ErrorManager.notifyError(ResourceUtils.getString(Product.class, ERROR_CANNOT_GET_WIZARD_COMPONENTS_KEY), e);
            return null;
        }
    }

    @Override
    public Status getStatus() {
        return this.currentStatus;
    }

    @Override
    public void setStatus(Status status) {
        if (this.initialStatus == null) {
            this.initialStatus = status;
        }
        this.currentStatus = status;
        if (this.initialStatus == Status.INSTALLED && this.currentStatus == Status.TO_BE_INSTALLED) {
            this.reinstallationForced = true;
        }
    }

    public boolean hasStatusChanged() {
        return this.currentStatus != this.initialStatus;
    }

    public DetailedStatus getDetailedStatus() {
        if (this.getStatus() == Status.INSTALLED) {
            if (this.getUninstallationError() != null) {
                return DetailedStatus.FAILED_TO_UNINSTALL;
            }
            if ((this.hasStatusChanged() || this.reinstallationForced) && this.getInstallationWarnings() != null) {
                return DetailedStatus.INSTALLED_WITH_WARNINGS;
            }
            if (this.hasStatusChanged() || this.reinstallationForced) {
                return DetailedStatus.INSTALLED_SUCCESSFULLY;
            }
        }
        if (this.getStatus() == Status.NOT_INSTALLED) {
            if (this.getInstallationError() != null) {
                return DetailedStatus.FAILED_TO_INSTALL;
            }
            if (this.hasStatusChanged() && this.getUninstallationWarnings() != null) {
                return DetailedStatus.UNINSTALLED_WITH_WARNINGS;
            }
            if (this.hasStatusChanged()) {
                return DetailedStatus.UNINSTALLED_SUCCESSFULLY;
            }
        }
        return null;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Deprecated
    public List<Dependency> getDependencies(DependencyType ... types) {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            classes[i] = this.toDependencyClass(types[i]);
        }
        return this.getDependencies(classes);
    }

    @Deprecated
    private Class<? extends Dependency> toDependencyClass(DependencyType type) {
        switch (type) {
            case REQUIREMENT: {
                return Requirement.class;
            }
            case CONFLICT: {
                return Conflict.class;
            }
            case INSTALL_AFTER: {
                return InstallAfter.class;
            }
        }
        return null;
    }

    public List<Dependency> getDependencies(Class ... dependencyClasses) {
        ArrayList<Dependency> filtered = new ArrayList<Dependency>();
        block0: for (Dependency dependency : this.dependencies) {
            for (Class clazz : dependencyClasses) {
                if (!clazz.isInstance(dependency)) continue;
                filtered.add(dependency);
                continue block0;
            }
        }
        return filtered;
    }

    public boolean satisfies(Dependency dependency) {
        return dependency.satisfies(this);
    }

    public List<Dependency> getDependencyByUid(String dependentUid) {
        ArrayList<Dependency> filtered = new ArrayList<Dependency>();
        for (Dependency dependency : this.dependencies) {
            if (!dependency.getUid().equals(dependentUid)) continue;
            filtered.add(dependency);
        }
        return filtered;
    }

    public long getRequiredDiskSpace() {
        return this.requiredDiskSpace;
    }

    public Throwable getInstallationError() {
        return this.installationError;
    }

    public void setInstallationError(Throwable error) {
        this.installationError = error;
    }

    public List<Throwable> getInstallationWarnings() {
        return this.installationWarnings;
    }

    public void addInstallationWarning(Throwable warning) {
        if (this.installationWarnings == null) {
            this.installationWarnings = new ArrayList<Throwable>();
        }
        this.installationWarnings.add(warning);
    }

    public Throwable getUninstallationError() {
        return this.uninstallationError;
    }

    public void setUninstallationError(Throwable error) {
        this.uninstallationError = error;
    }

    public List<Throwable> getUninstallationWarnings() {
        return this.uninstallationWarnings;
    }

    public void addUninstallationWarning(Throwable warning) {
        if (this.uninstallationWarnings == null) {
            this.uninstallationWarnings = new ArrayList<Throwable>();
        }
        this.uninstallationWarnings.add(warning);
    }

    @Override
    protected String getTagName() {
        return PRODUCT_TAG_NAME;
    }

    @Override
    protected Element saveToDom(Element element) throws FinalizationException {
        super.saveToDom(element);
        Document document = element.getOwnerDocument();
        element.setAttribute(VERSION_TAG_NAME, this.version.toString());
        element.setAttribute(PLATFORMS_TAG_NAME, StringUtils.asString(this.supportedPlatforms, " "));
        element.setAttribute(STATUS_TAG_NAME, this.currentStatus.toString());
        element.setAttribute(FEATURES_TAG_NAME, StringUtils.asString(this.features, " "));
        element.appendChild(XMLUtils.saveExtendedUrisList(this.logicUris, document.createElement(CONFIGURATION_LOGIC_TAG_NAME)));
        element.appendChild(XMLUtils.saveExtendedUrisList(this.dataUris, document.createElement(INSTALLATION_DATA_TAG_NAME)));
        Element systemRequirementsElement = document.createElement(SYSTEM_REQUIREMENTS_TAG_NAME);
        Element diskSpaceElement = document.createElement(DISK_SPACE_TAG_NAME);
        diskSpaceElement.setTextContent(Long.toString(this.requiredDiskSpace));
        systemRequirementsElement.appendChild(diskSpaceElement);
        element.appendChild(systemRequirementsElement);
        if (this.dependencies.size() > 0) {
            element.appendChild(XMLUtils.saveDependencies(this.dependencies, document.createElement(DEPENDENCIES_TAG_NAME)));
        }
        return element;
    }

    @Override
    public Product loadFromDom(Element element) throws InitializationException {
        super.loadFromDom(element);
        try {
            this.version = Version.getVersion(element.getAttribute(VERSION_TAG_NAME));
            this.supportedPlatforms = StringUtils.parsePlatforms(element.getAttribute(PLATFORMS_TAG_NAME));
            this.currentStatus = this.initialStatus = StringUtils.parseStatus(element.getAttribute(STATUS_TAG_NAME));
            this.features = StringUtils.asList(element.getAttribute(FEATURES_TAG_NAME), " ");
            this.logicUris.addAll(XMLUtils.parseExtendedUrisList(XMLUtils.getChild(element, CONFIGURATION_LOGIC_TAG_NAME)));
            this.dataUris.addAll(XMLUtils.parseExtendedUrisList(XMLUtils.getChild(element, INSTALLATION_DATA_TAG_NAME)));
            this.requiredDiskSpace = Long.parseLong(XMLUtils.getChild(element, "system-requirements/disk-space").getTextContent());
            Element child = XMLUtils.getChild(element, DEPENDENCIES_TAG_NAME);
            if (child != null) {
                this.dependencies.addAll(XMLUtils.parseDependencies(child));
            }
        }
        catch (ParseException e) {
            throw new InitializationException(ResourceUtils.getString(Product.class, ERROR_CANNOT_LOAD_PRODUCT_KEY, this.getDisplayName()), e);
        }
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<Platform> getPlatforms() {
        return this.supportedPlatforms;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public File getInstallationLocation() {
        String path = SystemUtils.resolveString(this.getProperty(INSTALLATION_LOCATION_PROPERTY), this.getClassLoader());
        return path == null ? null : new File(path);
    }

    public void setInstallationLocation(File location) {
        this.setProperty(INSTALLATION_LOCATION_PROPERTY, location.getAbsolutePath());
    }

    public File getLocalCache() {
        return new File(Registry.getInstance().getLocalProductCache(), this.uid + File.separator + this.version);
    }

    public FilesList getInstalledFiles() {
        return this.installedFiles;
    }

    public File getInstalledFilesList() {
        return new File(this.getLocalCache(), INSTALLED_FILES_LIST_FILE_NAME);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public long getDownloadSize() {
        long downloadSize = 0L;
        for (ExtendedUri uri : this.logicUris) {
            downloadSize += uri.getSize();
        }
        for (ExtendedUri uri : this.dataUris) {
            downloadSize += uri.getSize();
        }
        return downloadSize;
    }

    private ApplicationDescriptor getApplicationDescriptor() {
        String applicationLocation;
        String key = "nbi-" + this.uid + "-" + this.version;
        String displayName = this.configurationLogic.getSystemDisplayName();
        String icon = this.configurationLogic.getIcon() != null ? new File(this.getInstallationLocation(), this.configurationLogic.getIcon()).getAbsolutePath() : null;
        String installLocation = this.getInstallationLocation().getAbsolutePath();
        if (SystemUtils.isMacOS() && this.configurationLogic.wrapForMacOs() && (applicationLocation = this.getProperty(APPLICATION_LOCATION_PROPERTY)) != null) {
            installLocation = applicationLocation;
        }
        String[] modifyCommand = new String[]{"--target", this.uid, this.version.toString()};
        String[] uninstallCommand = new String[]{"--target", this.uid, this.version.toString(), "--force-uninstall"};
        if (this.configurationLogic.allowModifyMode()) {
            return new ApplicationDescriptor(key, displayName, icon, installLocation, uninstallCommand, modifyCommand, this.configurationLogic.getAdditionalSystemIntegrationInfo());
        }
        return new ApplicationDescriptor(key, displayName, icon, installLocation, uninstallCommand, null, this.configurationLogic.getAdditionalSystemIntegrationInfo());
    }

    public boolean isCompatibleWith(Platform platform) {
        for (Platform compatiblePlatform : this.supportedPlatforms) {
            if (!compatiblePlatform.isCompatibleWith(platform)) continue;
            return true;
        }
        return false;
    }

    private void saveLegalArtifacts() throws IOException {
        Text distributionReadme;
        Text readme;
        Text releaseNotes;
        Text thirdPartyLicense;
        Map<String, Text> thirdPartyLicenses;
        if (!this.configurationLogic.requireLegalArtifactSaving()) {
            return;
        }
        Text license = this.configurationLogic.getLicense();
        if (license != null) {
            File file = new File(this.getInstallationLocation(), "LICENSE-" + this.uid + license.getContentType().getExtension());
            FileUtils.writeFile(file, license.getText());
            this.installedFiles.add(file);
        }
        if ((thirdPartyLicenses = this.configurationLogic.getThirdPartyLicenses()) != null) {
            File file = new File(this.getInstallationLocation(), "THIRDPARTYLICENSES-" + this.uid + ".txt");
            for (String title : thirdPartyLicenses.keySet()) {
                FileUtils.appendFile(file, "%% The following software may be included in this product: " + title + ";\n" + "Use of any of this software is governed by the terms of the license below:\n\n");
                FileUtils.appendFile(file, thirdPartyLicenses.get(title).getText() + "\n\n");
            }
            this.installedFiles.add(file);
        }
        if ((thirdPartyLicense = this.configurationLogic.getThirdPartyLicense()) != null) {
            File file = new File(this.getInstallationLocation(), "THIRDPARTYLICENSE-" + this.uid + thirdPartyLicense.getContentType().getExtension());
            FileUtils.writeFile(file, thirdPartyLicense.getText());
            this.installedFiles.add(file);
        }
        if ((releaseNotes = this.configurationLogic.getReleaseNotes()) != null) {
            File file = new File(this.getInstallationLocation(), "RELEASENOTES-" + this.uid + releaseNotes.getContentType().getExtension());
            FileUtils.writeFile(file, releaseNotes.getText());
            this.installedFiles.add(file);
        }
        if ((readme = this.configurationLogic.getReadme()) != null) {
            File file = new File(this.getInstallationLocation(), "README-" + this.uid + readme.getContentType().getExtension());
            FileUtils.writeFile(file, readme.getText());
            this.installedFiles.add(file);
        }
        if ((distributionReadme = this.configurationLogic.getDistributionReadme()) != null) {
            File file = new File(this.getInstallationLocation(), "DISTRIBUTION-" + this.uid + distributionReadme.getContentType().getExtension());
            FileUtils.writeFile(file, distributionReadme.getText());
            this.installedFiles.add(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InstallationPhase {
        INITIALIZATION,
        EXTRACTION,
        CUSTOM_LOGIC,
        FINALIZATION,
        COMPLETE;

    }
}

