/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.cleaner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.system.cleaner.SystemPropertyOnExitCleanerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessOnExitCleanerHandler
extends SystemPropertyOnExitCleanerHandler {
    protected List<String> runningCommand;
    private String cleanerFileName;
    private static final String DELETING_FILES_LIST = "deleteNbiFiles";

    protected ProcessOnExitCleanerHandler(String cleanerFileName) {
        this.cleanerFileName = cleanerFileName;
    }

    protected File getCleanerFile() throws IOException {
        String name = this.cleanerFileName;
        int idx = name.lastIndexOf(".");
        String ext = "";
        if (idx > 0) {
            ext = name.substring(idx);
            name = name.substring(0, idx);
        }
        return File.createTempFile(name, ext, SystemUtils.getTempDirectory());
    }

    protected File createTempFileWithFilesList() throws IOException {
        return File.createTempFile(DELETING_FILES_LIST, null, SystemUtils.getTempDirectory());
    }

    protected abstract void writeCleaningFileList(File var1, List<String> var2) throws IOException;

    protected abstract void writeCleaner(File var1) throws IOException;

    public void init() {
        List<String> fileList = this.getFilesList();
        if (fileList.size() > 0) {
            try {
                ArrayList<String> paths = new ArrayList<String>();
                for (String s : fileList) {
                    if (paths.contains(s)) continue;
                    paths.add(s);
                }
                Collections.sort(paths, Collections.reverseOrder());
                File listFile = this.createTempFileWithFilesList();
                this.writeCleaningFileList(listFile, paths);
                File cleanerFile = this.getCleanerFile();
                this.writeCleaner(cleanerFile);
                SystemUtils.correctFilesPermissions(cleanerFile);
                this.runningCommand = new ArrayList<String>();
                this.runningCommand.add(cleanerFile.getCanonicalPath());
                this.runningCommand.add(listFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        this.init();
        if (this.runningCommand != null) {
            try {
                ProcessBuilder builder = new ProcessBuilder(this.runningCommand);
                builder.directory(SystemUtils.getUserHomeDirectory());
                builder.start();
                LogManager.log(4, "... cleaning process has been started ");
            }
            catch (IOException ex) {
                LogManager.log(ex);
            }
        }
    }
}

