/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ScrollPaneOperator
extends ContainerOperator
implements Timeoutable,
Outputable {
    private static int X_POINT_RECT_SIZE = 6;
    private static int Y_POINT_RECT_SIZE = 4;
    private Timeouts timeouts;
    private TestOut output;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());

    public ScrollPaneOperator(ScrollPane b) {
        super(b);
    }

    public ScrollPaneOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((ScrollPane)cont.waitSubComponent(new ScrollPaneFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ScrollPaneOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ScrollPaneOperator(ContainerOperator cont, int index) {
        this((ScrollPane)ScrollPaneOperator.waitComponent(cont, (ComponentChooser)new ScrollPaneFinder(), index));
        this.copyEnvironment(cont);
    }

    public ScrollPaneOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static ScrollPane findScrollPane(Container cont, ComponentChooser chooser, int index) {
        return (ScrollPane)ScrollPaneOperator.findComponent(cont, new ScrollPaneFinder(chooser), index);
    }

    public static ScrollPane findScrollPane(Container cont, ComponentChooser chooser) {
        return ScrollPaneOperator.findScrollPane(cont, chooser, 0);
    }

    public static ScrollPane findScrollPane(Container cont, int index) {
        return ScrollPaneOperator.findScrollPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th ScrollPane instance"), index);
    }

    public static ScrollPane findScrollPane(Container cont) {
        return ScrollPaneOperator.findScrollPane(cont, 0);
    }

    public static ScrollPane findScrollPaneUnder(Component comp, ComponentChooser chooser) {
        return (ScrollPane)ScrollPaneOperator.findContainerUnder(comp, new ScrollPaneFinder(chooser));
    }

    public static ScrollPane findScrollPaneUnder(Component comp) {
        return ScrollPaneOperator.findScrollPaneUnder(comp, new ScrollPaneFinder());
    }

    public static ScrollPane waitScrollPane(Container cont, ComponentChooser chooser, int index) {
        return (ScrollPane)ScrollPaneOperator.waitComponent(cont, (ComponentChooser)new ScrollPaneFinder(chooser), index);
    }

    public static ScrollPane waitScrollPane(Container cont, ComponentChooser chooser) {
        return ScrollPaneOperator.waitScrollPane(cont, chooser, 0);
    }

    public static ScrollPane waitScrollPane(Container cont, int index) {
        return ScrollPaneOperator.waitScrollPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th ScrollPane instance"), index);
    }

    public static ScrollPane waitScrollPane(Container cont) {
        return ScrollPaneOperator.waitScrollPane(cont, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), anotherOperator.getProperties());
    }

    public void setValues(int x, int y) {
        this.getHAdjustable().setValue(x);
        this.getVAdjustable().setValue(y);
    }

    public void scrollTo(final ScrollAdjuster adj) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollPaneOperator.this.driver.scroll(ScrollPaneOperator.this, adj);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToHorizontalValue(int value) {
        this.output.printTrace("Scroll ScrollPane to " + Integer.toString(value) + " horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Integer.toString(value) + " horizontal value");
        this.scrollTo(new ValueScrollAdjuster(value, 0, this.getHAdjustable()));
    }

    public void scrollToHorizontalValue(double proportionalValue) {
        this.output.printTrace("Scroll ScrollPane to " + Double.toString(proportionalValue) + " proportional horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Double.toString(proportionalValue) + " proportional horizontal value");
        Adjustable adj = this.getHAdjustable();
        this.scrollTo(new ValueScrollAdjuster((int)((double)adj.getMinimum() + (double)(adj.getMaximum() - adj.getVisibleAmount() - adj.getMinimum()) * proportionalValue), 1, this.getVAdjustable()));
    }

    public void scrollToVerticalValue(int value) {
        this.output.printTrace("Scroll ScrollPane to " + Integer.toString(value) + " vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Integer.toString(value) + " vertical value");
        this.scrollTo(new ValueScrollAdjuster(value, 1, this.getVAdjustable()));
    }

    public void scrollToVerticalValue(double proportionalValue) {
        this.output.printTrace("Scroll ScrollPane to " + Double.toString(proportionalValue) + " proportional vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to " + Double.toString(proportionalValue) + " proportional vertical value");
        Adjustable adj = this.getVAdjustable();
        this.scrollTo(new ValueScrollAdjuster((int)((double)adj.getMinimum() + (double)(adj.getMaximum() - adj.getVisibleAmount() - adj.getMinimum()) * proportionalValue), 1, this.getVAdjustable()));
    }

    public void scrollToValues(int valueX, int valueY) {
        this.scrollToVerticalValue(valueX);
        this.scrollToHorizontalValue(valueX);
    }

    public void scrollToValues(double proportionalValueX, double proportionalValueY) {
        this.scrollToVerticalValue(proportionalValueX);
        this.scrollToHorizontalValue(proportionalValueY);
    }

    public void scrollToTop() {
        this.output.printTrace("Scroll ScrollPane to top\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to top");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollPaneOperator.this.driver.scrollToMinimum(ScrollPaneOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToBottom() {
        this.output.printTrace("Scroll ScrollPane to bottom\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to bottom");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollPaneOperator.this.driver.scrollToMaximum(ScrollPaneOperator.this, 1);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToLeft() {
        this.output.printTrace("Scroll ScrollPane to left\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to left");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollPaneOperator.this.driver.scrollToMinimum(ScrollPaneOperator.this, 0);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToRight() {
        this.output.printTrace("Scroll ScrollPane to right\n" + this.toStringSource());
        this.output.printGolden("Scroll ScrollPane to right");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                ScrollPaneOperator.this.driver.scrollToMaximum(ScrollPaneOperator.this, 0);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("ScrollbarOperator.WholeScrollTimeout"));
    }

    public void scrollToComponentRectangle(Component comp, int x, int y, int width, int height) {
        this.scrollTo(new ComponentRectChecker(comp, x, y, width, height, 0));
        this.scrollTo(new ComponentRectChecker(comp, x, y, width, height, 1));
    }

    public void scrollToComponentPoint(Component comp, int x, int y) {
        this.scrollToComponentRectangle(comp, x - X_POINT_RECT_SIZE, y - Y_POINT_RECT_SIZE, 2 * X_POINT_RECT_SIZE, 2 * Y_POINT_RECT_SIZE);
    }

    public void scrollToComponent(final Component comp) {
        String componentToString = (String)this.runMapping(new Operator.MapAction("comp.toString()"){

            public Object map() {
                return comp.toString();
            }
        });
        this.output.printTrace("Scroll ScrollPane " + this.toStringSource() + "\nto component " + componentToString);
        this.output.printGolden("Scroll ScrollPane to " + comp.getClass().getName() + " component.");
        this.scrollToComponentRectangle(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public boolean checkInside(Component comp, int x, int y, int width, int height) {
        Point toPoint = SwingUtilities.convertPoint(comp, x, y, this.getSource());
        if (toPoint.x < this.getHAdjustable().getValue()) {
            return false;
        }
        if (comp.getWidth() > this.getSource().getWidth() ? toPoint.x > 0 : toPoint.x + comp.getWidth() > this.getHAdjustable().getValue() + this.getSource().getWidth()) {
            return false;
        }
        if (toPoint.y < this.getVAdjustable().getValue()) {
            return false;
        }
        return !(comp.getHeight() > this.getSource().getHeight() ? toPoint.y > 0 : toPoint.y + comp.getHeight() > this.getVAdjustable().getValue() + this.getSource().getHeight());
    }

    public boolean checkInside(Component comp) {
        return this.checkInside(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public boolean isScrollbarVisible(int orientation) {
        if (orientation == 0) {
            return this.getViewportSize().getHeight() < (double)(this.getHeight() - this.getHScrollbarHeight());
        }
        if (orientation == 1) {
            return this.getViewportSize().getWidth() < (double)(this.getWidth() - this.getVScrollbarWidth());
        }
        return false;
    }

    public Adjustable getHAdjustable() {
        return (Adjustable)this.runMapping(new Operator.MapAction("getHAdjustable"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getHAdjustable();
            }
        });
    }

    public int getHScrollbarHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getHScrollbarHeight"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getHScrollbarHeight();
            }
        });
    }

    public Point getScrollPosition() {
        return (Point)this.runMapping(new Operator.MapAction("getScrollPosition"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getScrollPosition();
            }
        });
    }

    public int getScrollbarDisplayPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getScrollbarDisplayPolicy"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getScrollbarDisplayPolicy();
            }
        });
    }

    public Adjustable getVAdjustable() {
        return (Adjustable)this.runMapping(new Operator.MapAction("getVAdjustable"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getVAdjustable();
            }
        });
    }

    public int getVScrollbarWidth() {
        return this.runMapping(new Operator.MapIntegerAction("getVScrollbarWidth"){

            public int map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getVScrollbarWidth();
            }
        });
    }

    public Dimension getViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getViewportSize"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).getViewportSize();
            }
        });
    }

    public String paramString() {
        return (String)this.runMapping(new Operator.MapAction("paramString"){

            public Object map() {
                return ((ScrollPane)ScrollPaneOperator.this.getSource()).paramString();
            }
        });
    }

    public void setScrollPosition(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setScrollPosition"){

            public void map() {
                ((ScrollPane)ScrollPaneOperator.this.getSource()).setScrollPosition(i, i1);
            }
        });
    }

    public void setScrollPosition(final Point point) {
        this.runMapping(new Operator.MapVoidAction("setScrollPosition"){

            public void map() {
                ((ScrollPane)ScrollPaneOperator.this.getSource()).setScrollPosition(point);
            }
        });
    }

    static {
        try {
            Class.forName("org.netbeans.jemmy.operators.ScrollbarOperator");
        }
        catch (Exception e) {
            throw new JemmyException("Exception", e);
        }
    }

    public static class ScrollPaneFinder
    extends Operator.Finder {
        public ScrollPaneFinder(ComponentChooser sf) {
            super(ScrollPane.class, sf);
        }

        public ScrollPaneFinder() {
            super(ScrollPane.class);
        }
    }

    private class ComponentRectChecker
    implements ScrollAdjuster {
        Component comp;
        int x;
        int y;
        int width;
        int height;
        int orientation;

        public ComponentRectChecker(Component comp, int x, int y, int width, int height, int orientation) {
            this.comp = comp;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.orientation = orientation;
        }

        public int getScrollDirection() {
            int cl;
            int sp = this.orientation == 0 ? (int)ScrollPaneOperator.this.getScrollPosition().getX() : (int)ScrollPaneOperator.this.getScrollPosition().getY();
            Point pnt = SwingUtilities.convertPoint(this.comp, this.x, this.y, ((Container)ScrollPaneOperator.this.getSource()).getComponents()[0]);
            int cp = this.orientation == 0 ? pnt.x : pnt.y;
            int sl = this.orientation == 0 ? (int)ScrollPaneOperator.this.getViewportSize().getWidth() : (int)ScrollPaneOperator.this.getViewportSize().getHeight();
            int n = cl = this.orientation == 0 ? this.width : this.height;
            if (cp <= sp) {
                return -1;
            }
            if (cp + cl > sp + sl && cp > sp) {
                return 1;
            }
            return 0;
        }

        public int getScrollOrientation() {
            return this.orientation;
        }

        public String getDescription() {
            return "";
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;
        int orientation;
        Adjustable adj;

        public ValueScrollAdjuster(int value, int orientation, Adjustable adj) {
            this.value = value;
            this.orientation = orientation;
            this.adj = adj;
        }

        public int getScrollDirection() {
            if (this.adj.getValue() == this.value) {
                return 0;
            }
            return this.adj.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return this.orientation;
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }
}

