/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class EditorContext {
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    public static final String FIELD_BREAKPOINT_ANNOTATION_TYPE = "FieldBreakpoint";
    public static final String CLASS_BREAKPOINT_ANNOTATION_TYPE = "ClassBreakpoint";
    public static final String DISABLED_FIELD_BREAKPOINT_ANNOTATION_TYPE = "DisabledFieldBreakpoint";
    public static final String METHOD_BREAKPOINT_ANNOTATION_TYPE = "MethodBreakpoint";
    public static final String DISABLED_METHOD_BREAKPOINT_ANNOTATION_TYPE = "DisabledMethodBreakpoint";
    public static final String DISABLED_CLASS_BREAKPOINT_ANNOTATION_TYPE = "DisabledClassBreakpoint";
    public static final String CURRENT_LINE_ANNOTATION_TYPE = "CurrentPC";
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE = "CallSite";
    public static final String CURRENT_LAST_OPERATION_ANNOTATION_TYPE = "LastOperation";
    public static final String CURRENT_OUT_OPERATION_ANNOTATION_TYPE = "StepOutOperation";
    public static final String CURRENT_EXPRESSION_SECONDARY_LINE_ANNOTATION_TYPE = "CurrentExpression";
    public static final String CURRENT_EXPRESSION_CURRENT_LINE_ANNOTATION_TYPE = "CurrentExpressionLine";
    public static final String OTHER_THREAD_ANNOTATION_TYPE = "OtherThread";
    public static final String PROP_LINE_NUMBER = "lineNumber";

    public abstract boolean showSource(String var1, int var2, Object var3);

    public abstract void createTimeStamp(Object var1);

    public abstract void disposeTimeStamp(Object var1);

    public abstract void updateTimeStamp(Object var1, String var2);

    public abstract Object annotate(String var1, int var2, String var3, Object var4);

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp, JPDAThread thread) {
        return null;
    }

    public Object annotate(String url, int startPosition, int endPosition, String annotationType, Object timeStamp) {
        return null;
    }

    public abstract int getLineNumber(Object var1, Object var2);

    public abstract void removeAnnotation(Object var1);

    public abstract int getCurrentLineNumber();

    public abstract String getCurrentClassName();

    public abstract String getCurrentURL();

    public abstract String getCurrentMethodName();

    public abstract String getCurrentFieldName();

    public abstract String getSelectedIdentifier();

    public abstract String getSelectedMethodName();

    public abstract int getFieldLineNumber(String var1, String var2, String var3);

    public int getMethodLineNumber(String url, String className, String methodName, String methodSignature) {
        return -1;
    }

    public String[] getCurrentMethodDeclaration() {
        return null;
    }

    public abstract String getClassName(String var1, int var2);

    public abstract String[] getImports(String var1);

    protected final Operation createMethodOperation(Position startPosition, Position endPosition, Position methodStartPosition, Position methodEndPosition, String methodName, String methodClassType, int bytecodeIndex) {
        return new Operation(startPosition, endPosition, methodStartPosition, methodEndPosition, methodName, methodClassType, bytecodeIndex);
    }

    protected final void addNextOperationTo(Operation operation, Operation next) {
        operation.addNextOperation(next);
    }

    protected final Position createPosition(int offset, int line, int column) {
        return new Position(offset, line, column);
    }

    public Operation[] getOperations(String url, int lineNumber, BytecodeProvider bytecodeProvider) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    public MethodArgument[] getArguments(String url, Operation operation) {
        throw new UnsupportedOperationException("This method is not implemented by " + this);
    }

    public MethodArgument[] getArguments(String url, int methodLineNumber) {
        throw new UnsupportedOperationException("This method is not implemented by " + this);
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    static class ContextAware
    extends EditorContext
    implements ContextAwareService<EditorContext> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        public EditorContext forContext(ContextProvider context) {
            return (EditorContext)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)context);
        }

        @Override
        public boolean showSource(String url, int lineNumber, Object timeStamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void createTimeStamp(Object timeStamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void disposeTimeStamp(Object timeStamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void updateTimeStamp(Object timeStamp, String url) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getLineNumber(Object annotation, Object timeStamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removeAnnotation(Object annotation) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getCurrentLineNumber() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCurrentClassName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCurrentURL() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCurrentMethodName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getCurrentFieldName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getSelectedIdentifier() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getSelectedMethodName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getFieldLineNumber(String url, String className, String fieldName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getClassName(String url, int lineNumber) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String[] getImports(String url) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }

    public static final class MethodArgument {
        private String name;
        private String type;
        private Position startPos;
        private Position endPos;

        public MethodArgument(String name, String type, Position startPos, Position endPos) {
            this.name = name;
            this.type = type;
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Position getStartPosition() {
            return this.startPos;
        }

        public Position getEndPosition() {
            return this.endPos;
        }
    }

    public static final class Position {
        private final int offset;
        private final int line;
        private final int column;

        Position(int offset, int line, int column) {
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Position) {
                Position pos = (Position)obj;
                return pos.offset == this.offset;
            }
            return false;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    public static final class Operation {
        private final Position startPosition;
        private final Position endPosition;
        private final int bytecodeIndex;
        private Position methodStartPosition;
        private Position methodEndPosition;
        private String methodName;
        private String methodClassType;
        private Variable returnValue;
        private List<Operation> nextOperations;

        Operation(Position startPosition, Position endPosition, Position methodStartPosition, Position methodEndPosition, String methodName, String methodClassType, int bytecodeIndex) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.bytecodeIndex = bytecodeIndex;
            this.methodStartPosition = methodStartPosition;
            this.methodEndPosition = methodEndPosition;
            this.methodName = methodName;
            this.methodClassType = methodClassType;
        }

        synchronized void addNextOperation(Operation next) {
            if (this.nextOperations == null) {
                this.nextOperations = new ArrayList<Operation>();
            }
            this.nextOperations.add(next);
        }

        public Position getStartPosition() {
            return this.startPosition;
        }

        public Position getEndPosition() {
            return this.endPosition;
        }

        public Position getMethodStartPosition() {
            return this.methodStartPosition;
        }

        public Position getMethodEndPosition() {
            return this.methodEndPosition;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodClassType() {
            return this.methodClassType;
        }

        public int getBytecodeIndex() {
            return this.bytecodeIndex;
        }

        public void setReturnValue(Variable returnValue) {
            this.returnValue = returnValue;
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Operation> getNextOperations() {
            if (this.nextOperations == null) {
                return Collections.emptyList();
            }
            Operation operation = this;
            synchronized (operation) {
                return Collections.unmodifiableList(this.nextOperations);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Operation) {
                Operation op2 = (Operation)obj;
                return this.bytecodeIndex == op2.bytecodeIndex && (this.startPosition == null ? op2.startPosition == null : this.startPosition.equals(op2.startPosition)) && (this.endPosition == null ? op2.endPosition == null : this.endPosition.equals(op2.endPosition));
            }
            return false;
        }

        public int hashCode() {
            return this.bytecodeIndex;
        }
    }

    public static interface BytecodeProvider {
        public byte[] constantPool();

        public byte[] byteCodes();

        public int[] indexAtLines(int var1, int var2);
    }
}

