/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;

public class LocalVariableConverter_i
extends LocalVariableConverter {
    private JcLocalVariable[] jc_locals;
    private int defined_local_size = 0;
    private int undefined_local_max_index = 0;

    public LocalVariableConverter_i(MethodConverter methodConverter) {
        super(methodConverter);
    }

    @Override
    public JcLocalVariable[] convert() throws Exception {
        this.constructLocalVariables();
        Object object = this.jc_locals;
        int n = ((JcLocalVariable[])object).length;
        for (int i = 0; i < n; ++i) {
            for (JcLocalVariable jcLocalVariable = object[i]; jcLocalVariable != null; jcLocalVariable = jcLocalVariable.getNext()) {
                int n2 = this.computeJcIndex(jcLocalVariable);
                jcLocalVariable.setJcIndex(n2);
            }
        }
        if (this.jc_locals.length == 0) {
            this.defined_local_size = 0;
        } else {
            for (object = this.jc_locals[this.jc_locals.length - 1]; object != null; object = ((JcLocalVariable)object).getNext()) {
                n = DataType.getSize(((JcLocalVariable)object).getDescriptor());
                if (this.defined_local_size >= ((JcLocalVariable)object).getJcIndex() + n) continue;
                this.defined_local_size = ((JcLocalVariable)object).getJcIndex() + n;
            }
        }
        return this.jc_locals;
    }

    private void constructLocalVariables() throws Exception {
        JCodeAttr jCodeAttr = this.method_converter.getJavaMethod().getCodeAttr();
        if (jCodeAttr == null) {
            this.jc_locals = new JcLocalVariable[0];
            return;
        }
        JLocalVarTableAttr jLocalVarTableAttr = jCodeAttr.getLocalVarTableAttr();
        if (jLocalVarTableAttr == null) {
            if (this.method_converter.isIntSupported()) {
                // empty if block
            }
            this.jc_locals = new JcLocalVariable[0];
            this.getParameters();
            return;
        }
        JLocalVariable[] jLocalVariableArray = jLocalVarTableAttr.getLocalVars();
        int n = -1;
        for (JLocalVariable jLocalVariable : jLocalVariableArray) {
            if (n >= jLocalVariable.getIndex()) continue;
            n = jLocalVariable.getIndex();
        }
        this.jc_locals = new JcLocalVariable[n + 1];
        for (int i = 0; i < this.jc_locals.length; ++i) {
            this.jc_locals[i] = null;
        }
        for (JLocalVariable jLocalVariable : jLocalVariableArray) {
            JcLocalVariable jcLocalVariable = new JcLocalVariable(jLocalVariable);
            jcLocalVariable.setVarTypeKnown(true);
            int n2 = jLocalVariable.getIndex();
            jcLocalVariable.setNext(this.jc_locals[n2]);
            this.jc_locals[n2] = jcLocalVariable;
        }
    }

    private int computeJcIndex(JcLocalVariable jcLocalVariable) {
        int n = jcLocalVariable.getJIndex();
        if (n == 0) {
            return 0;
        }
        JcLocalVariable jcLocalVariable2 = this.jc_locals[n - 1];
        int n2 = 2;
        while (jcLocalVariable2 == null) {
            if (n - n2 < 0) {
                return 0;
            }
            jcLocalVariable2 = this.jc_locals[n - n2];
            ++n2;
        }
        int n3 = 0;
        while (jcLocalVariable2 != null) {
            int n4 = jcLocalVariable2.getJcIndex();
            if (jcLocalVariable2.getDescriptor().equals("I")) {
                if (n3 < n4 + 2) {
                    n3 = n4 + 2;
                }
            } else if (n3 < n4 + 1) {
                n3 = n4 + 1;
            }
            jcLocalVariable2 = jcLocalVariable2.getNext();
        }
        return n3;
    }

    @Override
    public int getUndefinedLocalVariablesSize() {
        if (this.undefined_locals[this.undefined_local_max_index] == null) {
            return 0;
        }
        int n = 0;
        for (JcLocalVariable jcLocalVariable : this.undefined_locals) {
            if (jcLocalVariable == null) continue;
            if (jcLocalVariable.getType() == 3 || jcLocalVariable.isPromoted()) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    @Override
    public int getDefinedLocalVariablesSize() {
        return this.defined_local_size;
    }

    @Override
    public void updateJcLocalVariable(int n, String string) {
        if (this.jc_locals.length <= n || this.jc_locals[n] != null) {
            // empty if block
        }
        if (this.undefined_locals[n] == null) {
            this.addToUndefHelper(n, string);
            return;
        }
        this.undefined_locals[n].setDescriptor(string);
        this.recomputeUndefIndexes(n);
    }

    @Override
    public JcLocalVariable getJcLocalVariable(int n) {
        if (this.jc_locals.length > n && this.jc_locals[n] != null) {
            return this.jc_locals[n];
        }
        return this.undefined_locals[n];
    }

    private int evaluateStartPC(InstrContainer instrContainer, int n) {
        while (instrContainer.getPrevInstrContainer() != null) {
            if (instrContainer.getControlFlowLabelFlag() || instrContainer.getJInstr().getOpcode() >= 54 && instrContainer.getJInstr().getOpcode() <= 86) {
                return instrContainer.getJInstr().getPC();
            }
            instrContainer = instrContainer.getPrevInstrContainer();
        }
        return instrContainer.getJInstr().getPC();
    }

    private InstrContainer getJInstr(int n) {
        for (InstrContainer instrContainer = this.method_converter.getInstrContainers(); instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            if (instrContainer.getJInstr().getPC() != n) continue;
            return instrContainer;
        }
        return null;
    }

    @Override
    public JcLocalVariable getJcLocalVariable(int n, JInstruction jInstruction) {
        if (n >= this.jc_locals.length) {
            return this.addUndefinedLocalVariable(n, jInstruction);
        }
        int n2 = jInstruction.getPC();
        for (JcLocalVariable jcLocalVariable = this.jc_locals[n]; jcLocalVariable != null; jcLocalVariable = jcLocalVariable.getNext()) {
            int n3 = this.getJInstr(jcLocalVariable.getJStartPC()).isCatchFinallyBlockLeader() ? jcLocalVariable.getJStartPC() : jcLocalVariable.getJStartPC() - 2;
            int n4 = jcLocalVariable.getJLength() + (jcLocalVariable.getJStartPC() - n3);
            if (n3 > n2 || n2 > n3 + n4) continue;
            return jcLocalVariable;
        }
        return this.addUndefinedLocalVariable(n, jInstruction);
    }

    private JcLocalVariable addUndefinedLocalVariable(int n, JInstruction jInstruction) {
        int n2 = jInstruction.getOpcode();
        int n3 = this.getOpcodeType(n2);
        if (!this.method_converter.isIntSupported()) {
            if (n3 == 2) {
                return new JcLocalVariable("undefined", "L", n, n);
            }
            return new JcLocalVariable("undefined", "S", n, n);
        }
        if (this.undefined_locals[n] != null) {
            if (DataType.getType(this.undefined_locals[n].getDescriptor()) == 10 && n3 != 2) {
                this.undefined_locals[n].setMultiType(true);
                if (this.undefined_locals[n].isPromoted()) {
                    this.undefined_locals[n].setDescriptor("I");
                } else {
                    this.undefined_locals[n].setDescriptor("S");
                }
            } else if (DataType.getType(this.undefined_locals[n].getDescriptor()) != 10 && n3 == 2) {
                this.undefined_locals[n].setMultiType(true);
                this.undefined_locals[n].setDescriptor("L");
            }
            return this.undefined_locals[n];
        }
        return this.addToUndef(n, jInstruction);
    }

    private JcLocalVariable addToUndef(int n, JInstruction jInstruction) {
        int n2 = jInstruction.getOpcode();
        int n3 = this.getOpcodeType(n2);
        if (n3 == 2) {
            return this.addToUndefHelper(n, "L");
        }
        return this.addToUndefHelper(n, "S");
    }

    private JcLocalVariable addToUndefHelper(int n, String string) {
        JcLocalVariable jcLocalVariable;
        this.undefined_locals[n] = jcLocalVariable = new JcLocalVariable("undefined", string, n, 0);
        if (this.undefined_local_max_index < n) {
            this.undefined_local_max_index = n;
        }
        JcLocalVariable jcLocalVariable2 = this.getLastUndefLocalVar(n);
        JcLocalVariable jcLocalVariable3 = this.getLastDefLocalVar(n);
        JcLocalVariable jcLocalVariable4 = this.getLastVar(jcLocalVariable3, jcLocalVariable2);
        if (jcLocalVariable4 == null) {
            jcLocalVariable.setJcIndex(0);
        } else if (jcLocalVariable4.getType() == 3) {
            jcLocalVariable.setJcIndex(jcLocalVariable4.getJcIndex() + 2);
        } else {
            jcLocalVariable.setJcIndex(jcLocalVariable4.getJcIndex() + 1);
        }
        if (this.undefined_local_max_index > n) {
            throw new RecalculateIndexException(n);
        }
        return jcLocalVariable;
    }

    private JcLocalVariable getLastUndefLocalVar(int n) {
        if (n == 0) {
            return null;
        }
        --n;
        while (n > 0 && this.undefined_locals[n] == null) {
            --n;
        }
        return this.undefined_locals[n];
    }

    private JcLocalVariable getLastDefLocalVar(int n) {
        if (n == 0 || this.jc_locals.length == 0) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < this.jc_locals.length; ++i) {
            if (this.jc_locals[i] == null) continue;
            n2 = i;
        }
        return this.jc_locals[n2];
    }

    private JcLocalVariable getLastVar(JcLocalVariable jcLocalVariable, JcLocalVariable jcLocalVariable2) {
        if (jcLocalVariable2 == null && jcLocalVariable == null) {
            return null;
        }
        if (jcLocalVariable2 == null && jcLocalVariable != null) {
            return jcLocalVariable;
        }
        if (jcLocalVariable2 != null && jcLocalVariable == null) {
            return jcLocalVariable2;
        }
        if (jcLocalVariable2 != null && jcLocalVariable != null && jcLocalVariable.getJcIndex() > jcLocalVariable2.getJcIndex()) {
            return jcLocalVariable;
        }
        return jcLocalVariable2;
    }

    @Override
    public void recomputeUndefIndexes(int n) {
        for (int i = n + 1; i <= this.undefined_local_max_index; ++i) {
            if (this.undefined_locals[i] == null) continue;
            JcLocalVariable jcLocalVariable = null;
            JcLocalVariable jcLocalVariable2 = this.getLastUndefLocalVar(i);
            JcLocalVariable jcLocalVariable3 = this.getLastDefLocalVar(i);
            jcLocalVariable = this.getLastVar(jcLocalVariable3, jcLocalVariable2);
            if (jcLocalVariable == null) {
                return;
            }
            if (jcLocalVariable.getType() == 3 || jcLocalVariable.isPromoted()) {
                this.undefined_locals[i].setJcIndex(jcLocalVariable.getJcIndex() + 2);
                continue;
            }
            this.undefined_locals[i].setJcIndex(jcLocalVariable.getJcIndex() + 1);
        }
    }

    private int getOpcodeType(int n) {
        switch (n) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 132: 
            case 196: {
                return 1;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                return 2;
            }
        }
        throw new ClassFormatError();
    }

    private void getParameters() {
        String string = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] stringArray = MethodDescriptor.getParamDescriptors(string);
        int n = 0;
        if (!this.method_converter.getJavaMethod().isStatic()) {
            JcLocalVariable jcLocalVariable = this.addToUndefHelper(n++, "L");
            jcLocalVariable.setVarTypeKnown(true);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("V")) continue;
            JcLocalVariable jcLocalVariable = this.addToUndefHelper(n++, stringArray[i]);
            jcLocalVariable.setVarTypeKnown(true);
        }
    }

    private void checkParameters() throws Exception {
        String string = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] stringArray = MethodDescriptor.getParamDescriptors(string);
        if (stringArray.length != 0) {
            Notifier.error("conversion.20", this.method_converter.getClassName().replace('/', '.'));
            throw new ConversionException();
        }
    }
}

