/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.RegisteredDDCatalog;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GlassfishInstanceProvider
implements ServerInstanceProvider {
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    private static volatile GlassfishInstanceProvider preludeProvider;
    private static volatile GlassfishInstanceProvider ee6Provider;
    private static String EE6_PROP_ROOT;
    private static String INSTALL_ROOT_SUFFIX;
    private static String EE6_INSTALL_ROOT_PROP;
    private static String PRELUDE_PROP_ROOT;
    private static String EE6_DEPLOYER_FRAGMENT;
    private static String PRELUDE_DEPLOYER_FRAGMENT;
    private static String EE6_INSTANCES_PATH;
    private static String PRELUDE_INSTANCES_PATH;
    public static String PRELUDE_DEFAULT_NAME;
    public static final Set<String> activeRegistrationSet;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private static final Set<String> activeDisplayNames;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private String[] instancesDirNames;
    private String displayName;
    private String[] uriFragments;
    private String installRootPropName;
    private String defaultDomainName;
    private String defaultPersonalDomainName;
    private String defaultInstallName;
    private String directDownloadUrl;
    private String indirectDownloadUrl;
    private String installRootKey;
    private String[] requiredFiles;
    private String[] excludedFiles;
    private boolean needsJdk6;
    private String[] javadocFilenames;
    private List<String> noPasswordOptions;
    private CommandFactory cf;

    public static List<GlassfishInstanceProvider> getProviders(boolean initialize) {
        ArrayList<GlassfishInstanceProvider> providerList = new ArrayList<GlassfishInstanceProvider>();
        if (initialize) {
            GlassfishInstanceProvider.getPrelude();
            GlassfishInstanceProvider.getEe6();
        }
        if (preludeProvider != null) {
            providerList.add(preludeProvider);
        }
        if (ee6Provider != null) {
            providerList.add(ee6Provider);
        }
        return providerList;
    }

    public static synchronized GlassfishInstanceProvider getEe6() {
        if (ee6Provider == null) {
            ee6Provider = new GlassfishInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH}, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_SERVER_NAME", (Object[])new Object[0]), EE6_INSTALL_ROOT_PROP, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_CREATED_NAME", (Object[])new Object[0]), "GlassFish_Server_3", "http://java.net/download/glassfish/v3/release/glassfish-v3.zip", "http://serverplugins.netbeans.org/glassfishv3/post68v3.txt", "last-v3ee6-install-root", new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, new String[0], true, new String[]{"docs/javaee6-doc-api.zip"}, new String[]{"--nopassword"}, new CommandFactory(){

                @Override
                public ServerCommand.SetPropertyCommand getSetPropertyCommand(String name, String value) {
                    return new ServerCommand.SetPropertyCommand(name, value, "DEFAULT={0}={1}");
                }
            });
            ee6Provider.init();
        }
        return ee6Provider;
    }

    public static synchronized GlassfishInstanceProvider getPrelude() {
        String[] uriFragments = new String[]{PRELUDE_DEPLOYER_FRAGMENT};
        String[] instanceDirs = new String[]{PRELUDE_INSTANCES_PATH};
        if (preludeProvider == null) {
            preludeProvider = new GlassfishInstanceProvider(uriFragments, instanceDirs, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_SERVER_NAME", (Object[])new Object[0]), PRELUDE_PROP_ROOT + INSTALL_ROOT_SUFFIX, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_CREATED_NAME", (Object[])new Object[0]), PRELUDE_DEFAULT_NAME, "http://java.net/download/glassfish/v3-prelude/release/glassfish-v3-prelude-ml.zip", "http://serverplugins.netbeans.org/glassfishv3/post68prelude.txt", "last-install-root", new String[0], new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, false, new String[]{"docs/javaee6-doc-api.zip"}, null, new CommandFactory(){

                @Override
                public ServerCommand.SetPropertyCommand getSetPropertyCommand(String name, String value) {
                    return new ServerCommand.SetPropertyCommand(name, value, "target={0}&value={1}");
                }
            });
            preludeProvider.init();
        }
        return preludeProvider;
    }

    private GlassfishInstanceProvider(String[] uriFragments, String[] instancesDirNames, String displayName, String propName, String defaultName, String personalName, String installName, String direct, String indirect, String prefKey, String[] requiredFiles, String[] excludedFiles, boolean needsJdk6, String[] javadocFilenames, String[] noPasswordOptionsArray, CommandFactory cf) {
        this.instancesDirNames = instancesDirNames;
        this.displayName = displayName;
        this.uriFragments = uriFragments;
        this.installRootPropName = propName;
        this.defaultDomainName = defaultName;
        this.defaultPersonalDomainName = personalName;
        this.defaultInstallName = installName;
        this.directDownloadUrl = direct;
        this.indirectDownloadUrl = indirect;
        this.installRootKey = prefKey;
        this.requiredFiles = requiredFiles;
        this.excludedFiles = excludedFiles;
        this.needsJdk6 = needsJdk6;
        this.javadocFilenames = javadocFilenames;
        this.noPasswordOptions = new ArrayList<String>();
        if (null != noPasswordOptionsArray) {
            this.noPasswordOptions.addAll(Arrays.asList(noPasswordOptionsArray));
        }
        this.cf = cf;
    }

    public static synchronized boolean initialized() {
        return preludeProvider != null || ee6Provider != null;
    }

    public static Logger getLogger() {
        return Logger.getLogger("glassfish");
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookup.getDefault().lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(GlassfishInstanceProvider gip, RegisteredDDCatalog catalog) {
        GlassfishInstance firstInstance = gip.getFirstServerInstance();
        if (null != firstInstance) {
            catalog.refreshRunTimeDDCatalog(gip, firstInstance.getGlassfishRoot());
        }
    }

    public String[] getAssociatedJavaDoc() {
        return (String[])this.javadocFilenames.clone();
    }

    private GlassfishInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance si) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog catalog;
                this.instanceMap.put(si.getDeployerUri(), si);
                activeDisplayNames.add(si.getDisplayName());
                if (this.instanceMap.size() == 1 && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, si.getGlassfishRoot());
                }
                this.writeInstanceToFile(si);
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
        this.support.fireChange();
    }

    public String getDefaultInstallName() {
        return this.defaultInstallName;
    }

    public String getDirectDownloadUrl() {
        return this.directDownloadUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIndirectDownloadUrl() {
        return this.indirectDownloadUrl;
    }

    public String getInstallRootKey() {
        return this.installRootKey;
    }

    public String getInstallRootProperty() {
        return this.installRootPropName;
    }

    public String[] getRequiredFiles() {
        return (String[])this.requiredFiles.clone();
    }

    public String[] getExcludedFiles() {
        return (String[])this.excludedFiles.clone();
    }

    public String getNameOfBits() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragments[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance si) {
        boolean result = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(si.getDeployerUri()) != null) {
                RegisteredDDCatalog catalog;
                result = true;
                this.removeInstanceFromFile(si.getDeployerUri());
                activeDisplayNames.remove(si.getDisplayName());
                if (this.instanceMap.size() == 0 && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        if (result) {
            this.support.fireChange();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance instance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance gfInstance : this.instanceMap.values()) {
                if (!gfInstance.getCommonInstance().equals(instance)) continue;
                return gfInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String uri) {
        return this.instanceMap.get(uri);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        Object result = null;
        GlassfishInstance instance = this.instanceMap.get(uri);
        if (instance != null) {
            result = instance.getLookup().lookup(serverFacadeClass);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                Object serverFacade = instance.getLookup().lookup(serverFacadeClass);
                if (serverFacade == null) continue;
                result.add(serverFacade);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> result = new ArrayList<ServerInstance>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                result.add(instance.getCommonInstance());
            }
        }
        return result;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public boolean hasServer(String uri) {
        return this.getInstance(uri) != null;
    }

    public ServerInstance getInstance(String uri) {
        GlassfishInstance instance = this.instanceMap.get(uri);
        return instance == null ? null : instance.getCommonInstance();
    }

    public String formatUri(String glassfishRoot, String hostName, int httpPort) {
        return "[" + glassfishRoot + "]" + this.uriFragments[0] + ":" + hostName + ":" + httpPort;
    }

    String getInstancesDirName() {
        return this.instancesDirNames[0];
    }

    Collection<GlassfishInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.loadServerInstances();
            }
            catch (RuntimeException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
            RegisteredDDCatalog catalog = GlassfishInstanceProvider.getDDCatalog();
            if (null != catalog) {
                if (this.equals(preludeProvider)) {
                    catalog.registerPreludeRunTimeDDCatalog(this);
                } else {
                    catalog.registerEE6RunTimeDDCatalog(this);
                }
                GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, catalog);
            }
        }
    }

    private void loadServerInstances() {
        for (int j = 0; j < this.instancesDirNames.length; ++j) {
            FileObject[] instanceFOs;
            FileObject dir = this.getRepositoryDir(this.instancesDirNames[j], false);
            if (dir == null || (instanceFOs = dir.getChildren()) == null || instanceFOs.length <= 0) continue;
            for (int i = 0; i < instanceFOs.length; ++i) {
                try {
                    GlassfishInstance si = this.readInstanceFromFile(instanceFOs[i], this.uriFragments[j]);
                    if (si != null) {
                        this.instanceMap.put(si.getDeployerUri(), si);
                        activeDisplayNames.add(si.getDisplayName());
                        continue;
                    }
                    GlassfishInstanceProvider.getLogger().finer("Unable to create glassfish instance for " + instanceFOs[i].getPath());
                    continue;
                }
                catch (IOException ex) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
                }
            }
        }
        for (GlassfishInstance gi : this.instanceMap.values()) {
            gi.updateModuleSupport();
        }
    }

    private GlassfishInstance readInstanceFromFile(FileObject instanceFO, String uriFragment) throws IOException {
        GlassfishInstance instance = null;
        String installRoot = GlassfishInstanceProvider.getStringAttribute(instanceFO, "installfolder");
        String glassfishRoot = GlassfishInstanceProvider.getStringAttribute(instanceFO, "homefolder");
        if (installRoot == null) {
            installRoot = glassfishRoot;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(installRoot) && GlassfishInstanceProvider.isValidGlassfishFolder(glassfishRoot)) {
            HashMap<String, String> ip = new HashMap<String, String>();
            Enumeration iter = instanceFO.getAttributes();
            while (iter.hasMoreElements()) {
                String name = (String)iter.nextElement();
                String value = GlassfishInstanceProvider.getStringAttribute(instanceFO, name);
                ip.put(name, value);
            }
            ip.put(INSTANCE_FO_ATTR, instanceFO.getName());
            instance = GlassfishInstance.create(ip, this, false);
        } else {
            GlassfishInstanceProvider.getLogger().finer("GlassFish folder " + instanceFO.getPath() + " is not a valid install.");
            instanceFO.delete();
        }
        return instance;
    }

    private void writeInstanceToFile(GlassfishInstance instance) throws IOException {
        String glassfishRoot = instance.getGlassfishRoot();
        if (glassfishRoot == null) {
            GlassfishInstanceProvider.getLogger().log(Level.SEVERE, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String url = instance.getDeployerUri();
        FileObject dir = this.getRepositoryDir(this.instancesDirNames[0], true);
        FileObject[] instanceFOs = dir.getChildren();
        FileObject instanceFO = null;
        for (int i = 0; i < instanceFOs.length; ++i) {
            if (!url.equals(instanceFOs[i].getAttribute("url"))) continue;
            instanceFO = instanceFOs[i];
        }
        if (instanceFO == null) {
            String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
            instanceFO = dir.createData(name);
        }
        CommonServerSupport css = instance.getCommonSupport();
        Map<String, String> attrMap = css.getInstanceProperties();
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            String key = entry.getKey();
            if (GlassfishInstanceProvider.filterKey(key)) continue;
            instanceFO.setAttribute(key, (Object)entry.getValue());
        }
        css.setProperty(INSTANCE_FO_ATTR, instanceFO.getName());
        css.setFileObject(instanceFO);
    }

    private static boolean filterKey(String key) {
        return INSTANCE_FO_ATTR.equals(key);
    }

    private void removeInstanceFromFile(String url) {
        FileObject instanceFO = this.getInstanceFileObject(url);
        if (instanceFO != null && instanceFO.isValid()) {
            try {
                instanceFO.delete();
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
    }

    private FileObject getInstanceFileObject(String url) {
        for (String instancesDirName : this.instancesDirNames) {
            FileObject dir = this.getRepositoryDir(instancesDirName, false);
            if (dir == null) continue;
            FileObject[] installedServers = dir.getChildren();
            for (int i = 0; i < installedServers.length; ++i) {
                String val = GlassfishInstanceProvider.getStringAttribute(installedServers[i], "url");
                if (val == null || !val.equals(url)) continue;
                return installedServers[i];
            }
        }
        return null;
    }

    private FileObject getRepositoryDir(String path, boolean create) {
        FileObject dir = FileUtil.getConfigFile((String)path);
        if (dir == null && create) {
            try {
                dir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)path);
            }
            catch (IOException ex) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, ex);
            }
        }
        return dir;
    }

    private static boolean isValidHomeFolder(String folderName) {
        boolean result = false;
        if (folderName != null) {
            File f = new File(folderName);
            result = f.exists();
            result = result && f.isDirectory();
            result = result && f.canRead();
        }
        return result;
    }

    private static boolean isValidGlassfishFolder(String folderName) {
        boolean result = false;
        if (folderName != null) {
            File f = new File(folderName);
            result = f.exists();
            result = result && f.isDirectory();
            result = result && f.canRead();
        }
        return result;
    }

    private static String getStringAttribute(FileObject fo, String attrName) {
        return GlassfishInstanceProvider.getStringAttribute(fo, attrName, null);
    }

    private static String getStringAttribute(FileObject fo, String attrName, String defValue) {
        String result = defValue;
        Object attr = fo.getAttribute(attrName);
        if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }

    String[] getNoPasswordCreatDomainCommand(String startScript, String jarLocation, String domainDir, String portBase, String uname, String domain) {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.addAll(Arrays.asList(startScript, "-client", "-jar", jarLocation, "create-domain", "--user", uname, "--domaindir", domainDir, "--portbase", portBase));
        if (this.noPasswordOptions.size() > 0) {
            retVal.addAll(this.noPasswordOptions);
        }
        retVal.add(domain);
        return retVal.toArray(new String[retVal.size()]);
    }

    CommandFactory getCommandFactory() {
        return this.cf;
    }

    static {
        EE6_PROP_ROOT = "org.glassfish.v3ee6.";
        INSTALL_ROOT_SUFFIX = "installRoot";
        EE6_INSTALL_ROOT_PROP = EE6_PROP_ROOT + INSTALL_ROOT_SUFFIX;
        PRELUDE_PROP_ROOT = "org.glassfish.v3.";
        EE6_DEPLOYER_FRAGMENT = "deployer:gfv3ee6";
        PRELUDE_DEPLOYER_FRAGMENT = "deployer:gfv3";
        EE6_INSTANCES_PATH = "/GlassFishEE6/Instances";
        PRELUDE_INSTANCES_PATH = "/GlassFish/Instances";
        PRELUDE_DEFAULT_NAME = "GlassFish_v3_Prelude";
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
        activeDisplayNames = Collections.synchronizedSet(new HashSet());
    }
}

