/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.netbeans.modules.servicetag.RegistrationData;

public class NbConnectionSupport {
    private static String NB_REGISTRATION_HOST = "https://inventory.sun.com";
    private static String SANDBOX_TESTING_HOST = "https://connection-tst.sun.com";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.NbConnectionSupport");

    private NbConnectionSupport() {
    }

    public static URL getRegistrationURL(String registrationURN, String product) {
        String url = System.getProperty("nb.registration.host");
        url = url == null ? NB_REGISTRATION_HOST + "/RegistrationWeb/register" : url + "/RegistrationWeb/register";
        if ((url = url.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        String registerURL = NbConnectionSupport.rewriteURL(url, registrationURN, product);
        try {
            return new URL(registerURL);
        }
        catch (MalformedURLException ex) {
            InternalError x = new InternalError(ex.getMessage());
            x.initCause(ex);
            throw x;
        }
    }

    public static String getRegistrationQueryHost() {
        String url = System.getProperty("nb.registration.host");
        if (url == null) {
            url = NB_REGISTRATION_HOST;
        }
        if ((url = url.trim()).length() == 0) {
            throw new InternalError("Empty registration url set");
        }
        return url;
    }

    private static String rewriteURL(String url, String registryURN, String product) {
        int len;
        StringBuilder sb = new StringBuilder(url.trim());
        if (sb.charAt((len = sb.length()) - 1) != '/') {
            sb.append('/');
        }
        sb.append(registryURN);
        sb.append("?");
        sb.append("product=" + product);
        sb.append("&");
        sb.append("locale=").append(Locale.getDefault().getLanguage());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean postRegistrationData(URL url, RegistrationData registration) {
        try {
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "text/xml;charset=\"utf-8\"");
            con.connect();
            LOG.log(Level.FINE, "POSTing registration data at " + url);
            OutputStream out = con.getOutputStream();
            try {
                registration.storeToXML(out);
                LOG.log(Level.FINE, "Registration data: " + registration.toString());
                out.flush();
            }
            finally {
                out.close();
            }
            int returnCode = con.getResponseCode();
            LOG.log(Level.FINE, "POST return status = " + returnCode);
            NbConnectionSupport.printReturnData(con, returnCode);
            return returnCode == 200;
        }
        catch (MalformedURLException me) {
            InternalError x = new InternalError("Error in registering: " + me.getMessage());
            x.initCause(me);
            throw x;
        }
        catch (Exception ioe) {
            LOG.log(Level.FINE, "Post registration data failed:", ioe);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printReturnData(HttpURLConnection con, int returnCode) throws IOException {
        InputStream is = null;
        is = returnCode < 400 ? con.getInputStream() : con.getErrorStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(String host, String uuid) {
        try {
            URL url = new URL(host + "/ProductRegistrationService/status/" + uuid);
            LOG.log(Level.FINE, "Query URL: " + url);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.connect();
            int responseCode = con.getResponseCode();
            LOG.log(Level.FINE, "Response code = " + responseCode);
            if (responseCode == 200) {
                InputStream is = con.getInputStream();
                StringBuffer sb = new StringBuffer();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                }
                finally {
                    is.close();
                }
                String response = sb.toString();
                LOG.log(Level.FINE, "Response: " + response);
                return !response.equals("NOT REGISTERED");
            }
            if (responseCode == 404) {
                return true;
            }
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Error: " + ex.getMessage(), ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered2(String host, String uuid) {
        try {
            URL url = new URL(host + "/ProductRegistrationService/status/" + uuid);
            LOG.log(Level.FINE, "Query URL: " + url);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.connect();
            int responseCode = con.getResponseCode();
            LOG.log(Level.FINE, "Response code = " + responseCode);
            if (responseCode == 200) {
                InputStream is = con.getInputStream();
                StringBuffer sb = new StringBuffer();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                }
                finally {
                    is.close();
                }
                String response = sb.toString();
                LOG.log(Level.FINE, "Response: " + response);
                return response.equals("REGISTERED");
            }
            if (responseCode == 404) {
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Error: " + ex.getMessage(), ex);
            return false;
        }
    }
}

