/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMRFieldNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CMFieldChildren
extends Children.Keys<CommonDDBean>
implements PropertyChangeListener {
    private final EntityMethodController controller;
    private final Entity model;
    private final EjbJar ejbJar;
    private final FileObject ddFile;

    public CMFieldChildren(EntityMethodController entityMethodController, Entity entity, FileObject fileObject) throws IOException {
        this.model = entity;
        this.controller = entityMethodController;
        this.ejbJar = DDProvider.getDefault().getDDRoot(fileObject);
        this.ddFile = fileObject;
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CMFieldChildren.this.controller.getBeanClass() == null) {
                    CMFieldChildren.this.setKeys(Collections.emptySet());
                } else {
                    List list = CMFieldChildren.this.getCmrFields(CMFieldChildren.this.model.getEjbName());
                    CmpField[] cmpFieldArray = CMFieldChildren.this.model.getCmpField();
                    Arrays.sort(cmpFieldArray, new Comparator<CmpField>(){

                        @Override
                        public int compare(CmpField cmpField, CmpField cmpField2) {
                            String string = cmpField.getFieldName();
                            String string2 = cmpField2.getFieldName();
                            if (string == null) {
                                string = "";
                            }
                            if (string2 == null) {
                                string2 = "";
                            }
                            return string.compareTo(string2);
                        }
                    });
                    list.addAll(Arrays.asList(cmpFieldArray));
                    CMFieldChildren.this.setKeys(list);
                }
            }
        });
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.ejbJar.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(CommonDDBean commonDDBean) {
        Node[] nodeArray = null;
        if (commonDDBean instanceof CmpField) {
            CmpField cmpField = (CmpField)commonDDBean;
            CMPFieldNode cMPFieldNode = new CMPFieldNode(cmpField, this.controller, this.ddFile);
            nodeArray = new Node[]{cMPFieldNode};
        } else if (commonDDBean instanceof CmrField) {
            CmrField cmrField = (CmrField)commonDDBean;
            CMRFieldNode cMRFieldNode = new CMRFieldNode(cmrField, this.controller, this.ddFile);
            nodeArray = new Node[]{cMRFieldNode};
        }
        return nodeArray;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateKeys();
    }

    private CmrField getCmrField(EjbRelationshipRole ejbRelationshipRole, String string) {
        return ejbRelationshipRole != null && ejbRelationshipRole.getRelationshipRoleSource() != null && string.equals(ejbRelationshipRole.getRelationshipRoleSource().getEjbName()) && ejbRelationshipRole.getCmrField() != null ? ejbRelationshipRole.getCmrField() : null;
    }

    private void getFields(String string, List<CommonDDBean> list) {
        EjbRelation[] ejbRelationArray;
        Relationships relationships = this.ejbJar.getSingleRelationships();
        if (relationships != null && (ejbRelationArray = relationships.getEjbRelation()) != null) {
            for (int i = 0; i < ejbRelationArray.length; ++i) {
                CmrField cmrField = this.getCmrField(ejbRelationArray[i].getEjbRelationshipRole(), string);
                if (cmrField != null) {
                    list.add((CommonDDBean)cmrField);
                }
                if ((cmrField = this.getCmrField(ejbRelationArray[i].getEjbRelationshipRole2(), string)) == null) continue;
                list.add((CommonDDBean)cmrField);
            }
        }
    }

    private List<CommonDDBean> getCmrFields(String string) {
        LinkedList<CommonDDBean> linkedList = new LinkedList<CommonDDBean>();
        this.getFields(string + "", linkedList);
        return linkedList;
    }
}

