/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.impl.TimedOutException;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;

public class ProgressObjectUtil {
    private static final Logger LOGGER = Logger.getLogger(ProgressObjectUtil.class.getName());

    private ProgressObjectUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean trackProgressObject(ProgressUI progressUI, ProgressObject progressObject, long l) throws TimedOutException {
        AtomicBoolean atomicBoolean;
        block15: {
            assert (progressObject != null);
            assert (progressUI != null);
            atomicBoolean = new AtomicBoolean();
            progressUI.setProgressObject(progressObject);
            try {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                ProgressListener progressListener = new ProgressListener(){

                    public void handleProgressEvent(ProgressEvent progressEvent) {
                        DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
                        if (deploymentStatus.isCompleted()) {
                            atomicBoolean.set(true);
                        }
                        if (deploymentStatus.isCompleted() || deploymentStatus.isFailed()) {
                            countDownLatch.countDown();
                        }
                    }
                };
                progressObject.addProgressListener(progressListener);
                try {
                    DeploymentStatus deploymentStatus = progressObject.getDeploymentStatus();
                    if (!deploymentStatus.isCompleted() && !deploymentStatus.isFailed()) {
                        try {
                            if (l == 0L) {
                                countDownLatch.await();
                            } else {
                                countDownLatch.await(l, TimeUnit.MILLISECONDS);
                                if (countDownLatch.getCount() > 0L) {
                                    throw new TimedOutException();
                                }
                            }
                            break block15;
                        }
                        catch (InterruptedException interruptedException) {
                            LOGGER.log(Level.INFO, null, interruptedException);
                        }
                        break block15;
                    }
                    if (deploymentStatus.isCompleted()) {
                        atomicBoolean.set(true);
                    }
                }
                finally {
                    progressObject.removeProgressListener(progressListener);
                }
            }
            finally {
                progressUI.setProgressObject(null);
            }
        }
        return atomicBoolean.get();
    }
}

