/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorLookupPanelsPolicy;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.netbeans.spi.navigator.NavigatorPanelWithUndo;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NavigatorController
implements LookupListener,
ActionListener,
PropertyChangeListener,
NodeListener,
Runnable {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private final Object CUR_NODES_LOCK = new Object();
    private static final Lookup.Template<Node> CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template<NavigatorLookupHint> CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result<Node> curNodesRes;
    private Lookup.Result<NavigatorLookupHint> curHintsRes;
    private Collection<? extends Node> curNodes = Collections.emptyList();
    private final ClientsLookup clientsLookup;
    private final Lookup panelLookup;
    private Lookup.Result<Node> panelLookupNodesResult;
    private final LookupListener panelLookupListener;
    private Reference<TopComponent> lastActivatedRef;
    private List<NodeListener> weakNodesL = Collections.emptyList();
    private boolean inUpdate;
    private static final Logger LOG = Logger.getLogger(NavigatorController.class.getName());

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = new ClientsLookup();
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
        this.panelLookupListener = new PanelLookupListener();
    }

    public void navigatorTCOpened() {
        LOG.fine("Entering navigatorTCOpened");
        this.curNodesRes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodesRes.addLookupListener((LookupListener)this);
        this.curHintsRes = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHintsRes.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult = this.panelLookup.lookup(CUR_NODES);
        this.panelLookupNodesResult.addLookupListener(this.panelLookupListener);
        this.updateContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigatorTCClosed() {
        LOG.fine("Entering navigatorTCClosed");
        this.curNodesRes.removeLookupListener((LookupListener)this);
        this.curHintsRes.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.panelLookupNodesResult.removeLookupListener(this.panelLookupListener);
        this.curNodesRes = null;
        this.curHintsRes = null;
        Object object = this.CUR_NODES_LOCK;
        synchronized (object) {
            this.curNodes = Collections.emptyList();
        }
        this.weakNodesL = Collections.emptyList();
        this.clientsLookup.lookup(Object.class);
        NavigatorPanel selPanel = this.navigatorTC.getSelectedPanel();
        if (selPanel != null) {
            selPanel.panelDeactivated();
        }
        this.lastActivatedRef = null;
        this.navigatorTC.setPanels(null, null);
        this.panelLookupNodesResult = null;
        LOG.fine("navigatorTCClosed: activated nodes: " + this.navigatorTC.getActivatedNodes());
        if (this.navigatorTC.getActivatedNodes() != null) {
            LOG.fine("navigatorTCClosed: clearing act nodes...");
            this.navigatorTC.setActivatedNodes(new Node[0]);
        }
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (index == -1) {
            return;
        }
        NavigatorPanel newPanel = this.navigatorTC.getPanels().get(index);
        this.activatePanel(newPanel);
    }

    public void activatePanel(NavigatorPanel panel) {
        if (!this.navigatorTC.getPanels().contains(panel)) {
            throw new IllegalArgumentException("Panel is not available for activation: " + panel);
        }
        NavigatorPanel oldPanel = this.navigatorTC.getSelectedPanel();
        if (!panel.equals(oldPanel)) {
            if (oldPanel != null) {
                oldPanel.panelDeactivated();
            }
            panel.panelActivated((Lookup)this.clientsLookup);
            this.navigatorTC.setSelectedPanel(panel);
            this.panelLookup.lookup(Object.class);
            this.cacheLastSelPanel(panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated()) || this.curNodes == null || this.curNodes.isEmpty()) {
            ActNodeSetter nodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)nodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)nodeSetter);
            }
        }
    }

    private boolean shouldUpdate() {
        return TopComponent.getRegistry().getCurrentNodes() != null || Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class) != null;
    }

    private void updateContext() {
        this.updateContext(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateContext(boolean force) {
        void var7_13;
        boolean areNewProviders;
        LOG.fine("updateContext entered, force: " + force);
        if (this.inUpdate) {
            LOG.fine("Exit because inUpdate already, force: " + force);
            return;
        }
        this.inUpdate = true;
        if (this.curNodesRes == null) {
            this.inUpdate = false;
            LOG.fine("Exit because curNodesRes is null, force: " + force);
            return;
        }
        Collection nodes = this.curNodesRes.allInstances();
        if (nodes.isEmpty() && !this.shouldUpdate() && !force) {
            this.inUpdate = false;
            LOG.fine("Exit because act nodes empty, force: " + force);
            return;
        }
        Object object = this.CUR_NODES_LOCK;
        synchronized (object) {
            Iterator<NodeListener> curL = this.weakNodesL.iterator();
            Iterator<? extends Node> curNode = this.curNodes.iterator();
            while (curNode.hasNext()) {
                curNode.next().removeNodeListener(curL.next());
            }
            this.weakNodesL = new ArrayList<NodeListener>(nodes.size());
            this.curNodes = nodes;
            LOG.fine("new CurNodes size " + this.curNodes.size());
            NodeListener weakNodeL = null;
            for (Node node : this.curNodes) {
                weakNodeL = (NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this, (Object)node);
                this.weakNodesL.add(weakNodeL);
                node.addNodeListener(weakNodeL);
            }
        }
        List<NavigatorPanel> providers = this.obtainProviders(nodes);
        List<NavigatorPanel> oldProviders = this.navigatorTC.getPanels();
        boolean bl = areNewProviders = providers != null && !providers.isEmpty();
        if (oldProviders == null && providers == null) {
            this.inUpdate = false;
            LOG.fine("Exit because nav remain empty, force: " + force);
            return;
        }
        NavigatorPanel selPanel = this.navigatorTC.getSelectedPanel();
        if (oldProviders != null && oldProviders.contains(selPanel) && providers != null && providers.contains(selPanel)) {
            this.clientsLookup.lookup(Node.class);
            if (!((Object)oldProviders).equals(providers)) {
                this.navigatorTC.getPanelSelector().removeActionListener(this);
                this.navigatorTC.setPanels(providers, null);
                this.navigatorTC.setSelectedPanel(selPanel);
                this.navigatorTC.getPanelSelector().addActionListener(this);
            }
            this.updateActNodesAndTitle();
            LOG.fine("Exit because same provider and panel, notified. Force: " + force);
            this.inUpdate = false;
            return;
        }
        if (selPanel != null) {
            if (!areNewProviders && !force && null != providers) {
                this.inUpdate = false;
                LOG.fine("Exit because no new providers, force: " + force);
                return;
            }
            selPanel.panelDeactivated();
        }
        this.clientsLookup.lookup(Node.class);
        Object var7_9 = null;
        if (areNewProviders) {
            void var7_12;
            NavigatorPanel navigatorPanel = this.getLastSelPanel(providers);
            if (navigatorPanel == null) {
                NavigatorPanel navigatorPanel2 = providers.get(0);
            }
            var7_12.panelActivated((Lookup)this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(providers, (NavigatorPanel)var7_13);
        this.panelLookup.lookup(Object.class);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        this.updateActNodesAndTitle();
        LOG.fine("Normal exit, change to new provider, force: " + force);
        this.inUpdate = false;
    }

    private void updateActNodesAndTitle() {
        LOG.fine("updateActNodesAndTitle called...");
        Node[] actNodes = this.obtainActivatedNodes();
        this.navigatorTC.setActivatedNodes(actNodes);
        this.updateTCTitle(actNodes);
    }

    private void updateTCTitle(Node[] nodes) {
        String newTitle = nodes != null && nodes.length > 0 ? NbBundle.getMessage(NavigatorTC.class, (String)"FMT_Navigator", (Object)nodes[0].getDisplayName()) : NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setDisplayName(newTitle);
    }

    List<NavigatorPanel> obtainProviders(Collection<? extends Node> nodes) {
        Lookup globalContext = Utilities.actionsGlobalContext();
        NavigatorLookupPanelsPolicy panelsPolicy = (NavigatorLookupPanelsPolicy)globalContext.lookup(NavigatorLookupPanelsPolicy.class);
        ArrayList<? extends NavigatorPanel> result = null;
        Collection lkpHints = globalContext.lookupAll(NavigatorLookupHint.class);
        for (NavigatorLookupHint curHint : lkpHints) {
            Collection<? extends NavigatorPanel> collection = ProviderRegistry.getInstance().getProviders(curHint.getContentType());
            if (collection == null || collection.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<NavigatorPanel>(collection.size() * lkpHints.size());
            }
            for (NavigatorPanel navigatorPanel : collection) {
                if (result.contains(navigatorPanel)) continue;
                result.add(navigatorPanel);
            }
        }
        if (panelsPolicy != null && panelsPolicy.getPanelsPolicy() == 1) {
            return result;
        }
        ArrayList<? extends NavigatorPanel> fileResult = null;
        for (Node node : nodes) {
            DataObject dObj = (DataObject)node.getLookup().lookup(DataObject.class);
            while (dObj instanceof DataShadow) {
                dObj = ((DataShadow)dObj).getOriginal();
            }
            if (dObj == null) {
                fileResult = null;
                break;
            }
            FileObject fileObject = dObj.getPrimaryFile();
            if (fileObject.isVirtual()) {
                fileResult = null;
                break;
            }
            String contentType = fileObject.getMIMEType();
            Collection<? extends NavigatorPanel> providers = ProviderRegistry.getInstance().getProviders(contentType);
            if (providers == null || providers.isEmpty()) {
                fileResult = null;
                break;
            }
            LOG.fine("File mime type providers size: " + providers.size());
            if (fileResult == null) {
                fileResult = new ArrayList(providers.size());
                fileResult.addAll(providers);
                continue;
            }
            fileResult.retainAll(providers);
        }
        if (result != null) {
            if (fileResult != null) {
                for (NavigatorPanel navigatorPanel : fileResult) {
                    if (result.contains(navigatorPanel)) continue;
                    result.add(navigatorPanel);
                }
            }
        } else {
            result = fileResult;
        }
        return result;
    }

    private Node[] obtainActivatedNodes() {
        Lookup selLookup = this.getSelectedPanelLookup();
        if (selLookup == null) {
            return this.curNodes.toArray(new Node[0]);
        }
        return selLookup.lookupAll(Node.class).toArray(new Node[0]);
    }

    UndoRedo getUndoRedo() {
        NavigatorPanel panel = this.navigatorTC.getSelectedPanel();
        if (panel == null || !(panel instanceof NavigatorPanelWithUndo)) {
            return UndoRedo.NONE;
        }
        return ((NavigatorPanelWithUndo)panel).getUndoRedo();
    }

    public void installActions() {
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(returnKey, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName())) {
            TopComponent tc = TopComponent.getRegistry().getActivated();
            if (tc != null && tc != this.navigatorTC) {
                this.lastActivatedRef = new WeakReference<TopComponent>(tc);
            }
        } else if ("tcClosed".equals(evt.getPropertyName())) {
            LOG.fine("Component closed, invoking update through invokeLater...");
            TopComponent tc = TopComponent.getRegistry().getActivated();
            if (tc == this.navigatorTC) {
                LOG.fine("navigator active, clearing its activated nodes");
                this.navigatorTC.setActivatedNodes(new Node[0]);
            }
            EventQueue.invokeLater(this);
        }
    }

    public void nodeDestroyed(NodeEvent ev) {
        LOG.fine("Node destroyed reaction...");
        if (((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            LOG.fine("NavigatorTC active, skipping node destroyed reaction.");
            return;
        }
        LOG.fine("invokeLater on updateContext from node destroyed reaction...");
        EventQueue.invokeLater(this);
    }

    public void childrenAdded(NodeMemberEvent ev) {
    }

    public void childrenRemoved(NodeMemberEvent ev) {
    }

    public void childrenReordered(NodeReorderEvent ev) {
    }

    @Override
    public void run() {
        this.updateContext(true);
    }

    private void cacheLastSelPanel(NavigatorPanel panel) {
        String mime = this.findMimeForContext();
        if (mime != null) {
            String className = panel.getClass().getName();
            NbPreferences.forModule(NavigatorController.class).put(mime, className);
            LOG.fine("cached " + className + "for mime " + mime);
        }
    }

    private NavigatorPanel getLastSelPanel(List<NavigatorPanel> panels) {
        String mime = this.findMimeForContext();
        if (mime == null) {
            return null;
        }
        String className = NbPreferences.forModule(NavigatorController.class).get(mime, null);
        if (className == null) {
            return null;
        }
        LOG.fine("found cached " + className + "for mime " + mime);
        for (NavigatorPanel curPanel : panels) {
            if (!className.equals(curPanel.getClass().getName())) continue;
            LOG.fine("returning cached " + className + "for mime " + mime);
            return curPanel;
        }
        return null;
    }

    private String findMimeForContext() {
        Collection hints;
        if (this.curHintsRes != null && !(hints = this.curHintsRes.allInstances()).isEmpty()) {
            return ((NavigatorLookupHint)hints.iterator().next()).getContentType();
        }
        FileObject fob = (FileObject)this.getClientsLookup().lookup(FileObject.class);
        if (fob != null) {
            return fob.getMIMEType();
        }
        return null;
    }

    private Lookup getSelectedPanelLookup() {
        Lookup panelLkp;
        NavigatorPanel selPanel = this.navigatorTC.getSelectedPanel();
        if (selPanel != null && (panelLkp = selPanel.getLookup()) != null) {
            return panelLkp;
        }
        return null;
    }

    ClientsLookup getClientsLookup() {
        return this.clientsLookup;
    }

    class ClientsLookup
    extends ProxyLookup {
        ClientsLookup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beforeLookup(Lookup.Template<?> template) {
            Lookup[] curNodesLookups;
            super.beforeLookup(template);
            Object object = NavigatorController.this.CUR_NODES_LOCK;
            synchronized (object) {
                curNodesLookups = new Lookup[NavigatorController.this.curNodes.size()];
                int i = 0;
                Iterator it = NavigatorController.this.curNodes.iterator();
                while (it.hasNext()) {
                    curNodesLookups[i] = ((Node)it.next()).getLookup();
                    ++i;
                }
            }
            this.setLookups(curNodesLookups);
        }

        Lookup[] obtainLookups() {
            return this.getLookups();
        }
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        @Override
        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                LOG.fine("invokeLater on updateContext from ActNodeSetter");
                SwingUtilities.invokeLater(this);
            } else {
                LOG.fine("Calling updateContext from ActNodeSetter");
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    private final class PanelLookupListener
    implements LookupListener,
    Runnable {
        private PanelLookupListener() {
        }

        public void resultChanged(LookupEvent ev) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            NavigatorController.this.updateActNodesAndTitle();
        }
    }

    private final class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup selLookup = NavigatorController.this.getSelectedPanelLookup();
            return selLookup != null ? selLookup : Lookup.EMPTY;
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)NavigatorController.this.navigatorTC)) || focusOwner instanceof JComboBox) {
                return;
            }
            TopComponent prevFocusedTc = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (prevFocusedTc != null) {
                prevFocusedTc.requestActive();
            }
        }
    }
}

