/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.text.BadLocationException;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileSourceRewriter
implements SourceRewriter {
    JavaFileObject sourcefile;
    PrintWriter out;
    File outFile;

    public FileSourceRewriter(JavaFileObject sourcefile) throws IOException {
        this(sourcefile, null);
    }

    public FileSourceRewriter(JavaFileObject sourcefile, String encoding) throws IOException {
        this.sourcefile = sourcefile;
        String srcFile = sourcefile.toString();
        File f = new File(srcFile);
        if (!f.exists()) {
            throw new FileNotFoundException(srcFile);
        }
        if (!f.canWrite()) {
            throw new IOException("cannot write to " + srcFile);
        }
        this.outFile = new File(sourcefile.toUri().getPath() + ".tmp");
        OutputStreamWriter fileWriter = encoding != null && encoding.length() > 0 ? new OutputStreamWriter((OutputStream)new FileOutputStream(this.outFile), encoding) : new FileWriter(this.outFile);
        this.out = new PrintWriter(new BufferedWriter(fileWriter));
    }

    @Override
    public void writeTo(String s) throws IOException, BadLocationException {
        this.out.print(s);
    }

    @Override
    public void skipThrough(SourceReader in, int offset) throws IOException, BadLocationException {
        in.seek(offset);
    }

    @Override
    public void copyTo(SourceReader in, int offset) throws IOException {
        char[] buf = in.getCharsTo(offset);
        this.out.write(buf);
    }

    @Override
    public void copyRest(SourceReader in) throws IOException {
        int i;
        char[] buf = new char[4096];
        while ((i = in.read(buf)) > 0) {
            this.out.write(buf, 0, i);
        }
    }

    @Override
    public void close(boolean save) throws IOException {
        this.out.close();
        this.out = null;
        if (save) {
            String path = this.sourcefile.toUri().getPath();
            File f = new File(path);
            File old = new File(path + '~');
            if (old.exists() && !old.delete()) {
                throw new IOException("failed deleting backup file: " + old);
            }
            if (!f.renameTo(old)) {
                throw new IOException("failed renaming (" + path + ") to backup (" + old + ")");
            }
            f = new File(path);
            if (!this.outFile.renameTo(f)) {
                throw new IOException("failed renaming new output file (" + this.outFile + ") to path (" + path + ")");
            }
            this.outFile = f;
            FileObject fo = FileUtil.toFileObject((File)this.outFile);
            if (fo != null) {
                fo.refresh(true);
            }
        }
    }
}

